/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCWIN.H
//
//  Description:The header file for the class: CTraceWindow
//              derived from original CTraceWindow and CTraceView
//  Author:     Chris Fang
//
//  Date:       5/05/97
//
//  Modification:
//
//      1. 5/05/97, Initial version
//
//
//  Copyright (C) 1997 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// tracewin.h : header file
//

#ifndef _TRCWIN_
#define _TRCWIN_

#include "trcpub.h"			//trace server
#include "uicom2.h"

struct	COLDATA
	{
		CString	strTitle;
		int		nPosx;
		int		nWidth;
	};

void TrcOpenWindow(CMDIFrameWnd * pParent);

/////////////////////////////////////////////////////////////////////////////
// CTraceWindow frame

class CTraceWindow : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CTraceWindow)
public:
	CTraceWindow();			// protected constructor used by dynamic creation
	BOOL Create(LONG style = 0,
		const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL);
		
	enum { TRACEMODE_BUS = 1, TRACEMODE_INSTRUCTION};	

//member data
private:
	//about show attributes
	int				m_nCharWidth;		//init at OnCreate
	int				m_nTitleHeight;
	int				m_nLineHeight;		//init at OnCreate
	int				m_nColnum;			//current mode column number
	COLDATA			m_cdData[7];		//simulate max column is 7
	int				m_nLineWidth;		//width of entire one frame line.
	BOOL			m_bHscOn;           //horizontal scrollbar on
	BOOL			m_bVscOn;           //vertical scrollbar on 
	int				m_nScrUnit;
	int				m_nHscMaxpos;
	int				m_nLeftfrom;		//current hscroll pos is -m_nLeftfrom
	BOOL			m_bIconic;
	int				m_nPrevcx;
	int				m_nPrevcy;
	//about show data
	DWORD			m_dwLastFrame;		//frame number of FW trace buffer.
										//max vscroll pos is m_dwLastFrame
	DWORD			m_dwCurFrame;		//frame number of first line in window
										//equal current vscroll pos
	BYTE			m_byCurInt; 		// first byte or second byte of the frame										
	WORD			m_wLines;			//line number of window(inc title)
	WORD			m_wFrameLines;		//the number of line contain frame 
										//data. which <m_wLines
	int				m_nReadDirect;		//init before call PrepareData
	FrameData*		m_pBusBuffer;		//point to the buffer alloced by server.
	InsData*		m_pInsBuffer;

	BOOL			m_bCurSorLink;
	WORD			m_wCLLineIndex;		//      
	
	
public:

//member function
private:
	void			SetColData(void);
	void			PrepareData(void);
	void			OnBufferChange(void);
	void			DrawStatic(LPCSTR, UINT, RECT, CDC*);
	void			ShowTitle(CPaintDC* pdc);
	void			ShowLine(int y, int lineno, CPaintDC* pdc);
	void			RepaintLine(int nLine);
	void			SetWindowTitle(UINT nPos);
	void			OnModeChange();
	void			CLShowSrc(void);
	
	long			SearchBus(int begin);
	long			SearchIns(int begin);

public:

// Implementation
protected:
	static CMenu NEAR m_menu;    

	virtual ~CTraceWindow();

	// Generated message map functions
	//{{AFX_MSG(CTraceWindow)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnViewRefresh();
	afx_msg void OnEditGotostartframe();
	afx_msg void OnEditGotoendframe();
	afx_msg void OnEditGotoframe();
	afx_msg void OnFileSavetrace();
	afx_msg void OnTraceFilter();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTraceEvent();
	afx_msg void OnTraceControl();
	afx_msg void OnTraceClear();
	afx_msg void OnUpdateTraceClear(CCmdUI* pCmdUI);
	afx_msg void OnTraceTrigger();
	afx_msg void OnViewCursorlink();
	afx_msg void OnUpdateViewCursorlink(CCmdUI* pCmdUI);
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	afx_msg void OnViewBus();
	afx_msg void OnUpdateViewBus(CCmdUI* pCmdUI);
	afx_msg void OnViewInstruction();
	afx_msg void OnUpdateViewInstruction(CCmdUI* pCmdUI);
	afx_msg void OnEditSearch();
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnEditSearchnext();
	afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
