/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTBASE.CPP
//
//  Description: The implementation file for the class: CFileBase.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CFileBase.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tstbase.h"
//#include "hosterrs.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CFileBase.

// Construction.
CFileBase::CFileBase()
{
    // Initial.
    m_strFileName.Empty();
    m_nErrorID = NO_ERROR;
    m_nOpenFlag = CFile::typeText;
    
    m_pszLineBuf = 0;
    
}   // End of CFileBase::CFileBase().


// Destruction.
CFileBase::~CFileBase()
{

}   // End of CFileBase::~CFileBase().


// Open a file.
void CFileBase::OpenFile(void)
{
    // Assertion of the input parameters.
    ASSERT( !m_strFileName.IsEmpty() );
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Open a special file.
    if ( !Open(m_strFileName, m_nOpenFlag) ) {
        m_nErrorID = OPEN_ERROR;
    }

}   // End of CFileBase::OpenFile().


// Close a file.
void CFileBase::CloseFile(void)
{
    // Assertion of the input parameters.
    //ASSERT( !m_strFileName.IsEmpty() );
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Close a special file.
    if ( !m_strFileName.IsEmpty() ) {
    	Close();
    }	

}   // End of CFileBase::CloseFile().


// Write data to a file.
void CFileBase::WriteToFile(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pszLineBuf );
    
    // Write to the file.
    WriteString(m_pszLineBuf);

}   // End of CFileBase::WriteToFile().


// Read data from a file.
void CFileBase::ReadFromFile(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pszLineBuf );
	
	//if ( CStdioFile::m_pStream == NULL) 
	if (m_strFileName.IsEmpty())
		return;
	
    // Read a line contents.
    if ( !ReadString(m_pszLineBuf, maxChar) ) {
        m_nErrorID = FILE_END;
        return;
    }
    
    // Over than 255 characters in ONE line.
    int i = (int) strlen(m_pszLineBuf);
    if ( maxChar-1 == i  && '\n' != *(m_pszLineBuf+i-1) ) {
        m_nErrorID = LONG_LINE;
    }
    
    // Filter the illegal characters.
    char* p = m_pszLineBuf;
    while ( *p ) {
        if ( *p < MIN_KEY || *p > MAX_KEY ) {
            *p = MIN_KEY;
        }
        p++;
    }

}   // End of CFileBase::ReadFromFile().


// Display the error message.
void CFileBase::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > NO_ERROR && m_nErrorID < MAX_ERROR );
    
    // Define the error message.
    
    char* pszErrorMsg[] = {
        "",
        "Log file existed already.",
        "No Log file opened.",
        "File open error.",
        "File close error.",
        "File read error.",
        "File write error.",
        "End of Include file.",
        "More than 255 characters in one line.",
        "Not an Include inner command.",
        "Include sub-command error.",
        "Include sub-command error: Syntax error.",
        "Include sub-command error: Invalid COUNT.",
        "Include sub-command error: Invalid LABEL.",
        "Include sub-command error: LABEL cannot matched.",
        "Include sub-command error: More than 256 LOOP nested.",
        "Include sub-command error: Invalid LOOPEND.",
        "Include sub-command error: IF,IF_NOT & ELSE statement cannot nest.",
        "Include sub-command error: ELSE without IF or IF_NOT statement.",
        "Include sub-command error: No expected {.",
        "Include sub-command error: No expected }.",
        "Include sub-command error: { and } unmatched.",
        "Abort by user.",  
        //Macro command             
        "The macro is not exist.",     
        "End of Macro file.",
        "Not a Macro inner command.",
        "Macro sub-command error.",
        "Macro sub-command error: Syntax error.",
        "Macro sub-command error: IF,IF_NOT & ELSE statement cannot nest.",
        "Macro sub-command error: ELSE without IF or IF_NOT statement.",
        "Macro sub-command error: No expected {.",
        "Macro sub-command error: No expected }.",
        "Macro sub-command error: { and } unmatched.",
        "Abort by user.",                             
        "Macro sub-command error: Invalid COUNT.",
        "Macro sub-command error: Invalid LABEL.",
        "Macro sub-command error: LABEL cannot matched.",
        "Macro sub-command error: More than 256 LOOP nested.",
        "Macro sub-command error: Invalid LOOPEND.",
        ""
    };                                
    
    ShowLine(pszErrorMsg[m_nErrorID]);
    
/*
    // Display the corresponding error message.
   	char* pszErr = new char[256];
   	if (m_nErrorID == FILE_END) {
		ErrGetErrorText(ER_TST_FILE_END, pszErr);   	
   	}
   	else if (m_nErrorID == MACRO_FILE_END) {
		ErrGetErrorText(ER_TST_MACRO_FILE_END, pszErr);   	
   	}
	else {
    	ErrGetErrorText(ER_TST_BASE + m_nErrorID, pszErr);
    }	
    ShowLine(pszErr);
    delete []pszErr;
*/
    

}   // End of CFileBase::DisplayErrorMessage().


// Convert string to unsigned long value.
void CFileBase::StrToVar(char* pszConvStr)
{
    // Assertion of the input parameters.
    ASSERT( pszConvStr );
    
    // Convertion.
    char* pszStopStr;
    m_ulVar = strtoul(pszConvStr, &pszStopStr, 16);

}   // End of CFileBase::StrToVar().

//////////////////////////////// End of File ////////////////////////////////
