/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTBASE.H
//
//  Description: The header file for the class: CFileBase.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CFileBase.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TSTBASE_
#define _TSTBASE_

#include "syntest.h"


/////////////////////////////////////////////////////////////////////////////
// CFileBase class.
class CFileBase : public CStdioFile, public CSyntaxTest
{
// Construction & Destruction.
public:
    CFileBase();
    ~CFileBase();
    
// Member variables.
public:
    // File operation error.
    enum {  // No error.
            NO_ERROR = 0,
            // For Log command.
            LOG_EXIST,
            LOG_UNOPEN,
            // File basic operation.
            OPEN_ERROR,
            CLOSE_ERROR,
            READ_ERROR,
            WRITE_ERROR,
            // For Include command.
            FILE_END,
            LONG_LINE,
            // Include inner command error.
            NOT_INNER,
            INNER_ERROR,
            INNER_ERROR_SYNTAX,
            INNER_ERROR_COUNT,
            INNER_ERROR_LABEL,
            INNER_ERROR_GOTO,
            INNER_ERROR_LOOP,
            INNER_ERROR_LOOPEND,
            INNER_ERROR_IF,
            INNER_ERROR_ELSE,
            INNER_ERROR_BEGIN,
            INNER_ERROR_END,
            INNER_ERROR_MATCH,
            INNER_ERROR_ESC,    
            //Macro Error
			DELETE_MACRO_ERROR,   
			MACRO_FILE_END,
            // Macro inner command error.
            NOT_MACRO_INNER,
            INNER_MACRO_ERROR,
            INNER_MACRO_ERROR_SYNTAX,
            INNER_MACRO_ERROR_IF,
            INNER_MACRO_ERROR_ELSE,
            INNER_MACRO_ERROR_BEGIN,
            INNER_MACRO_ERROR_END,
            INNER_MACRO_ERROR_MATCH,
            INNER_MACRO_ERROR_ESC,
            INNER_MACRO_ERROR_COUNT,
            INNER_MACRO_ERROR_LABEL,
            INNER_MACRO_ERROR_GOTO,
            INNER_MACRO_ERROR_LOOP,
            INNER_MACRO_ERROR_LOOPEND,            
            // Maximum error.
            MAX_ERROR
    };
    int m_nErrorID;

protected:
    // File name.    
    CString m_strFileName;
    
    // File open mode.
    int m_nOpenFlag;
    
    // One line contents.
    enum { MIN_KEY = 0x20, MAX_KEY = 0x7F };
    enum { maxChar = 255 };
    char* m_pszLineBuf;

    // Used by StrToVar().
    unsigned long m_ulVar;

// Implementations.
protected:
    void OpenFile(void);
    void CloseFile(void);
    void ReadFromFile(void);
    void WriteToFile(void);

    void StrToVar(char* pszConvStr);

    void DisplayErrorMessage(void) const;

};  // End of class: CFileBase.

#endif
//////////////////////////////// End of File ////////////////////////////////
