/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTHELP.CPP
//
//  Description: The implementation file for the class: CHelp.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CHelp.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                     
#include "shlcom.h"                     
#include "tsthelp.h"
#include "aliaspub.h"
//#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
/*extern struct {
    char* pszCommandName;
    int nMinKeyword;
}extern tagCmdTable CommandRecord[];*/
//Add by Annie, 4/1/96
//extern tagCmdTable* CommandRecord;

// Maximum number of command.
//extern int nMaxCmdNo;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void HelpCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HelpCmd().
//
//  Description: The main control routine of Help command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////

void HelpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }         
    	    
    // Execute Help command.
    CHelp* pHelp = new CHelp;
    if ( !pHelp ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pHelp->HelpAction(nArgc, pszArgv);
        delete pHelp;
    }
    
}   // End of HelpCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CHelp.

// Construction.
CHelp::CHelp()
{
    // Command list help file.
    extern char szAppPath[_MAX_PATH+1];
    m_strFileName = szAppPath;
    m_strFileName += "CMDLIST.DAT";
    m_nOpenFlag |= CFile::modeRead;
    
    // Allocate a space.
    m_pszOneLine = new char[maxChar+1];
    if ( !m_pszOneLine ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    
    // Initial.
    m_isSingleCmd = FALSE;
    m_strCommand.Empty();

}   // End of CHelp::CHelp().


// Destruction.
CHelp::~CHelp()
{
    // Release the allocated space.
    if ( m_pszOneLine ) {
        delete []m_pszOneLine;
    }

}   // End of CHelp::~CHelp().


// Help command.
void CHelp::HelpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Parse the parameters.
    switch ( nArgc ) {
        case 1:
            break;
        case 2:
            m_isSingleCmd = TRUE;
            m_strCommand = strlwr((pszArgv[1]));
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Help kernel.
    HelpKernel();

}   // End of CHelp::HelpAction().


// Help kernel routine.
void CHelp::HelpKernel(void)
{
    // Assertion of the input parameters.
    ASSERT( NO_ERROR == m_nErrorID );
    ASSERT( m_pszOneLine );
    if ( !m_pszOneLine ) {
        return;
    }
    
    // Search the command keyword table.
    int nIndex;
    if ( m_isSingleCmd ) {
    /*
        for ( nIndex = 0; nIndex < ::nMaxCmdNo; nIndex++ ) {
            CString strTable(CommandRecord[nIndex].pszCommandName);
            strTable.MakeLower();
            if ( m_strCommand == strTable ) {
                break;
            }
        }
        if ( ::nMaxCmdNo == nIndex ) {
            ShowLine("No such command.");
            return;
        }                           
    }*/
		int nRet = GetCommandId(m_strCommand);
		if (nRet == CCommandSet::NO_COMMAND) {
			ShowLine("No such command.");
	        //char pchText[256];
	        //ErrGetErrorText(ER_NO_SUCH_COMMAND, pchText);
	        //ShowLine(pchText);

            return;			
		}    	   
		else {
			nIndex = nRet;			
		}               
	}	
    
    // Open the help contents file: CMDLIST.HLP
    OpenFile();
    if ( NO_ERROR != m_nErrorID ) {
        ShowLine("CMDLIST.DAT cannot be opened.");
        //char pchText[256];
        //ErrGetErrorText(ER_NO_CMDLIST, pchText);
        //ShowLine(pchText);

        return;
    }
    
    // Read one line help contents and display it.
    m_pszLineBuf = m_pszOneLine;
    int nCmdCount = -1;
    do {
        ReadFromFile();
        if ( NO_ERROR != m_nErrorID ) {
            if ( FILE_END != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
            break;
        }
        else {
            if ( m_isSingleCmd ) {
                if ( ' ' != *m_pszOneLine ) {
                    nCmdCount++;
                }
                if ( nCmdCount == nIndex ) {
                    ShowLine(m_pszOneLine);
                }
            }
            else {
                ShowLine(m_pszOneLine);
            }
        }
    } while ( TRUE );
    
    // Close the help contents file: CMDLIST.HLP
    m_nErrorID = NO_ERROR;
    CloseFile();

}   // End of CHelp::HelpKernel().


//////////////////////////////// End of File ////////////////////////////////
