/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTINC.H
//
//  Description: The header file for the class: CIncludeFile.
//
//  Author: Chen Jun
//
//  Date: 05/23/95
//
//  Modification:
//      1. 05/23/95, Initial version of the class: CIncludeFile.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TSTINC_
#define _TSTINC_

#include "tstbase.h"


/////////////////////////////////////////////////////////////////////////////
// CIncludeFile class.
class CIncludeFile : public CFileBase
{
// Construction & Destruction.
public:
    CIncludeFile();
    ~CIncludeFile();
    
// Member variables.
private:
    char m_pszOneLine[maxChar+1];
    enum { TOKEN_KEY = 0x20 };

    // Parameter token.
    int m_nArgc;
    char* m_pszArgv[(maxChar+1)/2];

    // Inner error.
    int m_nCommandID;
    enum { minInner = 0,
           INC_BELL = minInner,
           INC_ERROR,
           INC_GOTO,
           INC_IF,
           INC_IFNOT,
           INC_ELSE,
           INC_BEGINMARK,
           INC_ENDMARK,
           INC_LOOP,
           INC_LOOPEND,
           INC_PAUSE,
           INC_REM,
           INC_WAIT,
           maxInner = INC_WAIT
    };
    
    // Error.
    BOOL m_isStop;

    // Goto Label.
    char m_pszLabel[maxChar-5+1];
                      
    // Loop & Loopend.
    enum { maxLoop = 256 };     

    // If, If_not & Else.
    char m_pszCondition[maxChar+1];
    BOOL m_isMatchedIF;
    BOOL m_isMatchedELSE;
    BOOL m_isSkipELSE;

    // { & }.
    BOOL m_isMatchedBegin;
    
    long m_lLoopIndex;
    long m_lLoopCount[maxLoop];
    DWORD m_dwLoopPos[maxLoop];
    
public:
    BOOL m_isEOF;
    enum { maxFileNo = 5};//20 };

// Implementations.
private:
    void CheckInnerCommand(char* pszIncLine);
    BOOL CommandParse(void);
    void CommandKernel(void);
    void ExecuteInnerCommand(void);

    void IncludeBell(void);
    void IncludeError(void);
    void IncludeGoto(void);
    void IncludeIf(void);
    void IncludeIfnot(void);
    void IncludeElse(void);
    void IncludeLoop(void);
    void IncludeLoopend(void);
    void IncludePause(void);
    void IncludeRem(void);
    void IncludeBeginMark(void);
    void IncludeEndMark(void);
    void IncludeWait(void);
    
    BOOL IsLabel(char* pszArgv) const;
    
    void GotoLabel(void);

    BOOL JudgeCondition(void);
    void PassBlockBranch(void);
    BOOL SearchELSE(void);
    void SkipELSE(void);

    int TestKey(WORD wKey);
    
public:
    BOOL IncludeAction(int nArgc, char* pszArgv[]);

    void ReadOneLine(char* pszBuf);
    BOOL IncludeFilter(char* pszIncLine);

};  // End of class: CIncludeFile.

#endif
//////////////////////////////// End of File ////////////////////////////////
