/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTLOG.CPP
//
//  Description: The implementation file for the class: CLogFile.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CLogFile.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tstlog.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CLogFile LogFile;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void LogCmd(int nArgc, char* pszArgv[]);
void TstLogInfo(char* pchBuf, int nLen=0);

int TstGetLogOn(void);
int TstGetLogCommand(void);
int TstGetLogAppend(void);
int TstGetLogOpened(void);

void TstSetLogOn(int nLogOn);
void TstSetLogCommand(int nLogCommand);
void TstSetLogAppend(int nLogAppend);
void TstSetLogOpened(int nLogOpened);

void TstOpenLog(CString strFileName);
void TstCloseLog(void);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Supply the global flag to the Log dialog.
int TstGetLogOn(void)
{
    return ((int)LogFile.m_isLogOn);
    
}   // End of TstGetLogOn().

int TstGetLogCommand(void)
{
    return ((int)LogFile.m_isLogCommand);
    
}   // End of TstGetLogCommand().

int TstGetLogAppend(void)
{
    return ((int)LogFile.m_isLogAppend);
    
}   // End of TstGetLogAppend().

int TstGetLogOpened(void)
{
    return ((int)LogFile.m_isLogOpened);
    
}   // End of TstGetLogOpened().

void TstSetLogOn(int nLogOn)
{
    LogFile.m_isLogOn = (BOOL) nLogOn;

}   // End of TstSetLogOn().

void TstSetLogCommand(int nLogCommand)
{
    LogFile.m_isLogCommand = (BOOL) nLogCommand;

}   // End of TstSetLogCommand().

void TstSetLogAppend(int nLogAppend)
{
    LogFile.m_isLogAppend = (BOOL) nLogAppend;

}   // End of TstSetLogAppend().

void TstSetLogOpened(int nLogOpened)
{
    LogFile.m_isLogOpened = (BOOL) nLogOpened;

}   // End of TstSetLogOpened().

void TstOpenLog(CString strFileName)
{
    // Assertion of the input parameters.
    ASSERT( !strFileName.IsEmpty() );
    
    // Open log file.
    LogFile.OpenLog(strFileName);
    
}   // End of TstOpenLog().

void TstCloseLog(void)
{
    // Close log file.
    LogFile.CloseLog();

}   // End of TstCloseLog().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   LogCmd().
//
//  Description: The main control routine of Log command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void LogCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 2 && nArgc <= 4 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Log command.
    LogFile.LogAction(nArgc, pszArgv);

}   // End of LogCmd().


// Log information to the Log file.
void TstLogInfo(char* pchBuf, int nLen)
{
    // Assertion of the input parameters.
    ASSERT( pchBuf );
    ASSERT( nLen >= 0 && nLen <= 256 );
    
    // Log information to the Log file.
    LogFile.LogInfo(pchBuf, nLen);
    
}   // End of TstLogInfo().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CLogFile.

// Construction.
CLogFile::CLogFile()
{
    // Initial.
    m_isLogOn = FALSE;
    m_isLogCommand = FALSE;
    m_isLogAppend = FALSE;
    m_isLogOpened = FALSE;
    m_nOpenFlag |= CFile::modeWrite;
    
}   // End of CLogFile::CLogFile().


// Destruction.
CLogFile::~CLogFile()
{
    // Close the Log file.
    if ( m_isLogOpened ) {
        CloseFile();
    }
     
}   // End of CLogFile::~CLogFile().


// LOG          {filename [Result] [Append]} | {ON|OFf|Close}
void CLogFile::LogAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 2 && nArgc <= 4 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Parse the parameters.
    CString strArgv;
    switch ( nArgc ) {
        case 2:
            // Log filename|ON|OFf|Close
            strArgv = pszArgv[1];
            if ( !strArgv.CompareNoCase("ON") ) {
                if ( !m_isLogOpened ) {
                    m_nErrorID = LOG_UNOPEN;
                }
                else {
                    m_isLogOn = TRUE;
                }
            }
            else if ( !strArgv.CompareNoCase("OFF") ) {
                if ( !m_isLogOpened ) {
                    m_nErrorID = LOG_UNOPEN;
                }
                else {
                    m_isLogOn = FALSE;
                }
            }
            else if ( !strArgv.CompareNoCase("CLOSE") ) {
                if ( !m_isLogOpened ) {
                    m_nErrorID = LOG_UNOPEN;
                }
                else {
                    CloseFile();
                    m_isLogOpened = FALSE;
                    m_isLogOn = FALSE;
                    m_isLogCommand = FALSE;
                    m_isLogAppend = FALSE;
                    m_nOpenFlag = CFile::typeText|CFile::modeWrite;
                }
            }
            else {
                if ( m_isLogOpened ) {
                    m_nErrorID = LOG_EXIST;
                }
                else {
                    m_strFileName = pszArgv[1];
                    m_nOpenFlag |= CFile::modeCreate;
                    OpenFile();
                    if ( NO_ERROR == m_nErrorID ) {
                        m_isLogOpened = TRUE;
                        m_isLogOn = TRUE;
                        m_isLogAppend = FALSE;
                        m_isLogCommand = FALSE;
                    }
                }
            }
            break;
        case 3:
            // Log filename Command|Append
            if ( m_isLogOpened ) {
                m_nErrorID = LOG_EXIST;
            }
            else {
                m_strFileName = pszArgv[1];
                strArgv = pszArgv[2];
                if ( !strArgv.CompareNoCase("COMMAND") ) {
                    m_isLogCommand = TRUE;
                    m_isLogAppend = FALSE;
                    m_nOpenFlag |= CFile::modeCreate;
                    OpenFile();
                }
                else {
                    m_isLogAppend = TRUE;
                    m_isLogCommand = FALSE;
                    OpenFile();
                    if ( NO_ERROR != m_nErrorID ) {
                        m_nOpenFlag |= CFile::modeCreate;
                        OpenFile();
                    }
                }
                if ( NO_ERROR == m_nErrorID ) {
                    m_isLogOpened = TRUE;
                    m_isLogOn = TRUE;
                }
            }
            break;
        case 4:
            // Log filename {Command Append} | {Append Command}
            if ( m_isLogOpened ) {
                m_nErrorID = LOG_EXIST;
            }
            else {
                m_strFileName = pszArgv[1];
                OpenFile();
                if ( NO_ERROR != m_nErrorID ) {
                    m_nOpenFlag |= CFile::modeCreate;
                    OpenFile();
                }
                if ( NO_ERROR == m_nErrorID ) {
                    m_isLogOpened = TRUE;
                    m_isLogCommand = TRUE;
                    m_isLogAppend = TRUE;
                    m_isLogOn = TRUE;
                }
            }
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Display error message.
    if ( NO_ERROR != m_nErrorID ) {
        DisplayErrorMessage();
        m_nErrorID = NO_ERROR;
    }
        
}   // End of CLogFile::LogAction().


// Log information to the Log file.
void CLogFile::LogInfo(char* pchBuf, int nLen)
{
    // Assertion of the input parameters.
    ASSERT( pchBuf );
    ASSERT( nLen >= 0 && nLen <= 256 );
    
    // Log file is off.
    if ( !m_isLogOn ) {
        return;
    }
         
    // Log command only.
    char pszBuf[258];
    if ( 0 == nLen ) {
        // Log the results.
        if ( m_isLogCommand ) {
            return;
        }
        else {
            strcpy(pszBuf, " ");
            strcat(pszBuf, pchBuf);
            strcat(pszBuf, "\n");
        }
    }
    else {
        // Log user's commands.
        memcpy(pszBuf, pchBuf, nLen);
        pszBuf[nLen] = '\n';
        pszBuf[nLen+1] = 0;
    }

    // Write to Log file.
    m_pszLineBuf = pszBuf;
    WriteToFile();

}   // End of CLogFile::LogInfo().


// Open log file from Log dialog.
void CLogFile::OpenLog(CString strFileName)
{
    // Assertion of the input parameters.
    ASSERT( !strFileName.IsEmpty() );

    // Set the server flag.
    m_isServer = TRUE;

    // Open log file.
    if ( m_isLogOpened ) {
        m_nErrorID = LOG_EXIST;
    }
    else {
        m_strFileName = strFileName;
        m_nOpenFlag = CFile::typeText|CFile::modeWrite;
        if ( !m_isLogAppend ) {
            m_nOpenFlag |= CFile::modeCreate;
        }
        OpenFile();
        if ( NO_ERROR != m_nErrorID ) {
            m_nErrorID = NO_ERROR;
            m_nOpenFlag |= CFile::modeCreate;
            OpenFile();
        }
        if ( NO_ERROR == m_nErrorID ) {
            m_isLogOpened = TRUE;
            m_isLogOn = TRUE;
        }
    }

    // Display error message.
    if ( NO_ERROR != m_nErrorID ) {
        DisplayErrorMessage();
        m_nErrorID = NO_ERROR;
    }
    
}   // End of CLogFile::OpenLog().


// Close log file from Log dialog.
void CLogFile::CloseLog(void)
{
    // Assertion of the input parameters.

    // Set the server flag.
    m_isServer = TRUE;

    // Close log file.
    if ( !m_isLogOpened ) {
        m_nErrorID = LOG_UNOPEN;
    }
    else {
        CloseFile();
        m_isLogOpened = FALSE;
        m_isLogOn = FALSE;
        m_isLogCommand = FALSE;
        m_isLogAppend = FALSE;
        m_nOpenFlag = CFile::typeText|CFile::modeWrite;
    }

    // Display error message.
    if ( NO_ERROR != m_nErrorID ) {
        DisplayErrorMessage();
        m_nErrorID = NO_ERROR;
    }

}   // End of CLogFile::CloseLog().

//////////////////////////////// End of File ////////////////////////////////
