/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTTEMP.CPP
//
//  Description: The implementation file for the class: CTempFile.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CTempFile.
//      2. 09/08/95, Fix bug 3, 35, "CTempFile::AppendStock()".
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tsttemp.h"
//#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CTempFile* pTempFile = 0;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void TstCreateStock(void);
void TstDestroyStock(void);
void TstOpenStock(void);
void TstCloseStock(void);
void TstAppendStock(char* pszPrompt, char* pszResult);
BOOL TstQueryStock(char* pszResult);
void DisplayOutOfMemory(void);

#ifdef _CHEN_
    void Calculate(int nArgc, char* pszArgv[]);
#endif  // _CHEN_


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Create the temporary stock.
void TstCreateStock(void)
{
    // Assertion of the input parameters.
    
    // Create the stock.
    if ( !pTempFile ) {
        pTempFile = new CTempFile;
        if ( !pTempFile ) {
            //AfxMessageBox("Insufficient Memory !");
            DisplayOutOfMemory();
            ASSERT( FALSE );
            return;
        }
    }
    
}   // End of TstCreateStock().


// Destroy the temporary stock.
void TstDestroyStock(void)
{
    // Assertion of the input parameters.
    
    // Destroy the stock.
    if ( pTempFile ) {
        delete pTempFile;
        pTempFile = 0;
    }
    
}   // End of TstDestroyStock().


// Open the stock.
void TstOpenStock(void)
{
    // Assertion of the input parameters.
    
    // The stock is now opened.
    if ( pTempFile ) {
        pTempFile->OpenStock();
    }

}   // End of TstOpenStock().


// Close the stock.
void TstCloseStock(void)
{
    // Assertion of the input parameters.
    
    // The stock is now Closeed.
    if ( pTempFile ) {
        pTempFile->CloseStock();
    }

}   // End of TstCloseStock().


// Append to the temporary stock.
void TstAppendStock(char* pszPrompt, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszPrompt );
    ASSERT( pszResult );
    
    // Append to the stock.
    if ( pTempFile ) {
        pTempFile->AppendStock(pszPrompt, pszResult);
    }

}   // End of TstAppendStock().


// Query from the temporary stock.
BOOL TstQueryStock(char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszResult );
    
    // Query from the stock.
    if ( pTempFile ) {
        return (pTempFile->QueryStock(pszResult));
    }
    else {
        ASSERT( FALSE );
        return (FALSE);
    }

}   // End of TstQueryStock().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CTempFile.

// Construction.
CTempFile::CTempFile()
{
    // Initial.
    extern char szAppPath[_MAX_PATH+1];
    m_strFileName = szAppPath;
    m_strFileName += "~!@#$%^&.()";
    m_isOpened = FALSE;
    m_isExist = FALSE;

}   // End of CTempFile::CTempFile().


// Destruction.
CTempFile::~CTempFile()
{
    // Destroy the stock.
    if ( m_isExist ) {
        Remove(m_strFileName);
    }

}   // End of CTempFile::~CTempFile().


// Open the stock.
void CTempFile::OpenStock(void)
{
    // Assertion of the input parameters.

    // Open the stock.
    m_nOpenFlag = CFile::typeText | CFile::modeCreate | CFile::modeWrite;
    OpenFile();
    m_isExist = TRUE;
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Now the stock is opened.
    m_isOpened = TRUE;

}   // End of CTempFile::OpenStock().


// Close the stock.
void CTempFile::CloseStock(void)
{
    // Assertion of the input parameters.

    // Close the stock.
    CloseFile();
    
    // Now the stock is closed.
    m_isOpened = FALSE;
    
}   // End of CTempFile::CloseStock().


// Append the Shell Prompt & Command Result to the stock.
void CTempFile::AppendStock(char* pszPrompt, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszPrompt );
    ASSERT( pszResult );
    
    // The stock must be opened.
    if ( !m_isOpened ) {
        return;
    }
        
    // Append to the stock.
    strcpy(m_pszTempLine, pszPrompt);
    strcat(m_pszTempLine, pszResult);
    
    int nLen = strlen(m_pszTempLine);
    m_pszTempLine[nLen] = 0x0d;
    m_pszTempLine[nLen+1] = 0x0a;
    m_pszTempLine[nLen+2] = 0;
    
    m_pszLineBuf = m_pszTempLine;
    WriteToFile();
    
}   // End of CTempFile::AppendStock().


// Query information from the stock.
BOOL CTempFile::QueryStock(char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszResult );
    ASSERT( NO_ERROR == m_nErrorID );

    // Open the stock.
    m_nOpenFlag = CFile::typeText | CFile::modeRead;
    OpenFile();
    if ( NO_ERROR != m_nErrorID ) {
    	m_nErrorID = NO_ERROR;
    	return FALSE;
    }
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Query from the stock.
    do {
        m_pszLineBuf = m_pszTempLine;
        ReadFromFile();
        if ( NO_ERROR != m_nErrorID ) {
            break;
        }
        else {
            int nLen = strlen(m_pszTempLine);
            if ( nLen > 0 ) {
                if ( '\n' == *(m_pszTempLine+nLen-1) ) {
                    nLen -= 1;
                    *(m_pszTempLine+nLen) = 0;
                }
            }
            if ( strstr(m_pszTempLine, pszResult) ) {
                break;
            }
            else {
                continue;
            }
        }
    } while ( TRUE );

    // Close the stock.
    BOOL isRetValue = ( NO_ERROR == m_nErrorID ) ? TRUE : FALSE;
    m_nErrorID = NO_ERROR;
    CloseFile();
    
    // Return back.
    return (isRetValue);

}   // End of CTempFile::QueryStock().


//////////////////////////////// End of File ////////////////////////////////
