#include "stdafx.h"
#include "resource.h"  
                     
#include "colors.h"   

#include "ep196.h"                  
//#include "uicom1.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////                  
BOOL    isInsertOn = FALSE;     

/////////////////////////////////////////////////////////////////////////////
BOOL    isShellOn     = FALSE;

/////////////////////////////////////////////////////////////////////////////
CMDIChildWnd    * pShellWnd;                  

CString strIncludeFile;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DrawFrame
//
//  Description: Draw a rectangle frame
//
//  Input:  
//      pDC -- Pointer to CDC
//      rect -- the size and position of the frame
//      nConvex -- the shape of the frame
//                  1 -- Convex frame, 0 -- Concave frame
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void DrawFrame(CDC * pDC, CRect &rect, int nConvex)
{        
    CPen pen1(PS_SOLID, 1, PALETTEINDEX(COLOR_DKGRAY));    
    CPen pen2(PS_SOLID, 1, PALETTEINDEX(COLOR_WHITE));    
    CPen * penOld;
    
    pDC->MoveTo(rect.left, rect.bottom);

    if(nConvex) penOld = pDC->SelectObject(&pen2);
    else    penOld = pDC->SelectObject(&pen1);

    pDC->LineTo(rect.left, rect.top);
    pDC->LineTo(rect.right, rect.top);

    if(nConvex) pDC->SelectObject(&pen1);
    else    pDC->SelectObject(&pen2);

    pDC->LineTo(rect.right, rect.bottom);
    pDC->LineTo(rect.left, rect.bottom);

    pDC->SelectObject(penOld);
}             
                                             
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   TestKey
//
//  Description: Test if a specified key pressed
//
//  Input:  
//      wKey -- Key code
//
//  Output: None
//
//  Return: 1 -- The key has been pressed
//          0 -- The key not been pressed
//
/////////////////////////////////////////////////////////////////////////////
int TestKey(WORD wKey)
{   
    MSG msg;
    if(PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
        PM_NOREMOVE|PM_NOYIELD)) {
        PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
            PM_REMOVE|PM_NOYIELD);
        if(msg.message == WM_KEYDOWN && msg.wParam == wKey) 
            return  1;        
    }            
    return  0;
}

                                            

///////////////////////(EOF)/////////////////////////////////////////////////                               
