
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/VARADD.CPP   1.14   09 Jan 1997 14:26:38   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/VARADD.CPP  $
** 
**    Rev 1.0   13 Aug 1996 09:20:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARADD.CPP
//
//  Description: The implementation file fore class: CVarAddVariableDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarAddVariableDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varadd.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarAddVariableList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarAddVariable(void);


/////////////////////////////////////////////////////////////////////////////
// CVarAddVariableDialog dialog


CVarAddVariableDialog::CVarAddVariableDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarAddVariableDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarAddVariableDialog)
    m_strVariable = "";
    //}}AFX_DATA_INIT

    // Initial.
    m_isDropdown = FALSE;
}

void CVarAddVariableDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarAddVariableDialog)
    DDX_Control(pDX, IDC_COMBO_ADDVARIABLE_VARIABLE, m_comboVariable);
    DDX_CBString(pDX, IDC_COMBO_ADDVARIABLE_VARIABLE, m_strVariable);
    DDV_MaxChars(pDX, m_strVariable, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarAddVariableDialog, CDialog)
    //{{AFX_MSG_MAP(CVarAddVariableDialog)
    ON_CBN_DROPDOWN(IDC_COMBO_ADDVARIABLE_VARIABLE, OnDropdownComboVariable)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarAddVariableDialog message handlers

void CVarAddVariableDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarAddVariableDialog::OnOK()
{
    // TODO: Add extra validation here

    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        ::pVarAddVariableList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboVariable.GetCount(); i++ ) {
            m_comboVariable.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                ::pVarAddVariableList->AddTail(str);
            }
        }
    }

    // Get from the combo edit box.
    m_comboVariable.GetWindowText(m_strVariable);
    if ( !m_strVariable.IsEmpty() ) {
        ::pVarAddVariableList->AddTail(m_strVariable);
        // Call kernel routine.
        ::VarAddVariable();
    }
    
    CDialog::OnOK();
}

void CVarAddVariableDialog::OnDropdownComboVariable()
{
    // TODO: Add your control notification handler code here

    // Get the last entered string from the combo box.
    m_comboVariable.GetWindowText(m_strVariable);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !::pVarAddVariableList->IsEmpty() ) {
            m_comboVariable.ResetContent();
            POSITION posHead = ::pVarAddVariableList->GetHeadPosition();
            while ( posHead ) {
                CString str=(CString)::pVarAddVariableList->GetNext(posHead);
                m_comboVariable.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboVariable.SetWindowText(m_strVariable);
}

BOOL CVarAddVariableDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here

    // Central the dialog position.
    CenterWindow();
        
    // Set the last variable name.
    if ( ::pVarAddVariableList && !::pVarAddVariableList->IsEmpty() ) {
        m_strVariable = (CString)::pVarAddVariableList->GetTail();
    }
    else {
        // Initial value.
        m_strVariable = "";
    }

    // Show the selected variable.
    m_comboVariable.SetWindowText(m_strVariable);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
