
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/VARCAST.CPP   1.14   09 Jan 1997 14:26:38   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/VARCAST.CPP  $
** 
**    Rev 1.14   09 Jan 1997 14:26:38   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:21:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:02:30   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:49:44   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:01:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:24   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:46   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:20   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:48   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:34   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:40   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:14   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARCAST.CPP
//
//  Description: The implementation file fore class: CVarTypeCastDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarTypeCastDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varcast.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarTypeCastList;
CStringList* pStkTypeCastList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void StkGetHighlightName(CString& strName);
void VarTypeCast(void);
void StkTypeCast(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarTypeCastDialog dialog


CVarTypeCastDialog::CVarTypeCastDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarTypeCastDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarTypeCastDialog)
    m_strTypeCast = "";
    m_strVariableName = "";
    //}}AFX_DATA_INIT

    // Initial.
    m_isDropdown = FALSE;
    
    // Point to the relative list.
    if ( ::isVarWindowActive ) {
        m_pList = ::pVarTypeCastList;
    }
    else if ( ::isStkLocalActive ) {
        m_pList = ::pStkTypeCastList;
    }
}

void CVarTypeCastDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarTypeCastDialog)
    DDX_Control(pDX, IDC_STATIC_TYPECASE_VARIABLENAME, m_staticVariableName);
    DDX_Control(pDX, IDC_COMBO_TYPECAST_TYPECAST, m_comboTypeCast);
    DDX_CBString(pDX, IDC_COMBO_TYPECAST_TYPECAST, m_strTypeCast);
    DDV_MaxChars(pDX, m_strTypeCast, 80);
    DDX_Text(pDX, IDC_STATIC_TYPECASE_VARIABLENAME, m_strVariableName);
    DDV_MaxChars(pDX, m_strVariableName, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarTypeCastDialog, CDialog)
    //{{AFX_MSG_MAP(CVarTypeCastDialog)
    ON_CBN_DROPDOWN(IDC_COMBO_TYPECAST_TYPECAST, OnDropdownComboTypecast)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarTypeCastDialog message handlers

void CVarTypeCastDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarTypeCastDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        m_pList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboTypeCast.GetCount(); i++ ) {
            m_comboTypeCast.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                m_pList->AddTail(str);
            }
        }
    }

    // Get from the combo edit box.
    m_comboTypeCast.GetWindowText(m_strTypeCast);
    if ( !m_strTypeCast.IsEmpty() ) {
        m_pList->AddTail(m_strTypeCast);
        // Call the kernel routine.
        if ( ::isVarWindowActive ) {
            ::VarTypeCast();
        }
        else if ( ::isStkLocalActive ) {
            ::StkTypeCast();
        }
    }

    CDialog::OnOK();
}

void CVarTypeCastDialog::OnDropdownComboTypecast()
{
    // TODO: Add your control notification handler code here

    // Get the last entered string from the combo box.
    m_comboTypeCast.GetWindowText(m_strTypeCast);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !m_pList->IsEmpty() ) {
            m_comboTypeCast.ResetContent();
            POSITION posHead = m_pList->GetHeadPosition();
            while ( posHead ) {
                CString str=(CString)(m_pList->GetNext(posHead));
                m_comboTypeCast.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboTypeCast.SetWindowText(m_strTypeCast);
}

BOOL CVarTypeCastDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Get the current highlight variable name.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightName(m_strVariableName);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightName(m_strVariableName);
    }
    m_staticVariableName.SetWindowText(m_strVariableName);
    
    // Get the Type Cast string.
    if ( !m_pList->IsEmpty() ) {
        m_strTypeCast = (CString)(m_pList->GetTail());
    }

    // Show the Type Cast string.
    m_comboTypeCast.SetWindowText(m_strTypeCast);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
