
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/VARMODI.CPP   1.14   09 Jan 1997 14:26:40   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/VARMODI.CPP  $
** 
**    Rev 1.14   09 Jan 1997 14:26:40   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:21:30   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:02:32   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:49:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:01:44   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:16   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:12   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:58   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:08   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:46   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:48   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARMODI.CPP
//
//  Description: The implementation file fore class:CVarModifyVariableDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarModifyVariableDialog.
//      2. 09/08/95, Fix bug 48, CVarModifyVariableDialog::OnInitDialog().
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varmodi.h"
#include "uicom2.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void VarGetHighlightValue(CString& strValue);
BOOL VarModifyValue(CString& strNewValue);

void StkGetHighlightName(CString& strName);
void StkGetHighlightValue(CString& strValue);
BOOL StkModifyValue(CString& strNewValue);

//void RepaintBMemory(void);

/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarModifyVariableDialog dialog

CVarModifyVariableDialog::CVarModifyVariableDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarModifyVariableDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarModifyVariableDialog)
    m_strNewValue = "";
    m_strCurrentContent = "";
    m_strVariable = "";
    //}}AFX_DATA_INIT
}

void CVarModifyVariableDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarModifyVariableDialog)
    DDX_Control(pDX, IDC_STATIC_MODIFYVARIABLE_VARIABLENAME, m_staticVariableName);
    DDX_Control(pDX, IDC_STATIC_MODIFYVARIABLE_CONTENT, m_staticCurrentContent);
    DDX_Control(pDX, IDC_EDIT_MODIFYVARIABLE_NEWVALUE, m_editNewValue);
    DDX_Text(pDX, IDC_EDIT_MODIFYVARIABLE_NEWVALUE, m_strNewValue);
    DDV_MaxChars(pDX, m_strNewValue, 80);
    DDX_Text(pDX, IDC_STATIC_MODIFYVARIABLE_CONTENT, m_strCurrentContent);
    DDV_MaxChars(pDX, m_strCurrentContent, 80);
    DDX_Text(pDX, IDC_STATIC_MODIFYVARIABLE_VARIABLENAME, m_strVariable);
    DDV_MaxChars(pDX, m_strVariable, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarModifyVariableDialog, CDialog)
    //{{AFX_MSG_MAP(CVarModifyVariableDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarModifyVariableDialog message handlers

void CVarModifyVariableDialog::OnOK()
{
    // TODO: Add extra validation here

    // Get the new value.
    m_editNewValue.GetWindowText(m_strNewValue);
    
    // Modify the value by calling from Variable / Stack server.
    if ( !m_strNewValue.IsEmpty() ) {
        if ( ::isVarWindowActive ) {
            if ( ::VarModifyValue(m_strNewValue) ) {
                ::RepaintStack();
                ::RepaintCPU();
                ::RepaintMemory();
                //::RepaintBMemory();
                //::RepeaintPeri();
                CDialog::OnOK();
            }
        }
        else if ( ::isStkLocalActive ) {
            if ( ::StkModifyValue(m_strNewValue) ) {
                ::RepaintVariable();
                ::RepaintCPU();
                ::RepaintMemory();
                //::RepaintBMemory();
                //::RepaintPeri();
                CDialog::OnOK();
            }
        }
    }
    else {
        CDialog::OnOK();
    }
}

void CVarModifyVariableDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarModifyVariableDialog::GetHighlightVariableName(void)
{
    // Get the current highlight variable name.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightName(m_strVariable);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightName(m_strVariable);
    }
}

void CVarModifyVariableDialog::GetHighlightVariableValue(void)
{
    // Get the current highlight variable value.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightValue(m_strCurrentContent);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightValue(m_strCurrentContent);
    }
}

BOOL CVarModifyVariableDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Get the current modified variable name.
    GetHighlightVariableName();

    // Show the current modified variable name.
    m_staticVariableName.SetFont(GetFont());
    m_staticVariableName.SetWindowText(m_strVariable);

    // Get the current modified variable value.
    GetHighlightVariableValue();

    // Show the current value of the special variable.
    m_staticCurrentContent.SetFont(GetFont());
    m_staticCurrentContent.SetWindowText(m_strCurrentContent);
    
    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
