
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/VARSRCH.CPP   1.14   09 Jan 1997 14:26:40   ZJRD  $
**
** 
**    Rev 1.0   13 Aug 1996 09:19:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARMODI.CPP
//
//  Description: The implementation file for the class: CVarSearchDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarSearchDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
//#include "uicom.h"
#include "flttool.h"
#include "toolbar.h"
#include "mainfrm.h"

#include "varsrch.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarSearchPatternList;
CStringList* pStkSearchPatternList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void StkGetHighlightName(CString& strName);
void VarSearchToken(void);
void StkSearchToken(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarSearchDialog dialog


CVarSearchDialog::CVarSearchDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarSearchDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarSearchDialog)
    m_strSearchWhat = "";
    //}}AFX_DATA_INIT

    // Initial.
    m_isDropdown = FALSE;

    // Point to the relative list.
    if ( ::isVarWindowActive ) {
        m_pList = ::pVarSearchPatternList;
    }
    else if ( ::isStkLocalActive ) {
        m_pList = ::pStkSearchPatternList;
    }
}

void CVarSearchDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarSearchDialog)
    DDX_Control(pDX, IDC_COMBO_SEARCH_SEARCHWHAT, m_comboSearchWhat);
    DDX_CBString(pDX, IDC_COMBO_SEARCH_SEARCHWHAT, m_strSearchWhat);
    DDV_MaxChars(pDX, m_strSearchWhat, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarSearchDialog, CDialog)
    //{{AFX_MSG_MAP(CVarSearchDialog)
    ON_BN_CLICKED(IDC_BUTTON_SEARCH_SEARCH, OnButtonSearchSearch)
    ON_CBN_DROPDOWN(IDC_COMBO_SEARCH_SEARCHWHAT, OnDropdownComboSearchwhat)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarSearchDialog message handlers

void CVarSearchDialog::OnButtonSearchSearch()
{
    // TODO: Add your control notification handler code here
    
    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        m_pList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboSearchWhat.GetCount(); i++ ) {
            m_comboSearchWhat.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                m_pList->AddTail(str);
            }
        }
    }

    // Get from the combo edit box.
    m_comboSearchWhat.GetWindowText(m_strSearchWhat);
    if ( !m_strSearchWhat.IsEmpty() ) {
        m_pList->AddTail(m_strSearchWhat);
        // Call kernel routine.
        if ( ::isVarWindowActive ) {
            ::VarSearchToken();
        }
        else if ( ::isStkLocalActive ) {
            ::StkSearchToken();
        }
    }                
    
// Added by Gates Hua    
    CMainFrame * pMain = (CMainFrame *)AfxGetApp()->m_pMainWnd;
    if ( !m_strSearchWhat.IsEmpty() ) {
	    pMain->m_wndToolBar.AddSrchText(m_strSearchWhat);
	}

    CDialog::OnOK();
}

void CVarSearchDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarSearchDialog::OnDropdownComboSearchwhat()
{
    // TODO: Add your control notification handler code here
    
    // Get the last entered string from the combo box.
    m_comboSearchWhat.GetWindowText(m_strSearchWhat);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !m_pList->IsEmpty() ) {
            m_comboSearchWhat.ResetContent();
            POSITION posHead = m_pList->GetHeadPosition();
            while ( posHead ) {
                CString str = 
                    (CString)(m_pList->GetNext(posHead));
                m_comboSearchWhat.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboSearchWhat.SetWindowText(m_strSearchWhat);
}

BOOL CVarSearchDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Set the last variable name.
    if ( !m_pList->IsEmpty() ) {
        m_strSearchWhat = (CString)(m_pList->GetTail());
    }
    else {
        // Select the highlight variable.
        if ( ::isVarWindowActive ) {
            ::VarGetHighlightName(m_strSearchWhat);
        }
        else if ( ::isStkLocalActive ) {
            ::StkGetHighlightName(m_strSearchWhat);
        }
    }

    // Show the selected variable.
    m_comboSearchWhat.SetWindowText(m_strSearchWhat);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
