/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

// bptdata.h : header file
//
#ifndef _BPTDATA_H_
#define _BPTDATA_H_

#include "srcaddr.h"

/////////////////////////////////////////////////////////////////////////////
// CBpData

class CBpData : public CObject
{
	DECLARE_SERIAL(CBpData)

// Contruction & Destruction
public:
    CBpData() { }

    CBpData(const CBpData& BpData)
    	: m_Addr(BpData.GetAddr()), m_strSymbol(BpData.GetSymbol()), m_bEnable(BpData.IsEnable()) { }

    CBpData(const CSourceAddr& Addr, const CString& strSymbol, const BOOL bEnable)
    	: m_Addr(Addr), m_strSymbol(strSymbol), m_bEnable(bEnable) { }

    virtual ~CBpData() { }

// Attributes
protected:
	CSourceAddr m_Addr;
	CString 	m_strSymbol;
	BOOL 		m_bEnable;

public:
	CSourceAddr GetAddr() const { return m_Addr; }
	void SetAddr(const CSourceAddr& Addr) { m_Addr = Addr; }
	
	const CString& GetSymbol() const { return m_strSymbol; }
	void SetSymbol(const CString& strSymbol) { m_strSymbol = strSymbol; }
	
	BOOL IsEnable() const { return m_bEnable; }
	void Enable(const BOOL bEnable = TRUE) { m_bEnable = bEnable; }

// Operator
public:
    void operator=(const CBpData& BpData)
    {
	    m_Addr = BpData.m_Addr;
	    m_strSymbol = BpData.m_strSymbol;
	    m_bEnable = BpData.m_bEnable;
	}

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

#endif
