
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EMUGO.H__   1.2.1.5   17 Apr 1997 15:48:34   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EMUGO.H__  $
** 
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUGO.H
//
//  Description: The header file for the class: CEmulationGo.
//
//  Author: Chen Jun
//
//  Date: 05/06/95
//
//  Modification:
//      1. 05/06/95, Initial version of the class: CEmulationGo.
//      2. 
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUGO_
#define _EMUGO_

#include "gosvr.h"
#include "abiextfn.h"
#include "address.h"                                                         
#include "stksvr.h"

/////////////////////////////////////////////////////////////////////////////
// CEmulationGo class.
class CEmulationGo : public CObject
{
// Construction & Destruction.
public:
    CEmulationGo();
    ~CEmulationGo();
    
// Member variables.
private:
    ADDR m_FromAddr, m_TillAddr;
    unsigned char m_uchRunFlag;
    unsigned char m_uchFlyFlag;
    
    ADDR m_Addr[4], m_BPAddr[2];

    enum { PC = 0 };
    ADDR m_PC;
    
    int m_nMonitorTimer;
    BOOL m_bStartTimer;
    int m_nTimerCount;
    
protected:
	
public:
    int m_nErrorID;
    BOOL m_isServer;
// Implementations.
private:         
	void SetAddrUndefined(ADDR& addr) {
		addr.addrType = MEM_UNDEFINED;
	}        
	void SetAddrVar(char* Str,ADDR& addr);
    void SetRunFlag(unsigned char uchRunFlag);  
    void SetFlyFlag(unsigned char uchFlyFlag);
    void GoKernel(void);
    BOOL DetectEPStop(void);
    
    void SetMonitorTimer(char* pszTimer);
    void UpdateAllWindows(void);

protected:

public:
    void GoAction(int nArgc, char* pszArgv[]);

    void EmuServerGo(int nMode, ADDR addr);
    
    BOOL GoForGofly();

};  // End of class: CEmulationGo.

#endif
//////////////////////////////// End of File ////////////////////////////////
