
/////////////////////////////////////////////////////////////////////////////
//
//  File name:  FLDDLG.H
//
//  Description:The header file of dialog box for Peripheral window
//
//  Author:     Jerry Yan
//				modify by Richard Guo, 10/24/96
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _flddlg_h
#define _flddlg_h

#include "percore.h"

struct PERI_FIELD_DRAWDATA
{ 
	 BOOL	needMerge;  
	 WORD   wDescStrID;
	 BYTE	byStart;
	 BYTE   byLen;   
	 char   szName[14];
};

/////////////////////////////////////////////////////////////////////////////
// CFldDlg dialog

class CFldDlg : public CDialog
{                     

private:
    CRect m_GridRect;
    CSize m_DefCellSize;
    int   m_nAbnormal[16] ;
// Construction

protected:
	CPerCore* lpPerCore;
	int		m_nNameRow;    
	int		m_nByteNum; 
	int		m_nScrollCol;
	int		m_nExplain[16];

protected:
	void	UpdateRegValue();	
	void	SetNameScroll(int cursel);
	
public:
	CFldDlg(CWnd* pParent, int index);	// standard constructor
	~CFldDlg();
	
    CWnd* m_pParent;         
    CVBControl* m_pGrid; 
    int m_nIndex;     //current seleted item in the list box
	WORD m_wBaseID;
    int  m_nFldMax;    // the maxime value of the current field.
    DWORD m_dwRegVal;
    int m_nRegid;      // the order number of current peripheral register.
    BOOL m_bCanClose; 
    
    void ResetListContent();
    
    void InitDlgData(int cursel);
    void SetDlgList();
    void SetEdit(int fldid);  
    void SetGrid(DWORD regvalue);
    void GridInit();   
      /////////////////jerry 11-1////////////////////////////	
    afx_msg void OnRegValKillFocus();
    afx_msg void OnFieldValKillFocus();
 ////////////////////////////////   


// Dialog Data
	//{{AFX_DATA(CFldDlg)
	enum { IDD = IDD_FIELDDLG };
	CString	m_strFldVal;
	CString	m_strRegVal;
	//}}AFX_DATA

// Implementation 
private: 
    void CaluGridRect();
    void GridSetName(CDC* pDC ); 
    void DrawFrame(CDC * pdc, CRect rect,UINT flag);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CFldDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeFieldList();
	afx_msg void OnNextButt();
	afx_msg void OnPrevButt();
	afx_msg void OnCloseButt();
	afx_msg void OnWriButt();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSetfocusRegVal();
	afx_msg void OnSetfocusFieldList();
	afx_msg void OnSetfocusFieldVal();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif  
