/***************************************************************************
**
**    $Header$ 
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : abifn196.cpp
**
** Description: 
**
** Modification:
**
** Programmer: john 1997.1.10
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"
#include "abifn196.h"

//implemention of class C196Abi
STATUS C196Abi::EmuStepRange(U16 uNextAddrNum, ADDR* NextAddr,ADDR* stopAddr)
{ 
	STATUS status;
	m_Pipe.StartVar(STEP);
	m_Pipe.SaveVar(uNextAddrNum);  
	m_Pipe.SetVar((BYTE*)NextAddr,uNextAddrNum*sizeof(ADDR));  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*stopAddr);
	}	
	return status;

 }      
 
STATUS C196Abi::emuInitBank(BANKINIT* bankInit)
{                 
	STATUS status;
	m_Pipe.StartVar(INIT_BANK);
	m_Pipe.SaveVar(*bankInit);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;
 }
 
STATUS C196Abi::emuSelectBaud(BYTE bBaud)
{                 
	STATUS status;
	m_Pipe.StartVar(SELECT_BAUD);
	m_Pipe.SaveVar(bBaud);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;
 }
 
STATUS C196Abi::emuTestCom(BYTE* pChar,BYTE& bRetLen)
{                 
	STATUS status;
	m_Pipe.StartVar(TEST_COM);
	m_Pipe.SetVar(pChar,255);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	if(ICE_OK == status) {
		m_Pipe.LoadBuffer(pChar,bRetLen);
	}
	
	return status;
 }
 
STATUS C196Abi::emuSetMemMode(BYTE bMode)
{               
	STATUS status;
	m_Pipe.StartVar(SET_MEM_MODE);
	m_Pipe.SaveVar(bMode);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	return status;
 }

STATUS C196Abi::emuGetMemMode(BYTE& bMode)
{                 
	STATUS status;
	m_Pipe.StartVar(GET_MEM_MODE);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	if(ICE_OK == status) {
		m_Pipe.LoadVar(bMode);
	}
	
	return status;

 }
 
STATUS C196Abi::emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff) {
	STATUS status;
	m_Pipe.StartVar(GET_UES_DATA);
	m_Pipe.SaveVar(bType);  	
	m_Pipe.EndVar(END_CODE);
	
	status = Start();                   
	
	if(ICE_OK == status) {
		m_Pipe.LoadVar(bLen);
		m_Pipe.GetVar((BYTE*)pBuff,bLen);
	}
	
	return status;
	
}                       

STATUS C196Abi::emuProgram(BYTE bType,BYTE bUes) {
	STATUS status;
	m_Pipe.StartVar(JED_PROGRAM);
	m_Pipe.SaveVar(bType);  	
	m_Pipe.SaveVar(bUes);
	m_Pipe.EndVar(END_CODE);
	
	status = Start(2*BASE_TIME);     
	
	return status;
	
}                       

STATUS C196Abi::emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff) {
	STATUS status;
	m_Pipe.StartVar(SEND_JED_DATA);
	m_Pipe.SaveVar(wAddr);  	
	m_Pipe.SaveVar(bLen);
	m_Pipe.SetVar((BYTE*)pBuff,bLen);  
	m_Pipe.EndVar(END_CODE);
	
	status = Start();  
	   
	
	return status;
	
}           