/***************************************************************************
**
**    $Header$
**                             
**    $Log$
** 
****************************************************************************/
/***************************************************************************
**
** File name : ABIFUNC.CPP
** Author:john chow
** Description:
**    Descript the ABI for TW ABI
**
**    Finished date: 97.1
**    modifed date:
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h" 

#include "abicore.h"
#include "abitype.h"
#include "simulate.h"
#include "abiextfn.h"
#include "abifn196.h"
//temp, must be removed later
int GetCpuMode() { return 1; } 
extern CBaseAbi* pAbi; 

STATUS emuAbort()                         
{ 
    return pAbi->emuAbort();
 }         
 
STATUS emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr)
{ 
    return pAbi->emuChecksum(addr,len,n,retAddr);
 }         

STATUS emuClrEvent(U16 evId)
{ 
    return pAbi->emuClrEvent(evId);
 }         

STATUS emuClrAllEvent()
{ 
    return pAbi->emuClrAllEvent();
 }         

STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2)
{ 
    return pAbi->emuCompare(addr1,len,addr2,findAddr1,findAddr2);
 }         

STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,RET_ADDR* addrRet2)
{ 
    return pAbi->emuCopy(addr1,len,addr2,addrRet1,addrRet2);
 }         

STATUS emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuFill(addr,len,patternLen,buff,retAddr);
 }         

STATUS emuGetAllReg(U32 *cpuReg)
{ 
    return pAbi->emuGetAllReg(cpuReg);
 }         

STATUS emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic)
{ 
    return pAbi->emuGetTrigger(byTrigStatus,
                     byLv1Status,pLv1,
                     byLv2Status,pLv2,
                     pTrigLogic);
}         
                     
STATUS emuGetControl(U16 *signals)
{ 
    return pAbi->emuGetControl(signals);
 }         

STATUS emuGetCpuStatus(U32 *cpuStatus)
{ 
    return pAbi->emuGetCpuStatus(cpuStatus);
 }         

STATUS emuGetEvent(U8 *byControl, U8 *byEv3,BUS_EVENT *pEv1, BUS_EVENT *pEv2)
{ 
    return pAbi->emuGetEvent(byControl,byEv3,pEv1,pEv2);
 }         

STATUS emuGetID(U8 *ID_Info)
{ 
    return pAbi->emuGetID(ID_Info);
}         

STATUS emuGetMap(ADDR addrStart,ADDR addrEnd,MAP_INFO *mapData)
{ 
    return pAbi->emuGetMap(addrStart,addrEnd,mapData);
 }         

STATUS emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuGetMemN(addr,len,buff,retAddr);
 }         

STATUS emuGetReg(REG_MODE regMode, S16 regId,U32 *content)
{ 
    return pAbi->emuGetReg(regMode,regId,content);
 }         

STATUS emuSetReg(REG_MODE regMode, S16 regId,U32 content)
{ 
    return pAbi->emuSetReg(regMode,regId,content);
 }         

STATUS emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth)
{ 
    return pAbi->emuGetTraceDepth(bufID,traceDepth);
 }         

STATUS emuGetVerify(U16 *verifyFlag)
{ 
    return pAbi->emuGetVerify(verifyFlag);
 }         

STATUS emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr)
{ 
    return pAbi->emuGo(mode,fromAddr,tillAddr);
 }         

STATUS emuInput(U16 port, U16 len, U16 size, U8 *buff)
{ 
    return pAbi->emuInput(port,len,size,buff);
 }         

STATUS emuListTraceBuff(U32 startFrame, 
                        U32 endFrame, QUALIFY_INFO *qualifyInfo,
                        U8 *frameLen,TRACE_INFO *traceInfo,
                        U8 *readEnd)
{ 
    return pAbi->emuListTraceBuff(startFrame, 
                        endFrame,qualifyInfo,
                        frameLen,traceInfo,
                        readEnd);
 }         
                        
STATUS emuOutput(U16 port, U8 *buff , U16 len, U16 size)
{ 
    return pAbi->emuOutput(port,buff,len,size);
 }         

STATUS emuReset(ADDR addr)
{ 
    return pAbi->emuReset(addr);
 }         

STATUS emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,
                 RET_ADDR* retAddr)
{ 
    return pAbi->emuSearch(addr,len,buff,patternLen,caseFlag,retAddr);
 }         
                 
STATUS emuSetBp(ADDR addr)
{ 
    return pAbi->emuSetBp(addr);
 }         

STATUS emuSetControl(U16 signals)
{ 
    return pAbi->emuSetControl(signals);
 }         

STATUS emuSetEvent(U16 evId, BUS_EVENT *busEventData)
{ 
    return pAbi->emuSetEvent(evId,busEventData);
 }         

STATUS emuSetExtEvent(U16 evData)
{ 
    return pAbi->emuSetExtEvent(evData);
 }         

STATUS emuSetID(U16 idFlag)
{ 
    return pAbi->emuSetID(idFlag);
 }         

STATUS emuSetMap(ADDR addr1, ADDR addr2, U16 attrib)
{ 
    return pAbi->emuSetMap(addr1,addr2,attrib);
 }         

STATUS emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr)
{ 
    return pAbi->emuSetMemN(addr,buff,patternLen,retAddr);
 }         

STATUS emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData)
{ 
    return pAbi->emuSetTrigLogic(trigLogicData);
 }         

STATUS emuSetVerify(U16 verifyFlag)
{ 
    return pAbi->emuSetVerify(verifyFlag);
 }         

STATUS EmuStepRange(U16 uNextAddrNum, ADDR* NextAddr,ADDR* stopAddr)
{ 
    return pAbi->EmuStepRange(uNextAddrNum,NextAddr,stopAddr);
 }         

STATUS emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr)
{ 
    return pAbi->emuTest(addr1,len,retAddr);
 }         

STATUS emuGetFWSupport(U16* wCpuNum,U16* wCpuType)
{ 
    return pAbi->emuGetFWSupport(wCpuNum,wCpuType);
 }         

STATUS emuClrBp(ADDR addr)
{ 
    return pAbi->emuClrBp(addr);
 }         

STATUS emuStepOne()
{ 
    return pAbi->emuStepOne();
 }         

STATUS emuStepOver()
{ 
    return pAbi->emuStepOver();
 }         

STATUS emuEreaseFlash(U32 bankNo,RET_ADDR* addr)
{ 
    return pAbi->emuEreaseFlash(bankNo,addr);
 }         

STATUS emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent)
{ 
    return pAbi->emuProgFlash(dataLen,bOptionBankLowOrHigh,startAddr,dataContent);
 }         

STATUS emuSwitchFlash()
{ 
    return pAbi->emuSwitchFlash();
 }         

STATUS emuFillFlashBland(ADDR addr1,ADDR addr2, U8 blankValue,RET_ADDR* retAddr)
{ 
    return pAbi->emuFillFlashBland(addr1,addr2,blankValue,retAddr);
 }         

STATUS emuFwInit()
{ 
    return pAbi->emuFwInit();
 }         

STATUS emuSetQualify(QUALIFY* qualifyData)
{ 
    return pAbi->emuSetQualify(qualifyData);
 }         

STATUS emuClearQualify()
{ 
    return pAbi->emuClearQualify();
 }         

STATUS emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData)
{ 
    return pAbi->emuSetTrigLevel(levelId,trigLevelData);
 }         

STATUS emuSetTriggerStatus(U8 triggerFlag)
{ 
    return pAbi->emuSetTriggerStatus(triggerFlag);
 }         

STATUS emuSetTraceStatus (U8 tracerFlag)
{ 
    return pAbi->emuSetTraceStatus (tracerFlag);
 }         

STATUS emuInitBank(BANKINIT* bankInit)
{ 
    return pAbi->emuInitBank(bankInit);
 }         

STATUS emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{ 
    return pAbi->emuGetBp(addr1,addr2,bpAddr);
 }
          
STATUS emuSelectBaud(BYTE bBaud)
{                                             
    return pAbi->emuSelectBaud(bBaud);
 }                                 
 
STATUS emuTestCom(BYTE* pChar,BYTE& bRetLen)
{                                     
    return pAbi->emuTestCom(pChar,bRetLen);
 }

STATUS emuSetMemMode(BYTE bMode)
{                                     
    return pAbi->emuSetMemMode(bMode);
 }

STATUS emuGetMemMode(BYTE& bMode)
{                                     
    return pAbi->emuGetMemMode(bMode);
 }
 
STATUS emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff) {
    return pAbi->emuGetUesData(bType,bLen,pBuff);
}

STATUS emuProgram(BYTE bType,BYTE bUes) {
    return pAbi->emuProgram(bType,bUes);
}

STATUS emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff) {
    return pAbi->emuSendProgData(wAddr,bLen,pBuff);
}

