/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  PERBASE.H
**
** Author:      Richard Guo
** Description: basic functions definition for peripheral window.
**
** coding from: Oct 24, 1996
** Finished date:
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**                        
****************************************************************************/

#ifndef _perbase_
#define _perbase_

#define PERI_START_ID 	1000 
#define PERI_DESC_SPACE  100

#define EP9X_CPUID_START	0
#define EP9X_CPUID_END		0X11
#define EP196KA_CPUID_START 0X12
#define EP196KA_CPUID_END	0X14
#define EP196KB_CPUID_START 0X15
#define EP196KB_CPUID_END	0X17
#define EP196KC_CPUID_START	0X18
#define EP196KC_CPUID_END   0X1A
#define EP196MC_CPUID_START 0X1E
#define EP196MC_CPUID_END	0X20
#define EP196MD_CPUID_START 0X21
#define EP196MD_CPUID_END	0X23
#define EP196MH_CPUID_START 0X24
#define EP196MH_CPUID_END	0X26

#define PER_INVALID_CARD	-1
#define PER_TOO_LARGE		-2
#define PER_OK				0

struct PERI_DRAWDATA
{
	BOOL 	isBit;
	BOOL 	isExpanded;   // if isBit=1, isExpanded =1,information directly
					   // if isBit=0, isExpanded mean whether expands children
	WORD 	BaseID;
	WORD 	StringID;   // if isBit=1, pointer to this field general description string
					 // if isBit=0, pointer to this item description string directly
	DWORD 	dwVal; 
//	char 	szName[12];
	char	Addr[14];
	BYTE 	Level;
	WORD 	Index;
	BYTE	offset; // childId 
};	

char* gstrtok(char* &szBuffer, char* szToken);
void RegBitStartLen(const char* szBitInfo, WORD& wStart, WORD& wLen);
//BOOL MergeBitName(WORD wSerialNo, BYTE byBitFrom, BYTE byBitTo, char* szName);
int strRevIndig(const char* szSrc);
BOOL MergeRegAddr(WORD wSerialNo, char* szAddr);

BOOL GetRegValue(WORD wSerial, DWORD& dwValue);
BOOL SetRegValue(WORD wSerial, DWORD dwValue); 
BOOL GetRegLen(WORD wSerial, int& nLen);
void GetRegBitName(const char* szStr, BYTE bySite, char* szName);

int CheckString(CString string, DWORD dwMaxVal);
DWORD Hex2Dec(char* reg_value);

#endif
