/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  PERCORE.H
**
** Author:      Richard Guo
** Description: Definitions of basic functions for peripheral window.
**
** coding from: Oct 24, 1996
** Finished date:
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _predata_
#define _predata_  

#include "perbase.h"

class CPerCore {      
public:
	CPerCore(WORD wCpuID1, HINSTANCE hPerLib1);
	
protected: // data      
	HINSTANCE hPerLib;
	
	WORD m_wCpuID;
	
	WORD m_wRootCount;
	WORD m_wRootBaseSpace;
	WORD m_wRootBaseStart;
	
	WORD *m_wPerBase;
	
	WORD m_wDescBaseStart;
	WORD m_wDescBaseSpace;

		
protected:                  
	void SetTable();
	
	WORD RootIndexToChild(WORD wIndex);
	
	inline WORD RootChildToIndex(WORD wChild);
	inline WORD RootIndexBaseID(WORD wIndex);
	inline WORD RootIndexDescID(WORD wIndex);
	inline WORD RootBaseToIndex(WORD wBaseID);
	
	WORD RootBaseToChild(WORD wBaseID);
    WORD WhichIndex(WORD wBaseID);
   	WORD WhichChild(WORD nBaseID);
	WORD GetRegStrID(WORD wFatherStrID, WORD wBaseID, WORD wOffset);
   
   	WORD ChildFirstOffspringBase(WORD wBaseID, WORD wChild);
   	WORD ChildLastOffspringBase(WORD wBaseID, WORD wChild);
public:   
	WORD RootItemCount();
    WORD RootChildDescID(WORD wChild);
	WORD RootChildBaseID(WORD wChild);
	WORD RegSerialNo(WORD wBaseID);     

	WORD GetChildNum(WORD wBaseID);
	WORD GetOffspringNum(WORD wBaseID);
	WORD GetRegStrNum(WORD wBaseID);

	BOOL GetRegStrID(PERI_DRAWDATA* lpFatherPer, PERI_DRAWDATA* lpPer);
	WORD GetRegStrID(WORD wBaseID);

	BOOL GetDescStr(PERI_DRAWDATA* lpItem, char* szDesc); 
	BOOL GetBitDescStr(WORD wDescID, WORD wValue, BOOL bMerge, char* szDesc);

	WORD ChildBaseID(WORD wBaseID, WORD wOffset);
	WORD LeftBrotherBase(WORD wBaseID);
	WORD RightBrotherBase(WORD wBaseID);    

	WORD FatherBaseID(WORD wBaseID);
	WORD AncestorBaseID(WORD wBaseID);
};


#endif
