/*#include <windows.h>     
#include <memory.h>
#include <string.h>
#include <assert.h>*/
#include "stdafx.h"

#include "regmap.h"                  

#define ITEMCOUNT(a) sizeof(a)/sizeof(a[0])

CRegSearch regSearch;

CRegCpuItem regMap_8X9X[]= {
//   name  no addr  memType        opType  Len  window 
	{
		{"PC", 	0, -1,    MEM_UNDEFINED, OP_RW,   4, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"PSW", 2, -1,    MEM_UNDEFINED, OP_RW,   1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"R0",  3, 0x0,  MEM_I, 	   OP_RW,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"AD_RESULT", 4, 0X2, MEM_I,   OP_R,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"HSI_TIME", 5, 0X4, MEM_I,    OP_R,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"HSI_STATUS", 6, 0X6, MEM_I,  OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"SBUF(RX)", 7, 0X7, MEM_I,	   OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"TIMER1", 10, 0X0A, MEM_I,	   OP_R,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{	
		{"TIMER2", 11, 0X0C, MEM_I,	   OP_R,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"PORT0", 12, 0X0E, MEM_I,	   OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"PORT2", 13, 0X10, MEM_I,	   OP_RW,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"SP_STAT", 14, 0X11, MEM_I,   OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"IOS0", 15, 0X15, MEM_I, 	   OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"IOS1", 16, 0X16, MEM_I,	   OP_R,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"P3", 17, 0X1FFFE, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"P4", 18, 0X1FFFF, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"PORT1", 19, 0X0F, MEM_I,	   OP_R, 	1, WINDOW_NONE},
		EP_8X96
	},
// write only register	
	{
		{"AD_COMMAND", 500, 0X2, MEM_I, OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"HSI_MODE", 501, 0X3, MEM_I,   OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"HSO_TIME", 502, 0X4, MEM_I,	OP_W,	2, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"HSO_COMMAND", 503, 0X6, MEM_I, OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"SBUF(TX)", 504, 0X7, MEM_I, 	OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"WATCHDOG", 505, 0X0A, MEM_I,	OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"BAUD_RATE", 506, 0X0E, MEM_I, OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"SP_CON", 507, 0X11, MEM_I, OP_W, 		1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"IOC0", 508, 0X15, MEM_I, 		OP_W, 	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"IOC1", 509, 0X16, MEM_I,		OP_W,	1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	},
	{
		{"PWM_CONTROL", 510, 0X17, MEM_I, OP_W, 1, WINDOW_NONE},
		EP_8X96 | EP_8X98
	}
}; 

CRegCpuItem regMap_8X196KB[]= {
//   name  no addr  memType        opType  Len  window 
	{
		{"PC", 	0, -1,    MEM_UNDEFINED, OP_RW,   4, WINDOW_NONE},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PSW", 2, -1,    MEM_UNDEFINED, OP_RW,   1, WINDOW_NONE},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"AD_RESULT", 4, 0X2, MEM_I,   OP_R,	2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"AD_RESULT", 4, 0X2, MEM_I,   OP_W,	2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_TIME", 5, 0X4, MEM_I,    OP_R,	2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_TIME", 5, 0X4, MEM_I,    OP_W,	2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_STATUS", 6, 0X6, MEM_I,  OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_STATUS", 6, 0X6, MEM_I,  OP_W,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SBUF(RX)", 7, 0X7, MEM_I,	   OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SBUF(RX)", 7, 0X7, MEM_I,	   OP_W,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"TIMER1", 10, 0X0A, MEM_I,	   OP_R,	2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"TIMER1", 10, 0X0A, MEM_I,	   OP_W,	2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{	
		{"TIMER2", 11, 0X0C, MEM_I,	   OP_RW,	2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PORT0", 12, 0X0E, MEM_I,	   OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PORT2", 13, 0X10, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP_STAT", 14, 0X11, MEM_I,   OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP_STAT", 14, 0X11, MEM_I,   OP_W,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOS0", 15, 0X15, MEM_I, 	   OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOS0", 15, 0X15, MEM_I, 	   OP_W,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOS1", 16, 0X16, MEM_I,	   OP_R,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOS1", 16, 0X16, MEM_I,	   OP_W,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PORT3", 17, 0X1FFFE, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PORT4", 18, 0X1FFFF, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PORT1", 19, 0X0F, MEM_I,	   OP_RW, 	1, 0},
		EP_8X196KB|EP_8X196KA
	},                                              
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 15},
		EP_8X196KB|EP_8X196KA
	},                
	{
		{"IOS2", 23, 0X17, MEM_I, OP_R, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOS2", 23, 0X17, MEM_I, OP_W, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"AD_COMMAND", 24, 0X2, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"AD_COMMAND", 24, 0X2, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_MODE", 25, 0X3, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSI_MODE", 25, 0X3, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSO_TIME", 26, 0X4, MEM_I, OP_W, 2, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSO_TIME", 26, 0X4, MEM_I, OP_R, 2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSO_COMMAND", 27, 0X6, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"HSO_COMMAND", 27, 0X6, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SBUF(TX)", 28, 0X7, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SBUF(TX)", 28, 0X7, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"WATCHDOG", 29, 0X0A, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"WATCHDOG", 29, 0X0A, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC2", 30, 0X0B, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC2", 30, 0X0B, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"T2CAPTURE", 31, 0X0C, MEM_I, OP_RW, 2, 14},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"T2CAPTURE", 31, 0X0C, MEM_I, OP_RW, 2, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP_CON", 32, 0X11, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"SP_CON", 32, 0X11, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC0", 33, 0X15, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC0", 33, 0X15, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC1", 34, 0X16, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"IOC1", 34, 0X16, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PWM0_CONTROL", 35, 0X17, MEM_I, OP_W, 1, 0},
		EP_8X196KB|EP_8X196KA
	},
	{
		{"PWM0_CONTROL", 35, 0X17, MEM_I, OP_R, 1, 15},
		EP_8X196KB|EP_8X196KA
	},


// write only register	
	{
		{"BAUD_RATE", 506, 0X0E, MEM_I, OP_W,	1, 0},
		EP_8X196KB|EP_8X196KA
	}
	
}; 
 
CRegCpuItem regMap_8X196KC[]= {
//   name  no addr  memType        opType  Len  window 
	{
		{"PC", 	0, -1,    MEM_UNDEFINED, OP_RW,   4, WINDOW_NONE},
		EP_8X196KC
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 0},
		EP_8X196KC
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 1},
		EP_8X196KC
	},
	{
		{"SP", 	1, 0x18, MEM_I, 	   OP_RW,   2, 15},
		EP_8X196KC
	},
	{
		{"PSW", 2, -1,    MEM_UNDEFINED, OP_RW,   1, WINDOW_NONE},
		EP_8X196KC
	},
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 0},
		EP_8X196KC
	},      
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 1},
		EP_8X196KC
	},      
	{
		{"R0", 3, 0X0, MEM_I,   OP_RW,	2, 15},
		EP_8X196KC
	},      
	{
		{"AD_RESULT", 4, 0X2, MEM_I,   OP_R,	2, 0},
		EP_8X196KC
	},              
	{
		{"AD_RESULT", 4, 0X2, MEM_I,   OP_W,	2, 15},
		EP_8X196KC
	},              
	{
		{"HSI_TIME", 5, 0X4, MEM_I,    OP_R,	2, 0},
		EP_8X196KC
	},
	{
		{"HSI_TIME", 5, 0X4, MEM_I,    OP_W,	2, 15},
		EP_8X196KC
	},
	{
		{"HSI_STATUS", 6, 0X6, MEM_I,  OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"HSI_STATUS", 6, 0X6, MEM_I,  OP_W,	1, 15},
		EP_8X196KC
	},
	{
		{"SBUF(RX)", 7, 0X7, MEM_I,	   OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"SBUF(RX)", 7, 0X7, MEM_I,	   OP_W,	1, 15},
		EP_8X196KC
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 1},
		EP_8X196KC
	},
	{
		{"INT_MASK", 8, 0X8, MEM_I,	   OP_RW,	1, 15},
		EP_8X196KC
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 1},
		EP_8X196KC
	},
	{
		{"INT_PEND", 9, 0X9, MEM_I,	   OP_RW,	1, 15},
		EP_8X196KC
	},
	{
		{"TIMER1", 10, 0X0A, MEM_I,	   OP_R,	2, 0},
		EP_8X196KC
	},
	{
		{"TIMER1", 10, 0X0A, MEM_I,	   OP_W,	2, 15},
		EP_8X196KC
	},
	{	
		{"TIMER2", 11, 0X0C, MEM_I,	   OP_RW,	2, 0},
		EP_8X196KC
	},
	{
		{"PORT0", 12, 0X0E, MEM_I,	   OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"PORT2", 13, 0X10, MEM_I,	   OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"SP_STAT", 14, 0X11, MEM_I,   OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"SP_STAT", 14, 0X11, MEM_I,   OP_W,	1, 15},
		EP_8X196KC
	},
	{
		{"IOS0", 15, 0X15, MEM_I, 	   OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"IOS0", 15, 0X15, MEM_I, 	   OP_W,	1, 15},
		EP_8X196KC
	},
	{
		{"IOS1", 16, 0X16, MEM_I,	   OP_R,	1, 0},
		EP_8X196KC
	},
	{
		{"IOS1", 16, 0X16, MEM_I,	   OP_W,	1, 15},
		EP_8X196KC
	},
	{
		{"PORT3", 17, 0X1FFFE, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X196KC
	},
	{
		{"PORT4", 18, 0X1FFFF, MEM_I,  OP_RW,	1, WINDOW_NONE},
		EP_8X196KC
	},
	{
		{"PORT1", 19, 0X0F, MEM_I,	   OP_RW, 	1, 0},
		EP_8X196KC
	},                                              
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 1},
		EP_8X196KC
	},
	{
		{"INT_PEND1", 20, 0X12, MEM_I, OP_RW,	1, 15},
		EP_8X196KC
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 1},
		EP_8X196KC
	},
	{
		{"INT_MASK1", 21, 0X13, MEM_I, OP_RW,	1, 15},
		EP_8X196KC
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 0},
		EP_8X196KC
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 1},
		EP_8X196KC
	},
	{
		{"WSR", 22, 0X14, MEM_I, OP_RW,	1, 15},
		EP_8X196KC
	},                
	{
		{"IOS2", 23, 0X17, MEM_I, OP_R, 1, 0},
		EP_8X196KC
	},
	{
		{"IOS2", 23, 0X17, MEM_I, OP_W, 1, 15},
		EP_8X196KC
	},
	{
		{"AD_COMMAND", 24, 0X2, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"AD_COMMAND", 24, 0X2, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"HSI_MODE", 25, 0X3, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"HSI_MODE", 25, 0X3, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"HSO_TIME", 26, 0X4, MEM_I, OP_W, 2, 0},
		EP_8X196KC
	},
	{
		{"HSO_TIME", 26, 0X4, MEM_I, OP_R, 2, 15},
		EP_8X196KC
	},
	{
		{"HSO_COMMAND", 27, 0X6, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"HSO_COMMAND", 27, 0X6, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"SBUF(TX)", 28, 0X7, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"SBUF(TX)", 28, 0X7, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"WATCHDOG", 29, 0X0A, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"WATCHDOG", 29, 0X0A, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"IOC2", 30, 0X0B, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"IOC2", 30, 0X0B, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"T2CAPTURE", 31, 0X0C, MEM_I, OP_RW, 2, 15},
		EP_8X196KC
	},
	{
		{"SP_CON", 32, 0X11, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"SP_CON", 32, 0X11, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"IOC0", 33, 0X15, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"IOC0", 33, 0X15, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"IOC1", 34, 0X16, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	},
	{
		{"IOC1", 34, 0X16, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	},
	{
		{"PWM0_CONTROL", 35, 0X17, MEM_I, OP_W, 1, 0},
		EP_8X196KC
	}, 
	{
		{"PWM0_CONTROL", 35, 0X17, MEM_I, OP_R, 1, 15},
		EP_8X196KC
	}, 
	{
		{"AD_TIME", 36, 0X3, MEM_I, OP_RW, 1, 1},
		EP_8X196KC
	}, 
	{
		{"PTSSEL", 37, 0X4, MEM_I, OP_RW, 2, 1},
		EP_8X196KC
	}, 
	{
		{"PTSSRV", 38, 0X6, MEM_I, OP_RW, 2, 1},
		EP_8X196KC
	}, 
	{
		{"T2CONTROL", 39, 0X0C, MEM_I, OP_RW, 1, 1},
		EP_8X196KC
	}, 
	{
		{"PWM2_CONTROL", 40, 0X16, MEM_I, OP_RW, 1, 1},
		EP_8X196KC
	},
	{
		{"PWM1_CONTROL", 41, 0X17, MEM_I, OP_RW, 1, 1},
		EP_8X196KC
	}, 


// write only register	
	{
		{"BAUD_RATE", 506, 0X0E, MEM_I, OP_W,	1, 0},
		EP_8X196KC
	}
	
}; 

CRegCpuItem regMap_8X196MX[]= {
//   name  no addr  memType        opType  Len  window 
	{
		{"PC", 	0, -1,    MEM_UNDEFINED, OP_RW,   4, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"SP", 	1, 0X18, MEM_I, 	   OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PSW", 2, -1,    MEM_UNDEFINED, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"ZERO_REG", 	3, 0,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"ONES_REG", 	5, 2, MEM_I, 	   OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PTSSEL", 7, 4,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PTSSRV", 	9,  6,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"INT_MASK", 	0xB, 8, MEM_I, 	   OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"INT_PEND", 	0xC, 9,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WATCHDOG", 	0xD, 0xA, MEM_I, 	   OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"INT_PEND1", 0x15, 0x12,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"INT_MASK1", 	0x16, 0x13,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WSR", 	0x17, 0x14, MEM_I, 	   OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"EPA0_CON", 	0x1F, 0x1F40,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"EPA0_TIME", 	0x21, 0x1F42,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"EPA1_CON", 	0x23, 0x1F44,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"EPA1_TIME", 	0x25, 0x1F46,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"EPA2_CON", 	0x27, 0x1F48,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"EPA2_TIME", 	0x29, 0x1F4a,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"EPA3_CON", 	0x2B, 0x1F4C,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"COMP3_CON", 	0x2B, 0x1F4C,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"EPA3_TIME", 	0x2D, 0x1F4e,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"COMP3_TIME", 	0x2D, 0x1F4e,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"EPA4_CON", 	0x2F, 0x1F50,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"EPA4_TIME", 	0x31, 0x1F52,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"EPA5_CON", 	0x33, 0x1F54,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"EPA5_TIME", 	0x35, 0x1F56,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"COMP0_CON", 	0x37, 0x1F58,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP0_TIME", 	0x39, 0x1F5A,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP1_CON", 	0x3B, 0x1F5C,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP1_TIME", 	0x3D, 0x1F5E,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP2_CON", 	0x3F, 0x1F60,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP2_TIME", 	0x41, 0x1F62,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"COMP3_CON", 	0x43, 0x1F64,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"COMP3_TIME", 	0x45, 0x1F66,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"COMP4_CON", 	0x47, 0x1F68,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"COMP4_TIME", 	0x49, 0x1F6A,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"COMP5_CON", 	0x4B, 0x1F6C,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"COMP5_TIME", 	0x4D, 0x1F6E,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"T1RELOAD", 	0x51, 0x1F72,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"T1CONTROL", 	0x57, 0x1F78,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"TIME1", 	0x59, 0x1F7A,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"T2CONTROL", 	0x5B, 0x1F7C,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"TIME2", 	0x5D, 0x1F7E,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"SBUF0_RX", 	0x5F, 0x1F80,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP0_STATUS", 	0x60, 0x1F82,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SBUF0_TX", 	0x61, 0x1F82,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP0_CON", 	0x62, 0x1F83,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP0_BAUD", 	0x63, 0x1F84,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SBUF1_RX", 	0x67, 0x1F88,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP1_STATUS", 	0x68, 0x1F89,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SBUF1_TX", 	0x69, 0x1F8A,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP1_CON", 	0x6A, 0x1F8B,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"SP1_BAUD", 	0x6B, 0x1F8C,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P1_MODE", 	0x78, 0x1F99,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P1_DIR", 	0x7A, 0x1F9B,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P1_REG", 	0x7C, 0x1F9D,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P1_PIN", 	0x7E, 0x1F9F,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"GEN_CON", 	0x7F, 0x1FA0,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P0_PIN", 	0x87, 0x1FA8,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"P1_PIN", 	0x88, 0x1FA9,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD
	},
	{
		{"AD_RESULT", 	0x89, 0x1FAA,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"AD_COMMAND", 	0x8B, 0x1FAC,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"AD_TEST", 	0x8D, 0x1FAE,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"AD_TIME", 	0x8E, 0x1FAF,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PWM0_CONTROL", 	0x8F, 0x1FB0,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PWM1_CONTROL", 	0x91, 0x1FB2,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PWM_PERIOD", 	0x93, 0x1FB4,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PWM_COUNT", 	0x95, 0x1FB6,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"FREQ_GEN", 	0x97, 0x1FB8,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"FREQ_CNT", 	0x99, 0x1FBA,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"PI_MASK", 	0x9B, 0x1FBC,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"PI_PEND", 	0x9D, 0x1FBE,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_OUTPUT", 	0x9F, 0x1FC0,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_COMP1", 	0xA1, 0x1FC2,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_COMP2", 	0xA3, 0x1FC4,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_COMP3", 	0xA5, 0x1FC6,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_RELOAD", 	0xA7, 0x1FC8,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_COUNTER", 	0xA9, 0x1FCA,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_CONTROL", 	0xAB, 0x1FCC,    MEM_I, OP_RW,   2, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"WG_PROTECT", 	0xAD, 0x1FCE,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P2_MODE", 	0xAF, 0x1FD0,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P7_MODE", 	0xB0, 0x1FD1,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"P2_DIR", 	0xB1, 0x1FD2,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P7_DIR", 	0xB2, 0x1FD3,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"P2_REG", 	0xB3, 0x1FD4,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P7_REG", 	0xB4, 0x1FD5,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"P2_PIN", 	0xB5, 0x1FD6,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P7_PIN", 	0xB6, 0x1FD7,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MD
	},
	{
		{"P0_PIN", 	0xB9, 0x1FDA,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MH
	},
	{
		{"P5_MODE", 	0xD0, 0x1FF1,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P5_DIR", 	0xD2, 0x1FF3,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P5_REG", 	0xD4, 0x1FF5,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"USFR", 	0xD5, 0x1FF6,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P5_PIN", 	0xD6, 0x1FF7,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P3_REG", 	0xDB, 0x1FFC,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P4_REG", 	0xDC, 0x1FFD,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P3_PIN", 	0xDD, 0x1FFE,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	},
	{
		{"P4_PIN", 	0xDE, 0x1FFF,    MEM_I, OP_RW,   1, WINDOW_NONE},
		EP_8X196MC|EP_8X196MD|EP_8X196MH
	}
}; 

CRegMap RegMap_total[] = {
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X9X), regMap_8X9X},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KB),regMap_8X196KB},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196KC),regMap_8X196KC},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX},
	{ITEMCOUNT(regMap_8X196MX),regMap_8X196MX}
};

DWORD CpuTypeFromID(WORD wCpuID)
{
	if(wCpuID < (WORD)3){
	   return EP_8X98;
	}
	else if(wCpuID < (WORD)0x12){
       return EP_8X96;
    }
	else if(wCpuID < (WORD)0x15){
	   return EP_8X196KA;
	}
	else if(wCpuID < (WORD)0x18){
	   return EP_8X196KB;
	}
	else if(wCpuID < (WORD)0x1B){
	   return EP_8X196KC;
	}
	else if(wCpuID < (WORD)0x1E){
	   return EP_8X196KD;
	}
	else if(wCpuID < (WORD)0x21){
	   return EP_8X196MC;
	}
	else if(wCpuID < (WORD)0x24){
	   return EP_8X196MD;
	}
	else if(wCpuID < (WORD)0x27){
	   return EP_8X196MH;
	}
	else return 0xffff;
}	               

CRegSearch::CRegSearch()
{
	m_nRegNum = 0;
	
	m_pCurRegMap = NULL; 
	
	m_pNameTable = NULL;  
	m_pAddrTable = NULL;
	m_pSerialTable = NULL;
	
	m_pCurCompItem = NULL;
	m_pCurCompFun = NULL;
	m_pCurTable = NULL;
}

CRegSearch::~CRegSearch()
{
	FreeSortTable();
}

BOOL CRegSearch::Init(WORD wCpuID)
{
	ASSERT(wCpuID < ITEMCOUNT(RegMap_total));
	
	m_wCpuID = wCpuID;
	
	m_pCurRegMap = RegMap_total + wCpuID;
	
	InitRegNum();
	
	if (!AllotSortTable()) return FALSE;
	
	if (!SetAllSortTable()){
		FreeSortTable();
		return FALSE;
	}  
	
	return TRUE;
}

void CRegSearch::InitRegNum()
{                                     
	DWORD wCpuType;
	wCpuType = ::CpuTypeFromID(m_wCpuID);
	
	ASSERT(wCpuType != 0xffff); //verify ID of CPU from FW
	ASSERT(m_pCurRegMap != NULL);
	
	CRegCpuItem* pCurRegItem = m_pCurRegMap->pRegMapItem;
	
	m_nRegNum = 0;
	for(int i=0; i<m_pCurRegMap->nTotal; i++, pCurRegItem++)
	{
		if(pCurRegItem->dwSupport & wCpuType)
			m_nRegNum++;
	}
	ASSERT(m_nRegNum != 0);
}                       

void CRegSearch::FreeSortTable()
{
	if (m_pNameTable){
		delete []m_pNameTable;
		m_pNameTable = NULL;
	}
	if (m_pAddrTable){
		delete []m_pAddrTable;
		m_pAddrTable = NULL;
	}                     
	if (m_pSerialTable){
		delete []m_pSerialTable;
		m_pSerialTable = NULL;
	}
}

BOOL CRegSearch::AllotSortTable()
{   
	FreeSortTable();
	ASSERT(m_nRegNum != 0);
	
	m_pNameTable = new int[m_nRegNum];
	m_pAddrTable = new int[m_nRegNum];
	m_pSerialTable = new int[m_nRegNum];
	
	ASSERT(m_pNameTable && m_pAddrTable && m_pSerialTable);
	
	if (m_pNameTable && m_pAddrTable && m_pSerialTable)
		return TRUE;
	
	return FALSE;
}

void CRegSearch::SetValidTable(int* pValidTable)
{                                              
	ASSERT(pValidTable);
	
	DWORD wCpuType;
	wCpuType = CpuTypeFromID(m_wCpuID);
	
	ASSERT(m_pCurRegMap != NULL);
	
	CRegCpuItem* pCurRegItem = m_pCurRegMap->pRegMapItem;
	
	int j = 0;
	for(int i=0; i<m_pCurRegMap->nTotal; i++)
	{
		if(pCurRegItem[i].dwSupport & wCpuType)
			pValidTable[j++] = i;			
	}
	
}

BOOL CRegSearch::SetAllSortTable()
{
	ASSERT(m_nRegNum != 0);
	ASSERT(m_pCurRegMap != NULL);
	
	int *pValidTable;
	pValidTable = new int[m_nRegNum];
	
	if (!pValidTable) return FALSE;
	
	SetValidTable(pValidTable);
	
	SetSortTable(pValidTable, m_pNameTable, SORTINNAME);
	SetSortTable(pValidTable, m_pSerialTable, SORTINSERIAL);
	SetSortTable(pValidTable, m_pAddrTable, SORTINADDR);
	
	delete pValidTable;
	
	return TRUE;	
}

void CRegSearch::SetSortTable(const int* pValidTable, int* pSortTable,  int nType)
{
	ASSERT(pSortTable != NULL);
	ASSERT(m_nRegNum != 0);
	
	memcpy(pSortTable, pValidTable, m_nRegNum*sizeof(int));
	
	pCompareFun	pCurCompFun;
	pCurCompFun = GetCompareFun(nType);

	ASSERT(m_pCurRegMap != NULL);
	
	CRegCpuItem* pCurRegItem = m_pCurRegMap->pRegMapItem;
	
	for(int i=0; i<m_nRegNum-1; i++)
	{
		for(int j=i+1; j<m_nRegNum; j++)
		{
			if ((this->*pCurCompFun)(
				&(pCurRegItem[pSortTable[i]].regItem), 
				&(pCurRegItem[pSortTable[j]].regItem) )>0)
			{
				int temp;       
				temp = pSortTable[i];
				pSortTable[i] = pSortTable[j];
				pSortTable[j] = temp;
			}
		}
	}
}

CRegSearch::pCompareFun CRegSearch::GetCompareFun(int nType)
{
	switch(nType){
		case SORTINNAME:
			return CompareName;
		case SORTINSERIAL:
			return CompareSerial;
		case SORTINADDR:
			return CompareAddr;
		default:
			ASSERT(0);
			return NULL;
	}
}                     

int CRegSearch::CompareName(CRegItem* Item1, CRegItem* Item2)
{
	ASSERT(Item1 != NULL);
	ASSERT(Item2 != NULL);
		
	return stricmp(Item1->szName, Item2->szName);
}

int CRegSearch::CompareSerial(CRegItem* Item1, CRegItem* Item2)
{
	ASSERT(Item1 != NULL);
	ASSERT(Item2 != NULL);
		
	return (int)(Item1->wSerial - Item2->wSerial);
}				   

int CRegSearch::CompareAddr(CRegItem* Item1, CRegItem* Item2)
{
	ASSERT(Item1 != NULL);
	ASSERT(Item2 != NULL);
		
	return (int)(Item1->dwAddr - Item2->dwAddr);
}	

BOOL CRegSearch::NameFromAddr(CRegItem* regItem)
{
	m_pCurCompFun = GetCompareFun(SORTINADDR);
	m_pCurTable = GetSortTable(SORTINADDR);
	m_pCurCompItem = regItem;
	                                   
	ASSERT(m_nRegNum>0);
		                                   
	int nReturn;
	nReturn = FirstMatch(0, m_nRegNum-1);
	
	if (nReturn>=0){
		ASSERT(m_pCurRegMap != NULL);
	
		CRegCpuItem* pCurRegCpuItem = m_pCurRegMap->pRegMapItem;    
		CRegItem* pCurItem = &(pCurRegCpuItem[m_pCurTable[nReturn]].regItem);
		
		if ((regItem->wAttr & pCurItem->wAttr) &&
			(regItem->wLen == pCurItem->wLen))
		{
			if ((regItem->wWindow == pCurItem->wWindow) ||
			    (pCurItem->wWindow == WINDOW_NONE))
			{
				strcpy(regItem->szName, pCurItem->szName);
 				regItem->wType = pCurItem->wType;
        		return TRUE;
			}
		}
			
		for(int i=nReturn+1; i<m_nRegNum; i++){
			pCurItem = &(pCurRegCpuItem[m_pCurTable[i]].regItem);
			if ((this->*m_pCurCompFun)(pCurItem, regItem)==0)
			{
				if ((regItem->wAttr & pCurItem->wAttr) &&
					(regItem->wLen == pCurItem->wLen))
				{
					if ((regItem->wWindow == pCurItem->wWindow) ||
						(pCurItem->wWindow == WINDOW_NONE))
					{
						strcpy(regItem->szName, pCurItem->szName);
						return TRUE;
					}        
				}
				
				continue;
			}
			return FALSE;
		}
	}
	return FALSE;
}			   

BOOL CRegSearch::AddrFromName(CRegItem* regItem)
{
	m_pCurCompFun = GetCompareFun(SORTINNAME);
	m_pCurTable = GetSortTable(SORTINNAME);
	m_pCurCompItem = regItem;
	                                   
	ASSERT(m_nRegNum>0);
		                                   
	int nReturn;
	nReturn = FirstMatch(0, m_nRegNum-1);
	
	if (nReturn>=0){
		ASSERT(m_pCurRegMap != NULL);
	
		CRegCpuItem* pCurRegCpuItem = m_pCurRegMap->pRegMapItem;    
		CRegItem* pCurItem = &(pCurRegCpuItem[m_pCurTable[nReturn]].regItem);
		
		if(regItem->wWindow == pCurItem->wWindow||pCurItem->wWindow==WINDOW_NONE) 
		{
			regItem->dwAddr = pCurItem->dwAddr; 
			regItem->wType = pCurItem->wType;
			return TRUE;
		}
			
		for(int i=nReturn+1; i<m_nRegNum; i++){
			pCurItem = &(pCurRegCpuItem[m_pCurTable[i]].regItem);
			if ((this->*m_pCurCompFun)(pCurItem, regItem)==0)
			{
				if ( regItem->wWindow == pCurItem->wWindow)
				{
					regItem->dwAddr = pCurItem->dwAddr;
        			regItem->wType = pCurItem->wType;
					return TRUE;
				} 
				
				continue;
			}
			return FALSE;
		}
	}
	return FALSE;
}			   

// nRegNum must be inited from caller to get a maximum value
void CRegSearch::GetAllReg(CRegItem* regItem, int& nRegNum)
{                                                      
	ASSERT(nRegNum > 0);	
	for(int i=0; i<nRegNum; i++)
		memset(regItem+i, 0, sizeof(CRegItem));
		
	CRegCpuItem* pCurRegItem = m_pCurRegMap->pRegMapItem;    

	int nMaxNum = 0;	
	for (i=0; i<m_nRegNum; i++){ 
		int nIndex	= m_pSerialTable[i];
		int nSerial = pCurRegItem[nIndex].regItem.wSerial;  
		
		if (nSerial >= 0xff ) continue;
		if (nSerial > nMaxNum) nMaxNum = nSerial;
		
		if (regItem[nSerial].szName[0] == 0){
			memcpy(regItem+nSerial, &(pCurRegItem[nIndex].regItem),
				sizeof(CRegItem));
//			nValidNum++;
		}
	}
	nRegNum = nMaxNum + 1;
}			   

BOOL CRegSearch::ByteFromRegID(CRegItem* regItem)
{
	m_pCurCompFun = GetCompareFun(SORTINSERIAL);
	m_pCurTable = GetSortTable(SORTINSERIAL);
	m_pCurCompItem = regItem;
	                                   
	ASSERT(m_nRegNum>0);
		                                   
	int nReturn;
	nReturn = FirstMatch(0, m_nRegNum-1);
	
	if (nReturn>=0){
		ASSERT(m_pCurRegMap != NULL);
	
		CRegCpuItem* pCurRegCpuItem = m_pCurRegMap->pRegMapItem;    
		CRegItem* pCurItem = &(pCurRegCpuItem[m_pCurTable[nReturn]].regItem);
		
		regItem->wLen = pCurItem->wLen;
		regItem->dwAddr = pCurItem->dwAddr;
		regItem->wType = pCurItem->wType;
		return TRUE;
    }
	return FALSE;
}			   

int CRegSearch::FirstMatch(int i, int j)
{
	ASSERT((i<m_nRegNum) && (i>=0));
    ASSERT((j<m_nRegNum) && (j>=0));
	ASSERT(i<=j);    
	
	ASSERT(m_pCurTable != NULL);
	ASSERT(m_pCurCompFun != NULL);
	
	ASSERT(m_pCurRegMap != NULL);
	
	CRegCpuItem* pCurRegItem = m_pCurRegMap->pRegMapItem;    
	
	int nReturn;
	switch(j-i){
		case 0: // only one item
			nReturn = (this->*m_pCurCompFun)(
				&(pCurRegItem[m_pCurTable[i]].regItem), m_pCurCompItem);
			
			if (nReturn < 0) return GREATER;
			else if(nReturn==0) return i;
			
			return SMALLER;
		
		case 1: // only two items
			nReturn = (this->*m_pCurCompFun)(
				&(pCurRegItem[m_pCurTable[i]].regItem), m_pCurCompItem);
			
		    if (nReturn<0){
				nReturn = (this->*m_pCurCompFun)(
					&(pCurRegItem[m_pCurTable[j]].regItem), m_pCurCompItem);
				
				if (nReturn < 0) return GREATER;
				else if(nReturn==0) return j;
			
				return SMALLER;
			}
			else if(nReturn==0) return i;
			
			return SMALLER;
						
		default: // greater than two items
		{
			int k = (i+j)/2;
			nReturn = FirstMatch(i, k);
			switch(nReturn){
				case GREATER:
					k++;
					
					if (k>j) return nReturn;
					else
						return FirstMatch((i+j)/2+1, j);
				default:
					return nReturn;
			}		
		}			
	}		    	
}

int* CRegSearch::GetSortTable(int nType)
{                  
	switch(nType){
		case SORTINNAME:
			return m_pNameTable;
		case SORTINADDR:
			return m_pAddrTable;
		case SORTINSERIAL:
			return m_pSerialTable;
		default:
			ASSERT(0);
			return 0;
	}
}   

BOOL WINAPI InitDllVar(WORD wCpuID)
{
	return regSearch.Init(wCpuID);
}

BOOL WINAPI RegNameFromAddr(CRegItem* regItem)
{
	return regSearch.NameFromAddr(regItem);
}

BOOL WINAPI RegAddrFromName(CRegItem* regItem)
{                                                           
	return regSearch.AddrFromName(regItem);
}

BOOL WINAPI ByteFromRegID(CRegItem* regItem)
{
    return regSearch.ByteFromRegID(regItem);
}

void WINAPI GetAllReg(CRegItem* regItem, int& nRegNum)
{
	regSearch.GetAllReg(regItem, nRegNum);
}

void WINAPI DelRegMem()
{
   regSearch.FreeSortTable();
}

