/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  REGMAP.H
**
** Author:      Richard Guo
                Modified by Dragon
** Description: Register internal class definition.
**
** coding from: Jan. 29, 1997
** Finished date:
**
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**                        
****************************************************************************/

#ifndef _regmap_h
#define _regmap_h

#include "regsvr.h"

#define MEM_UNDEFINED	0
#define MEM_P0			1
#define MEM_P1			2
#define MEM_P2			3
#define MEM_P3			4
#define MEM_X0			5
#define MEM_X1			6
#define MEM_X2			7
#define MEM_X3			8
#define MEM_I			10

#define EP_8X96		(DWORD)1
#define EP_8X98		(DWORD)2
#define EP_8X196KA	(DWORD)4
#define EP_8X196KB	(DWORD)8
#define EP_8X196KC	(DWORD)0x10   
#define EP_8X196KD  (DWORD)0x20
#define EP_8X196MC  (DWORD)0x40
#define EP_8X196MD  (DWORD)0x80
#define EP_8X196MH  (DWORD)0x100

typedef struct{
	CRegItem 	 regItem;
	DWORD		 dwSupport;
}CRegCpuItem;

typedef struct{
	int		nTotal;
	CRegCpuItem* pRegMapItem;
}CRegMap;


class CRegSearch{
public:           
	enum { SORTINNAME, SORTINSERIAL, SORTINADDR};
	enum { NOT_EXIST = -1, GREATER = -2, SMALLER = -3};
	typedef int (CRegSearch::*pCompareFun)(CRegItem*, CRegItem*);
	
	CRegSearch();
	virtual ~CRegSearch();

public:
	BOOL	Init(WORD wCpuID);
	BOOL	NameFromAddr(CRegItem* regItem);
	BOOL	AddrFromName(CRegItem* regItem);
	BOOL	ByteFromRegID(CRegItem* regItem);
	void    GetAllReg(CRegItem*, int &nRegNum);
	void	FreeSortTable();

protected:
	void	InitRegNum();  
	BOOL	AllotSortTable();   
	BOOL	SetAllSortTable();
	void	SetSortTable(const int* pValidTable, int* pSortTable, int nType);
	void	SetValidTable(int* pValidTable);
	
	
	int		CompareSerial(CRegItem* Item1, CRegItem* Item2);
	int		CompareName(CRegItem* Item1, CRegItem* Item2);
	int		CompareAddr(CRegItem* Item1, CRegItem* Item2);
	pCompareFun	GetCompareFun(int nType);
	int*	GetSortTable(int nType);   
	
	int		FirstMatch(int i, int j);
	
public:            
	WORD	m_wCpuID;
	       
	CRegMap *m_pCurRegMap;   
	int		m_nRegNum;
	
	int		*m_pNameTable;
	int		*m_pAddrTable;
	int		*m_pSerialTable;

private:
	int		*m_pCurTable;
	pCompareFun m_pCurCompFun;
	CRegItem*	m_pCurCompItem;
};

#endif;

                                                                            
                                                                            
/**********************************end of file*****************************/