/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  REGSVR.H
**
** Author:      Richard Guo
** Description: Register structure, constants and routines definition.
**
** coding from: Jan. 29, 1997
** Finished date:
**
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**                        
****************************************************************************/
#ifdef __cplusplus
extern "C"{
#endif
#ifndef _regsvr_h
#define _regsvr_h

#define OP_NONE		0
#define OP_R			1
#define OP_W			2
#define OP_RW			3

#define WINDOW_NONE		0X3F

typedef struct{
	char	szName[20];
	WORD 	wSerial;
    DWORD	dwAddr;
    WORD 	wType : 4;
    WORD	wAttr : 2;
    WORD	wLen : 4;
    WORD	wWindow : 6;
}CRegItem;    

BOOL WINAPI InitDllVar(WORD wCpuID);
BOOL WINAPI RegNameFromAddr(CRegItem*);
BOOL WINAPI RegAddrFromName(CRegItem*);
BOOL WINAPI ByteFromRegID(CRegItem*);
void WINAPI GetAllReg(CRegItem*, int& nRegNum);
void WINAPI InitDLL_RegMap();
void WINAPI DelRegMem();
#endif
#ifdef __cplusplus
}
#endif;


/*********************************end of file***************************/ 
