#
# Makefile for examples for the 196Kc eval board
#
# This Makefile must be used with Tasking's make utility.
# Not every make utility will understand the syntax.
#

# These options are for 196Mc
MODEL   = model(mc)
ASFLAGS = $(MODEL) debug list
CCFLAGS = $(MODEL) type debug code dn(0) ot(0) ms
CSTART  = cstart.obj
LIBS    = fpal96.lib c96.lib c96fp.lib
LDFLAGS = $(MODEL) ram(01Ah-0FFh) rom(02000h-0CFFFh) ram(0DC00h-0DFFFh) ss(+6) sfr ixref

all:        mc.hex

mc.hex:  mc.abs

mc.abs:  prime1.obj prime2.obj prime3.obj cstart.obj makefile
	$(LD) -f <<EOF
		$(separate ", &\n" $(match .obj $!) $(match .lib $!) $(LIBS)) &
		to $@ &
		$(LDFLAGS)
	EOF

cstart.obj:   cstart.a96 makefile
	asm196 -f << EOF
        cstart.a96 ri $(MODEL) cmain
	EOF

prime1.obj: prime1.c makefile
prime2.obj: prime2.c makefile
prime3.obj: prime3.c makefile
clean:
    $(RM) *.abs
    $(RM) *.obj
    $(RM) *.m96
	$(RM) *.lst


