/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCADDR.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCADDR.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:26   ZJRD
** 1.0c
** 
****************************************************************************/

// srcaddr.h : header file
//
#ifndef _SRCADDR_H_
#define _SRCADDR_H_

//#undef AFXAPP_DATA
//#define AFXAPP_DATA AFXAPI_DATA

/////////////////////////////////////////////////////////////////////////////
// CSourceAddr

class CSourceAddr : public CObject
{
	DECLARE_SERIAL(CSourceAddr)

// Contruction & Destruction
public:
    CSourceAddr() { }

    CSourceAddr(const CSourceAddr& Addr) 
    	: m_dwAddr(Addr.GetAddr()), m_bType(Addr.GetType()) { }

    CSourceAddr(const DWORD& dwAddr, const BYTE& nType) 
    	: m_dwAddr(dwAddr), m_bType(nType) { }

    virtual ~CSourceAddr() { }

// Attributes
protected:
    BYTE 	m_bType;
    DWORD 	m_dwAddr;

public:
	DWORD GetAddr() const { return m_dwAddr; }
	void SetAddr(const DWORD& dwAddr) { m_dwAddr = dwAddr; }
	
	BYTE GetType() const { return m_bType; }
	void SetType(const BYTE& nType) { m_bType = nType; }
	
// Operator
public:
	// =
    void operator=(const CSourceAddr& Addr)
    {
	    m_dwAddr = Addr.m_dwAddr;
	    m_bType = Addr.m_bType;
	}

	// +
    CSourceAddr operator+(const CSourceAddr& Addr) const
    {
    	ASSERT(Addr.m_bType == m_bType);
    	
	    CSourceAddr TmpAddr;
	    TmpAddr.m_dwAddr = m_dwAddr + Addr.m_dwAddr;
	    TmpAddr.m_bType = m_bType;

	    return TmpAddr;
    }

    CSourceAddr operator+(const DWORD& dwOffset) const
    {
	    CSourceAddr TmpAddr;
	    TmpAddr.m_dwAddr = m_dwAddr + dwOffset;
	    TmpAddr.m_bType = m_bType;

	    return TmpAddr;
    }

	// -
    CSourceAddr operator-(const CSourceAddr& Addr) const
    {
    	ASSERT(Addr.m_bType == m_bType);
    	
	    CSourceAddr TmpAddr;
	    TmpAddr.m_dwAddr = m_dwAddr + Addr.m_dwAddr;
	    TmpAddr.m_bType = m_bType;

	    return TmpAddr;
    }
    
    CSourceAddr operator-(const DWORD& dwOffset) const
    {
	    CSourceAddr TmpAddr;
	    TmpAddr.m_dwAddr = m_dwAddr - dwOffset;
	    TmpAddr.m_bType = m_bType;

	    return TmpAddr;
    }
    
	// ==
    BOOL operator==(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType == m_bType && Addr.m_dwAddr == m_dwAddr );
    }

    BOOL operator==(const DWORD& dwAddr) const
    {
		return ( dwAddr == m_dwAddr );
    }

	// !=
    BOOL operator!=(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType != m_bType || Addr.m_dwAddr != m_dwAddr );
    }

    BOOL operator!=(const DWORD& dwAddr) const
    {
		return ( dwAddr != m_dwAddr );
    }

	// <
    BOOL operator<(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType == m_bType && m_dwAddr < Addr.m_dwAddr );
    }

    BOOL operator<(const DWORD& dwAddr) const
    {
		return ( m_dwAddr < dwAddr );
    }

	// >
    BOOL operator>(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType == m_bType && m_dwAddr > Addr.m_dwAddr );
    }

    BOOL operator>(const DWORD& dwAddr) const
    {
		return ( m_dwAddr > dwAddr );
    }

	// <=
    BOOL operator<=(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType == m_bType && m_dwAddr <= Addr.m_dwAddr );
    }

    BOOL operator<=(const DWORD& dwAddr) const
    {
		return ( m_dwAddr <= dwAddr );
    }

	// >=
    BOOL operator>=(const CSourceAddr& Addr) const
    {
		return ( Addr.m_bType == m_bType && m_dwAddr >= Addr.m_dwAddr );
    }

    BOOL operator>=(const DWORD& dwAddr) const
    {
		return ( m_dwAddr >= dwAddr );
    }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

//#undef AFXAPP_DATA
//#define AFXAPP_DATA NEAR

#endif
