/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/GLOBAL.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/GLOBAL.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
****************************************************************************/

// global.h : header file
//
#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "symblsvr.h"

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CSourceSearchDlg;


/////////////////////////////////////////////////////////////////////////////
// Global variable

extern CMultiDocTemplate* pSourceTemplate;
extern CMultiDocTemplate* pBrowseTemplate;

extern CMDIChildWnd* pSourceWnd;
extern CMDIChildWnd* pBrowseWnd;

extern int nSrcLoadOption;
extern CString* pSrcTargetPath;

extern CStringList* pSourcePathList;
extern CStringList* pSourceExtNameList;

extern CObList* pBpDataList;

extern CSourceSearchDlg* pSrcSearchDlg;
extern BOOL bSrcSearchWord;
extern BOOL bSrcSearchCase;
extern int nSrcSearchDirect;
extern CStringList* pSourceSearchList;

extern int nSrcGroupEntry;

extern int nSrcModuleDepth;
extern int nSrcModuleIndex;
extern CObList* pSourceModuleDescList;

extern CStringList* pSourceFromList;
extern CStringList* pSourceJumpList;

extern BOOL bSrcHintsOn;

extern CObList* pSourceModuleInfoList;


/////////////////////////////////////////////////////////////////////////////
// Global enum

//enum { MAX_DEPTH = 20 };
enum { SRC_NULL = 0, SRC_MAIN, SRC_SOURCE, SRC_BROWSE };
enum {
	// Default: LDR_CODE|LDR_SYMBOL|LDR_STATUS|LDR_WARNING
	LDR_CODE 	= 0x1,
	LDR_SYMBOL  = 0x2,
	LDR_STATUS  = 0x4,
	LDR_WARNING = 0x8,
	LDR_DEMAND  = 0x10,
};


/////////////////////////////////////////////////////////////////////////////
// Global function

HINSTANCE SrcGetDLLHandle();

void SrcUpdateSourceWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp);
void SrcUpdateBrowseWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp);

void SrcHideDataTip();
void SrcHideHintTip();

BOOL SrcGetAllModuleInfo();

BOOL SrcGetModuleList(CStringList* &pList);
BOOL SrcGetFunctionList(const CString& strModule, CStringList* &pList);
BOOL SrcGetModuleName(const SYM_DESCRIPTOR dwModuleDesc, CString& strModuleName);
BOOL SrcGetLineRange(const int nLine, CSourceAddr& AddrStart, CSourceAddr& AddrEnd);
BOOL SrcGetModule(const CSourceAddr& Addr, CString& strModulePath, SYM_DESCRIPTOR& dwModuleDesc);
BOOL SrcIsInSource(const CSourceAddr& Addr);

void SrcGetModuleAddrRange(const CString& strModule, CString& strRange);
void SrcGetLoadInfo(CString& strModule, CString& strSymbol, CString& strType, CString& strFunction, CString& strByte, CString& strLine, CString& strPC);

void SrcGetInitPC(CSourceAddr& AddrPC);
void SrcSetInitPC(const CSourceAddr& AddrPC);

BOOL SrcAddrToLine(const CSourceAddr& Addr, int& nLine, int& nStart, int& nEnd);

BOOL SrcIsMarkVariable(const CString& strToken, const int nLine);
BOOL SrcIsMarkFunction(const CString& strToken);

void SrcAddModuleDesc(const int nModuleSelect);

int SrcGetModuleIndex();
BOOL SrcGetModuleDesc(SYM_DESCRIPTOR& dwModuleDesc);

#endif
/////////////////////////////////////////////////////////////////////////////
