/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCBP.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCBP.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
****************************************************************************/

// srcbp.h : header file
//
#ifndef _SRCBP_H_
#define _SRCBP_H_

/////////////////////////////////////////////////////////////////////////////
// CSourceBreakpointPage

class CSourceBreakpointPage : public CPropertyPage
{
// Construction
public:
	CSourceBreakpointPage(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSourceBreakpointPage)
	enum { IDD = IDD_SRC_BP };
	CButton	m_btnRestore;
	CButton	m_btnSave;
	CListBox	m_lstBp;
	CComboBox	m_comboFunction;
	CComboBox	m_comboModule;
	CButton	m_btnDeleteAll;
	CButton	m_btnDelete;
	CButton	m_btnDisable;
	CButton	m_btnEnable;
	CButton	m_btnAdd;
	CString	m_strAddr;
	//}}AFX_DATA


// Overrides
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();
	virtual BOOL OnSetActive();

// Implementation
protected:
	void EnableControl();
	void GetBPInfo();
	void SetBPInfo();
	void GetModuleInfo();
	void GetFunctionInfo(const CString& strModule, CStringList* &pList);
	void GetFunctionInfo();
	void SetBpAddr();
	BOOL GetOneBp(CBpData* pObj, CString& strOneBp);
	void GetOneBp(const CString& strOneBp, CBpData& BpData) const;
	BOOL AddOneBp();
	BOOL SaveBpFile();
	BOOL RestoreBpFile();
	BOOL SetAllBp();

protected:
	// Generated message map functions
	//{{AFX_MSG(CSourceBreakpointPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonSrcbpAdd();
	afx_msg void OnButtonSrcbpEnable();
	afx_msg void OnButtonSrcbpDisable();
	afx_msg void OnButtonSrcbpDelete();
	afx_msg void OnButtonSrcbpDelall();
	afx_msg void OnSelchangeComboSrcbpModule();
	afx_msg void OnSelchangeComboSrcbpFunction();
	afx_msg void OnSelchangeListSrcbpBp();
	afx_msg void OnDblclkListSrcbpBp();
	afx_msg void OnButtonSrcbpSave();
	afx_msg void OnButtonSrcbpRestore();
	afx_msg void OnChangeEditSrcbpAddr();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
