/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCEXT.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCEXT.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:08   ZJRD
** 1.0c
** 
****************************************************************************/

// srcext.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcsht.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceExtensionNamePage

CSourceExtensionNamePage::CSourceExtensionNamePage(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CSourceExtensionNamePage::IDD)
{
	pParent;

	//{{AFX_DATA_INIT(CSourceExtensionNamePage)
	m_strName = _T("");
	//}}AFX_DATA_INIT
}

void CSourceExtensionNamePage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceExtensionNamePage)
	DDX_Control(pDX, IDC_LIST_EXTNAME, m_lstName);
	DDX_Control(pDX, IDC_BUTTON_REMOVE, m_btnRemove);
	DDX_Control(pDX, IDC_BUTTON_MOVEUP, m_btnUp);
	DDX_Control(pDX, IDC_BUTTON_MOVEDOWN, m_btnDown);
	DDX_Control(pDX, IDC_BUTTON_MODIFY, m_btnModify);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_btnAdd);
	DDX_Text(pDX, IDC_EDIT_EXTNAME, m_strName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourceExtensionNamePage, CPropertyPage)
	//{{AFX_MSG_MAP(CSourceExtensionNamePage)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_MODIFY, OnButtonModify)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_MOVEUP, OnButtonMoveup)
	ON_BN_CLICKED(IDC_BUTTON_MOVEDOWN, OnButtonMovedown)
	ON_EN_CHANGE(IDC_EDIT_EXTNAME, OnChangeEditExtname)
	ON_LBN_SELCHANGE(IDC_LIST_EXTNAME, OnSelchangeListExtname)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceExtensionNamePage common routines

void CSourceExtensionNamePage::EnableControl()
{
	// Refer to Edit box
	BOOL bEnable = m_strName.IsEmpty() ? FALSE : TRUE;
	m_btnAdd.EnableWindow(bEnable);
	
	// Refer to List box
	bEnable = m_lstName.GetCount() > 0 ? TRUE : FALSE;
	m_btnRemove.EnableWindow(bEnable);
	m_btnModify.EnableWindow(bEnable);

	// Refer to index of List box
	if ( bEnable ) {
		bEnable = 0 == m_lstName.GetCurSel() ? FALSE : TRUE;
		m_btnUp.EnableWindow(bEnable);
		bEnable = m_lstName.GetCount()-1 == m_lstName.GetCurSel() ? FALSE : TRUE;
		m_btnDown.EnableWindow(bEnable);
	}
	else {
		m_btnUp.EnableWindow(bEnable);
		m_btnDown.EnableWindow(bEnable);
	}
}

BOOL CSourceExtensionNamePage::CheckSyntax()
{
	// Get input string
	m_strName.TrimLeft();
	m_strName.TrimRight();

	if ( '.' == m_strName[0] && m_strName.GetLength() > 1 ) {
		m_strName = m_strName.Right(m_strName.GetLength()-1);
	}

	if ( m_strName.GetLength() > 3 ) {
		::SrcDisplayErrorMessage(::errExtTooLong);
		return FALSE;
	}

	if ( m_strName.GetLength() == 0 ) {
		::SrcDisplayErrorMessage(::errExtEmpty);
		return FALSE;
	}

	for ( int i(0); i < m_strName.GetLength(); i++ ) {
		if ( ',' == m_strName[i] ||
             '=' == m_strName[i] ||
             '+' == m_strName[i] ||
             '|' == m_strName[i] ||
             '[' == m_strName[i] ||
             ']' == m_strName[i] ||
             ';' == m_strName[i] ||
             '\"'== m_strName[i] ||
             '<' == m_strName[i] ||
             '>' == m_strName[i] ||
             '\\'== m_strName[i] ||
             ':' == m_strName[i] ||
             '/' == m_strName[i] ||
             '.' == m_strName[i] ||
             '*' == m_strName[i] ||
             '?' == m_strName[i] ) {
			::SrcDisplayErrorMessage(::errExtChar);
			return FALSE;
		}
	}
		
	m_strName = CString('.') + m_strName;

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CSourceExtensionNamePage message handlers

void CSourceExtensionNamePage::OnOK()
{
	// Write to list
	UpdateData();

	::pSourceExtNameList->RemoveAll();
	int nCount = m_lstName.GetCount();
	if ( LB_ERR != nCount ) {
		for ( int i(0); i < nCount; i++ ) {
			CString strName;
			m_lstName.GetText(i, strName);
			::pSourceExtNameList->AddTail(strName);
		}
	}

	// Changed this page
	SetModified(FALSE);
	CancelToClose();
}

BOOL CSourceExtensionNamePage::OnSetActive()
{
	// TODO: Add your message handler code here

	return CPropertyPage::OnSetActive();
}

BOOL CSourceExtensionNamePage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here

	// Set list font
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	m_lstName.SetFont(font.FromHandle(hFont));
	
	// Get extension name
	m_lstName.ResetContent();
	POSITION pos = ::pSourceExtNameList->GetHeadPosition();
	while ( pos ) {
		CString strName = ::pSourceExtNameList->GetNext(pos);
		m_lstName.AddString(strName);
	}
	
	// Enable edit control
	int nCount = m_lstName.GetCount();
	if ( nCount > 0 ) {
		m_lstName.SetCurSel(0);
		m_lstName.GetText(0, m_strName);
		if ( m_strName.GetLength() > 1 ) {
			m_strName = m_strName.Right(m_strName.GetLength()-1);
		}
	}
	
	// Enable controls
	EnableControl();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourceExtensionNamePage::OnButtonAdd() 
{
	// TODO: Add your control notification handler code here

	// Add to List box
	UpdateData();
	
	if ( !CheckSyntax() ) {
		return;
	}

	BOOL bExist(FALSE);
	for ( int i(0); i < m_lstName.GetCount(); i++ ) {
		CString strName;
		m_lstName.GetText(i, strName);
		if ( m_strName == strName ) {
			bExist = TRUE;
			break;
		}
	}
	
	if ( bExist ) {
		::SrcDisplayErrorMessage(::errExtExist);
	}
	else {
		m_lstName.AddString(m_strName);
		if ( 1 == m_lstName.GetCount() ) {
			m_lstName.SetCurSel(0);
		}
		EnableControl();
		SetModified();
	}
}

void CSourceExtensionNamePage::OnButtonModify() 
{
	// TODO: Add your control notification handler code here
	
	// Add to List box
	UpdateData();
	
	if ( !CheckSyntax() ) {
		return;
	}

	BOOL bExist(FALSE);
	for ( int i(0); i < m_lstName.GetCount(); i++ ) {
		CString strName;
		m_lstName.GetText(i, strName);
		if ( m_strName == strName ) {
			bExist = TRUE;
			break;
		}
	}
	
	if ( bExist ) {
		::SrcDisplayErrorMessage(::errExtExist);
	}
	else {
		int nSelect = m_lstName.GetCurSel();
	    m_lstName.DeleteString(nSelect);
	    m_lstName.InsertString(nSelect, m_strName);
    	m_lstName.SetCurSel(nSelect);
		SetModified();
	}
}

void CSourceExtensionNamePage::OnButtonRemove() 
{
	// TODO: Add your control notification handler code here

	// Remove the selected name
	UpdateData();

	int nSelect = m_lstName.GetCurSel();
    m_lstName.DeleteString(nSelect);
    if ( --nSelect >= 0 ) {
    	m_lstName.SetCurSel(nSelect);
    }
    else {
    	if ( m_lstName.GetCount() >= 1 ) {
			m_lstName.SetCurSel(0);
		}
		EnableControl();
	}

	SetModified();
}

void CSourceExtensionNamePage::OnButtonMoveup() 
{
	// TODO: Add your control notification handler code here

	// Delete selected item & Insert to previous position
	UpdateData();
	
	int nSelect = m_lstName.GetCurSel();
	CString strName;
	m_lstName.GetText(nSelect, strName);
    m_lstName.DeleteString(nSelect);
    m_lstName.InsertString(--nSelect, strName);
	m_lstName.SetCurSel(nSelect);

	EnableControl();
	SetModified();
}

void CSourceExtensionNamePage::OnButtonMovedown() 
{
	// TODO: Add your control notification handler code here

	// Delete selected item & Insert to next position
	UpdateData();
	
	int nSelect = m_lstName.GetCurSel();
	CString strName;
	m_lstName.GetText(++nSelect, strName);
    m_lstName.DeleteString(nSelect);
    m_lstName.InsertString(nSelect-1, strName);
	m_lstName.SetCurSel(nSelect);

	EnableControl();
	SetModified();
}

void CSourceExtensionNamePage::OnChangeEditExtname() 
{
	// TODO: Add your control notification handler code here

	// Enable controls
	UpdateData();

	EnableControl();
}

void CSourceExtensionNamePage::OnSelchangeListExtname() 
{
	// TODO: Add your control notification handler code here
	
	// Enable controls
	UpdateData();

	EnableControl();
}
