/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCFRM.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCFRM.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:47:10   ZJRD
** 1.0c
** 
****************************************************************************/

// srcfrm.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcaddr.h"

#include "srcdata.h"
#include "srctext.h"
#include "srcbar.h"
#include "srcfrm.h"
#include "srcdoc.h"
#include "srcview.h"
#include "srcsrch.h"

#include "abiextfn.h"
#include "flttool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceFrame

IMPLEMENT_DYNCREATE(CSourceFrame, CMDIChildWnd)

#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// Exported function

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

CMDIChildWnd* WINAPI SrcGetSourceWindow()
{
	// Point to Source window
	return ::pSourceWnd;
}

BOOL WINAPI SrcIsSourceWindowOpened()
{
	// Is it opening?
	return (0 != ::pSourceWnd);
}

void WINAPI SrcOpenSourceWindow()
{
	// Check CPU status
	DWORD dwStatus;
	if ( ICE_OK != ::emuGetCpuStatus(&dwStatus) || (dwStatus & 0x10) ) {
		::SrcDisplayErrorMessage(::errEPRun);
		return;
	}

	// Open Source window
    ASSERT(!::pSourceWnd);
	::pSourceTemplate->OpenDocumentFile(NULL);
	
	// Update Source window
    ASSERT(::pSourceWnd);
	((CSourceFrame*)::pSourceWnd)->UpdateSourceWindow(::srcOpen);
}

void WINAPI SrcCloseSourceWindow()
{
    // Close Source window
    ASSERT(::pSourceWnd);
    ::pSourceWnd->SendMessage(WM_CLOSE);
}

void WINAPI SrcUpdateSourceWindow(int nMode, const BOOL bOpenFirst /* = FALSE */)
{
	// Check CPU status
	DWORD dwStatus;
	if ( ICE_OK != ::emuGetCpuStatus(&dwStatus) || (dwStatus & 0x10) ) {
//		::SrcDisplayErrorMessage(::errEPRun);
		return;
	}

	// Open source window first
	if ( bOpenFirst ) {
		if ( !::pSourceWnd ) {
			::pSourceTemplate->OpenDocumentFile(NULL);
			nMode = ::srcOpen;
		}
		if ( ::pSourceWnd->IsIconic() ) {
        	::pSourceWnd->ShowWindow(SW_RESTORE);
        }
		::pSourceWnd->BringWindowToTop();
	}
	
	// Source window is opened
    if ( ::pSourceWnd ) {
		// Update wizard bar
		if ( ::srcOpen == nMode ) {
			::SrcUpdateSourceWizardBar(FALSE, TRUE, FALSE, FALSE, TRUE);
		}
		else {
			::SrcUpdateSourceWizardBar(FALSE, FALSE, TRUE, TRUE, FALSE);
		}
	
		// Update Source window
		((CSourceFrame*)::pSourceWnd)->UpdateSourceWindow(nMode);
	}
}

#ifdef __cplusplus
}
#endif	// __cplusplus

/////////////////////////////////////////////////////////////////////////////
// Public function

void SrcHideDataTip()
{
	// Hide data tip if Source window is opened
	if ( ::pSourceWnd ) {
		((CSourceView*)((CSourceFrame*)::pSourceWnd)->GetActiveView())->HideDataTip();
	}
}

void SrcHideHintTip()
{
	// Hide hints tip if Source window is opened
	if ( ::pSourceWnd ) {
		((CSourceWizardBar*)((CSourceFrame*)::pSourceWnd)->GetWizardBar())->HideHintTip();
	}
}

void SrcUpdateSourceWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp)
{
	bInitBar;
	bGetModule;
	bSelModule;
	bGetInfo;
	bRedrawProp;

	// Update wizard bar
//	((CSourceFrame*)::pSourceWnd)->GetWizardBar()->UpdateWizardBar(bInitBar, bGetModule, bSelModule, bGetInfo, bRedrawProp);
}

/////////////////////////////////////////////////////////////////////////////
// CSourceFrame

CSourceFrame::CSourceFrame()
{
	// Point to the Source window
	::pSourceWnd = this;
}

CSourceFrame::~CSourceFrame()
{
	// Point to NULL
	::pSourceWnd = 0;
}

BEGIN_MESSAGE_MAP(CSourceFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CSourceFrame)
	ON_WM_GETMINMAXINFO()
	ON_WM_MDIACTIVATE()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_CBN_SELCHANGE(IDC_COMBO_SRC_WIZARDBAR_MODULE, OnSelchangeComboSrcWizardbarModule)
	ON_BN_CLICKED(IDC_PROP, OnProp)
	ON_UPDATE_COMMAND_UI(IDC_PROP, OnUpdateProp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceFrame common routine

void CSourceFrame::UpdateSourceWindow(const int nMode)
{
	// Update source view
	((CSourceView*)GetActiveView())->SetBrowseMode(FALSE);
	((CSourceView*)GetActiveView())->UpdateSourceWindow(nMode);
}

/////////////////////////////////////////////////////////////////////////////
// CSourceFrame message handlers

void CSourceFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	// TODO: Add your message handler code here and/or call default

    // Set the minimum range
//    CRect rect(0,0,0,34);
    CRect rect(0,0,0,0);
    if ( m_wndWizardBar.GetSafeHwnd() ) {
    	m_wndWizardBar.GetWindowRect(rect);
    }

    int xMin = 23*8 + ::GetSystemMetrics(SM_CXVSCROLL);
    int yMin = 4*13 + rect.Height() + ::GetSystemMetrics(SM_CYHSCROLL) + ::GetSystemMetrics(SM_CYCAPTION) + ::GetSystemMetrics(SM_CYFRAME) + 2;
    lpMMI->ptMinTrackSize = CPoint(xMin, yMin);
    
	CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}

void CSourceFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
	
	// TODO: Add your message handler code here
	
	// Update toolbar
    if ( bActivate && this == pActivateWnd ) {
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), LONG(WID_SOURCE));
    }
    else if ( !bActivate && !pActivateWnd ) {
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate));
    }
}

void CSourceFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default

	// Close search dialog
    if ( ::pSrcSearchDlg && !::pBrowseWnd ) {
    	::pSrcSearchDlg->SendMessage(WM_COMMAND, IDCANCEL);
    }

	CMDIChildWnd::OnClose();
}

int CSourceFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Create Wizard Bar
//	if ( !m_wndWizardBar.Create(this, IDD_SRC_WIZARDBAR, CBRS_TOP, IDD_SRC_WIZARDBAR) ) {
//		TRACE0("Failed to create wizard bar\n");
//		return -1;
//	}
//	else {
//		::SrcUpdateSourceWizardBar(TRUE, TRUE, FALSE, FALSE, TRUE);
//	}

	return 0;
}

void CSourceFrame::OnSelchangeComboSrcWizardbarModule()
{
	// TODO: Add your control notification handler code here
	
	// Set Browse index
	CComboBox* pCombo = (CComboBox*)(m_wndWizardBar.GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE));
	int nSelect(-1);
	if ( pCombo->GetCount() >= 1 ) {
		nSelect = pCombo->GetCurSel();
	}
	::SrcAddModuleDesc(nSelect);

	// Browse one module
	::nSrcGroupEntry = ::SRC_SOURCE;
	::SrcBrowseModule();

    // Set focus to view
	GetActiveView()->SetFocus();
}

void CSourceFrame::OnProp()
{
	// TODO: Add your control notification handler code here

	// Toggle source hints
	::bSrcHintsOn = !::bSrcHintsOn;

	// Update wizard bar
	::SrcUpdateSourceWizardBar(FALSE, FALSE, FALSE, FALSE, TRUE);
    
    // Set focus to view
	GetActiveView()->SetFocus();
}

void CSourceFrame::OnUpdateProp(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	// Grayed if no hints
	pCmdUI->Enable(::SrcIsLoadedSymbol() && ::SrcGetMode() == ::modSrc);
}
