/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCICON.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCICON.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:24   ZJRD
** 1.0c
** 
****************************************************************************/

// srcicon.h : header file
//
#ifndef _SRCICON_H_
#define _SRCICON_H_

/////////////////////////////////////////////////////////////////////////////
// CSourceIconWnd window

class CSourceIconWnd : public CStatic
{
    DECLARE_DYNAMIC(CSourceIconWnd)

// Construction
public:
	CSourceIconWnd();

// Attributes
protected:
	enum { head = 0, tree, circle, clouds, tail };

protected:
	int m_nWhichIcon;

protected:
	CRect m_rectClient;

protected:
	CBitmap m_bmpClouds;
	int m_nCloudsX;

protected:
	CBitmap m_bmpTree;

protected:
	int m_nRatio;
	COLORREF m_clrRGB;

// Operations
public:
	void UpdateIconWindow(BOOL bNewIcon = TRUE);

// Implementation
protected:
	void PaintIcon(CDC* pDC = NULL);
	
	void ClearScreen();

	void DrawClouds(CDC* pDC);
	void DrawTree(CDC* pDC);
	void DrawCircle(CDC* pDC);
	
protected:
	void GetRandRGB();
	void GetRandRatio();

public:
	virtual ~CSourceIconWnd();

protected:
    virtual WNDPROC* GetSuperWndProcAddr()
    {
		static WNDPROC NEAR pfnSuper;
		return &pfnSuper;
	}

protected:
	// Generated message map functions
	//{{AFX_MSG(CSourceIconWnd)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
