/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCMOD.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCMOD.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:10   ZJRD
** 1.0c
** 
****************************************************************************/

// srcmod.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcsht.h"
#include "srcgbl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Global string

static char BASED_CODE szDate[] = "%02d/%02d/%02d - %02d:%02d:%02d";
static char BASED_CODE szInt[] = "%d";

/////////////////////////////////////////////////////////////////////////////
// CSourceBrowseModulePage

CSourceBrowseModulePage::CSourceBrowseModulePage(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CSourceBrowseModulePage::IDD)
{
	pParent;

	//{{AFX_DATA_INIT(CSourceBrowseModulePage)
	m_strDepth = "";
	//}}AFX_DATA_INIT
}


void CSourceBrowseModulePage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceBrowseModulePage)
	DDX_Control(pDX, IDC_LIST_INFO, m_lstInfo);
	DDX_Control(pDX, IDC_LIST_MODULE, m_lstModule);
	DDX_Text(pDX, IDC_STATIC_BROWSE_DEPTH, m_strDepth);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourceBrowseModulePage, CPropertyPage)
	//{{AFX_MSG_MAP(CSourceBrowseModulePage)
	ON_LBN_SELCHANGE(IDC_LIST_MODULE, OnSelchangeListModule)
	ON_LBN_DBLCLK(IDC_LIST_MODULE, OnDblclkListModule)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceBrowseModulePage common routines

void CSourceBrowseModulePage::GetModuleInfo()
{
	// If symbol is not loaded, cancel
	if ( !::SrcIsLoadedSymbol() ) {
		return;
	}
	
	// Get module info from Symbol server
	CStringList* pModuleList = new CStringList;
	::SrcGetModuleList(pModuleList);
	
	// Add to the list box
	int nLen(0);
	m_lstModule.ResetContent();
	POSITION pos = pModuleList->GetHeadPosition();
	while ( pos ) {
		CString strModule = pModuleList->GetNext(pos);
		nLen = max(nLen, strModule.GetLength());
		m_lstModule.AddString(strModule);
	}

	m_lstModule.SetHorizontalExtent(8*(nLen+1));
	
	if ( m_lstModule.GetCount() > 0 ) {
		m_lstModule.SetCurSel(0);
		SetInfoList();
	}

	// Free module info list
	pModuleList->RemoveAll();
	delete pModuleList;
}

void CSourceBrowseModulePage::SetModuleInfo()
{
	// Set Browse index
	int nSelect(-1);
	if ( m_lstModule.GetCount() >= 1 ) {
		nSelect = m_lstModule.GetCurSel();
	}
	::SrcAddModuleDesc(nSelect);

	// Browse one module
	::SrcBrowseModule();
}

void CSourceBrowseModulePage::SetInfoList()
{
	// Initial
	m_strName = "";
	m_strTime = "";
	m_strAddr = "";
	m_strPath = "";

	// Get loaded file name
	GetLoadFileName();
	
	// Get loaded file time
	GetLoadFileTime();
	
	// Get loaded file address range
	GetLoadFileAddr();
	
	// Get loaded file full path
	GetLoadFilePath();

	// Add to the Info listbox
	m_lstInfo.ResetContent();
	m_lstInfo.AddString(m_strName);
	m_lstInfo.AddString(m_strTime);
	m_lstInfo.AddString(m_strAddr);
	m_lstInfo.AddString(m_strPath);

	int nLen(0);
	nLen = max(nLen, m_strName.GetLength());
	nLen = max(nLen, m_strTime.GetLength());
	nLen = max(nLen, m_strAddr.GetLength());
	nLen = max(nLen, m_strPath.GetLength());
	m_lstInfo.SetHorizontalExtent(8*(nLen+1));
}

void CSourceBrowseModulePage::GetLoadFileName()
{
	// Get from Loader
	m_strName = ::SrcGetTargetPath();
}

void CSourceBrowseModulePage::GetLoadFileTime()
{
	// Get the loaded file time
	CFileStatus rStatus;
	if ( CFile::GetStatus(m_strName, rStatus) ) {
		int nYear = rStatus.m_mtime.GetYear();
		int nMonth = rStatus.m_mtime.GetMonth();
		int nDay = rStatus.m_mtime.GetDay();
		int nHour = rStatus.m_mtime.GetHour();
		int nMinute = rStatus.m_mtime.GetMinute();
		int nSecond = rStatus.m_mtime.GetSecond();
		m_strTime.Format(::szDate, nMonth, nDay, nYear, nHour, nMinute, nSecond);
	}
}

void CSourceBrowseModulePage::GetLoadFileAddr()
{
	// Get module name
	m_strAddr = "";

	int nSelect = m_lstModule.GetCurSel();
	if ( LB_ERR != nSelect ) {
		CString strModule;
		m_lstModule.GetText(nSelect, strModule);

		// Query from Symbol server
		::SrcGetModuleAddrRange(strModule, m_strAddr);
	}
}

void CSourceBrowseModulePage::GetLoadFilePath()
{
	// Get module name
	m_strPath = "";

	int nSelect = m_lstModule.GetCurSel();
	if ( LB_ERR != nSelect ) {
		CString strModule;
		m_lstModule.GetText(nSelect, strModule);
		// Get module path
		::SrcGetModulePath(strModule, m_strPath);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSourceBrowseModulePage message handlers

void CSourceBrowseModulePage::OnOK()
{
	// DDE
	UpdateData();
	
	// Set module info
	SetModuleInfo();

	// Changed this page
	SetModified(FALSE);
	CancelToClose();
}

BOOL CSourceBrowseModulePage::OnSetActive()
{
	// TODO: Add your message handler code here

	return CPropertyPage::OnSetActive();
}

BOOL CSourceBrowseModulePage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	// Set list font
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	m_lstModule.SetFont(font.FromHandle(hFont));
	m_lstInfo.SetFont(font.FromHandle(hFont));

	// Set module list
	GetModuleInfo();
	
	// Set browse depth
	m_strDepth.Format(::szInt, ::nSrcModuleDepth);

	// DDE
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourceBrowseModulePage::OnSelchangeListModule() 
{
	// TODO: Add your control notification handler code here

	// Update Info list
	UpdateData();
	
	SetInfoList();
}

void CSourceBrowseModulePage::OnDblclkListModule() 
{
	// TODO: Add your control notification handler code here

	// As same as OnOK()
	UpdateData();

	((CSourceSheet*)GetParent())->SendMessage(WM_COMMAND, IDOK);
}
