/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCOPT.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCOPT.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:08   ZJRD
** 1.0c
** 
****************************************************************************/

// srcopt.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcsht.h"
#include "srcgbl.h"

#include "bankinit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static int g_nLastSelectBank = 0;
/////////////////////////////////////////////////////////////////////////////
// CSourceLoadOptionPage dialog

CSourceLoadOptionPage::CSourceLoadOptionPage(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CSourceLoadOptionPage::IDD)
{
	pParent;

	//{{AFX_DATA_INIT(CSourceLoadOptionPage)
	m_bCode = FALSE;
	m_bDemand = FALSE;
	m_bStatus = FALSE;
	m_bSymbol = FALSE;
	m_bWarning = FALSE;
	m_bSystem = FALSE;
	m_nBank = g_nLastSelectBank;
	//}}AFX_DATA_INIT
}


void CSourceLoadOptionPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceLoadOptionPage)
	DDX_Control(pDX, IDC_COMBO_LOADOPTION_BANK, m_comboBank);
	DDX_Control(pDX, IDC_LOADOPTION_SYSTEM, m_btnSystem);
	DDX_Control(pDX, IDC_LOADOPTION_DEMAND, m_btnDemand);
	DDX_Check(pDX, IDC_LOADOPTION_CODE, m_bCode);
	DDX_Check(pDX, IDC_LOADOPTION_DEMAND, m_bDemand);
	DDX_Check(pDX, IDC_LOADOPTION_STATUS, m_bStatus);
	DDX_Check(pDX, IDC_LOADOPTION_SYMBOL, m_bSymbol);
	DDX_Check(pDX, IDC_LOADOPTION_WARNING, m_bWarning);
	DDX_Check(pDX, IDC_LOADOPTION_SYSTEM, m_bSystem);
	DDX_CBIndex(pDX, IDC_COMBO_LOADOPTION_BANK, m_nBank);
	//}}AFX_DATA_MAP              
	
	g_nLastSelectBank = m_nBank;
}

BEGIN_MESSAGE_MAP(CSourceLoadOptionPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSourceLoadOptionPage)
	ON_BN_CLICKED(IDC_LOADOPTION_SYMBOL, OnLoadoptionSymbol)
	ON_BN_CLICKED(IDC_LOADOPTION_CODE, OnLoadoptionCode)
	ON_BN_CLICKED(IDC_LOADOPTION_DEMAND, OnLoadoptionDemand)
	ON_BN_CLICKED(IDC_LOADOPTION_STATUS, OnLoadoptionStatus)
	ON_BN_CLICKED(IDC_LOADOPTION_WARNING, OnLoadoptionWarning)
	ON_BN_CLICKED(IDC_LOADOPTION_SYSTEM, OnLoadoptionSystem)
	ON_CBN_SELCHANGE(IDC_COMBO_LOADOPTION_BANK, OnSelchangeComboLoadoptionBank)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSourceLoadOptionPage message handlers

void CSourceLoadOptionPage::OnOK()
{
	// Set global flag
	UpdateData();

	::nSrcLoadOption = (m_nBank << 8) & 0x0F00;

	if ( m_bCode ) {
		::nSrcLoadOption |= ::LDR_CODE;
	}
	
	if ( m_bSymbol ) {
		::nSrcLoadOption |= ::LDR_SYMBOL;
	}
	
	if ( m_bStatus ) {
		::nSrcLoadOption |= ::LDR_STATUS;
	}
	
	if ( m_bWarning ) {
		::nSrcLoadOption |= ::LDR_WARNING;
	}
	
	if ( m_bDemand ) {
		::nSrcLoadOption |= ::LDR_DEMAND;
	}

	if ( m_bSystem ) {
		::nSrcLoadOption |= ::LDR_SYSTEM;
	}

	// Changed this page
	SetModified(FALSE);
	CancelToClose();
}

BOOL CSourceLoadOptionPage::OnSetActive()
{
	// TODO: Add your message handler code here

	return CPropertyPage::OnSetActive();
}

BOOL CSourceLoadOptionPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	// Get load option
	m_bCode = ::LDR_CODE == (::nSrcLoadOption & ::LDR_CODE) ? TRUE : FALSE;
	m_bSymbol = ::LDR_SYMBOL == (::nSrcLoadOption & ::LDR_SYMBOL) ? TRUE : FALSE;
	m_bStatus = ::LDR_STATUS == (::nSrcLoadOption & ::LDR_STATUS) ? TRUE : FALSE;
	m_bWarning = ::LDR_WARNING == (::nSrcLoadOption & ::LDR_WARNING) ? TRUE : FALSE;
	m_bDemand = ::LDR_DEMAND == (::nSrcLoadOption & ::LDR_DEMAND) ? TRUE : FALSE;
	m_bSystem = ::LDR_SYSTEM == (::nSrcLoadOption & ::LDR_SYSTEM) ? TRUE : FALSE;

    if ( m_bSymbol ) {
		m_btnDemand.EnableWindow(TRUE);
		m_btnDemand.SetCheck(m_bDemand ? 1 : 0);
	}
	else {
		m_btnDemand.SetCheck(0);
		m_btnDemand.EnableWindow(FALSE);
	}

    if ( m_bSymbol ) {
		m_btnSystem.EnableWindow(TRUE);
		m_btnSystem.SetCheck(m_bSystem ? 1 : 0);
	}
	else {
		m_btnSystem.SetCheck(0);
		m_btnSystem.EnableWindow(FALSE);
	}

	m_comboBank.EnableWindow(::DllLdrGetBankNumber() > 0);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourceLoadOptionPage::OnLoadoptionSymbol() 
{
	// TODO: Add your control notification handler code here

	// Grayed Demand if Symbol is not chosen
	UpdateData();

    if ( m_bSymbol ) {
		m_btnDemand.EnableWindow(TRUE);
		m_btnDemand.SetCheck(m_bDemand ? 1 : 0);
	}
	else {
		m_btnDemand.SetCheck(0);
		m_btnDemand.EnableWindow(FALSE);
	}

    if ( m_bSymbol ) {
		m_btnSystem.EnableWindow(TRUE);
		m_btnSystem.SetCheck(m_bSystem ? 1 : 0);
	}
	else {
		m_btnSystem.SetCheck(0);
		m_btnSystem.EnableWindow(FALSE);
	}

	SetModified();
}

void CSourceLoadOptionPage::OnLoadoptionCode()
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}

void CSourceLoadOptionPage::OnLoadoptionDemand()
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}

void CSourceLoadOptionPage::OnLoadoptionStatus()
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}

void CSourceLoadOptionPage::OnLoadoptionWarning()
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}
                           
void CSourceLoadOptionPage::OnLoadoptionSystem() 
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}

void CSourceLoadOptionPage::OnSelchangeComboLoadoptionBank()
{
	// TODO: Add your control notification handler code here
	
	// Enable Apply button
	UpdateData();
	SetModified();
}
