/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCPATH.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCPATH.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:12   ZJRD
** 1.0c
** 
****************************************************************************/

// srcpath.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcsht.h"

#include <direct.h>
#include <ctype.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourcePathPage global variables

static char BASED_CODE szWildcard[] = "*.*";
static char BASED_CODE szUpDir[] = "[..]";
static char BASED_CODE szCancel[] = "Cancel";

/////////////////////////////////////////////////////////////////////////////
// CSourcePathPage

CSourcePathPage::CSourcePathPage(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CSourcePathPage::IDD)
{
	pParent;

	//{{AFX_DATA_INIT(CSourcePathPage)
	//}}AFX_DATA_INIT
}

void CSourcePathPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourcePathPage)
	DDX_Control(pDX, IDC_EDIT_SRCPATH_DIR, m_editDir);
	DDX_Control(pDX, IDC_LIST_SRCPATH_DIR, m_lstDir);
	DDX_Control(pDX, IDC_COMBO_SRCPATH_DRIVER, m_comboDriver);
	DDX_Control(pDX, IDC_LIST_SRCPATH_PATH, m_lstPath);
	DDX_Control(pDX, IDC_BUTTON_SRCPATH_MOVEDOWN, m_btnDown);
	DDX_Control(pDX, IDC_BUTTON_SRCPATH_MOVEUP, m_btnUp);
	DDX_Control(pDX, IDC_BUTTON_SRCPATH_Remove, m_btnRemove);
	DDX_Control(pDX, IDC_BUTTON_SRCPATH_ADD, m_btnAdd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourcePathPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSourcePathPage)
	ON_BN_CLICKED(IDC_BUTTON_SRCPATH_ADD, OnButtonSrcpathAdd)
	ON_BN_CLICKED(IDC_BUTTON_SRCPATH_MOVEUP, OnButtonSrcpathMoveup)
	ON_BN_CLICKED(IDC_BUTTON_SRCPATH_MOVEDOWN, OnButtonSrcpathMovedown)
	ON_CBN_SELCHANGE(IDC_COMBO_SRCPATH_DRIVER, OnSelchangeComboSrcpathDriver)
	ON_BN_CLICKED(IDC_BUTTON_SRCPATH_Remove, OnButtonSrcpathRemove)
	ON_LBN_DBLCLK(IDC_LIST_SRCPATH_DIR, OnDblclkListSrcpathDir)
	ON_LBN_SELCHANGE(IDC_LIST_SRCPATH_PATH, OnSelchangeListSrcpathPath)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourcePathPage common routines

void CSourcePathPage::GetDriver()
{
	// Set driver combobox
	m_comboDriver.ResetContent();
	m_comboDriver.Dir(DDL_DRIVES|DDL_EXCLUSIVE, ::szWildcard);
	CString strDriver;
	strDriver.Format("[-%c-]", char(_getdrive()+'a'-1));
    m_comboDriver.SelectString(-1, strDriver);
}

void CSourcePathPage::GetDir()
{
	// Set directory listbox
	m_lstDir.ResetContent();
	m_lstDir.Dir(DDL_DIRECTORY|DDL_EXCLUSIVE, ::szWildcard);
	if ( m_lstDir.GetCount() >= 1 ) {
		m_lstDir.SetCurSel(0);
	}
}

void CSourcePathPage::ShowDir()
{
	// Get current driver
	CString strDrv;
	m_comboDriver.GetLBText(m_comboDriver.GetCurSel(), strDrv);

	// Get working directory
	char szBuffer[_MAX_PATH+1];
	memset(szBuffer, 0, sizeof(szBuffer));
    _getdcwd(tolower(strDrv[2])-'a'+1, szBuffer, _MAX_PATH);

	m_editDir.SetWindowText(szBuffer);
}

void CSourcePathPage::EnableControl()
{
	// Enable left list-box or right
	BOOL bLeft = m_lstDir.GetCount() >= 1 ? TRUE : FALSE;
	BOOL bRight = m_lstPath.GetCount() >= 1 ? TRUE : FALSE;
	
	// Enable controls
	m_btnAdd.EnableWindow(bLeft);
	m_btnRemove.EnableWindow(bRight);

	if ( bRight ) {
		bRight = 0 == m_lstPath.GetCurSel() ? FALSE : TRUE;
		m_btnUp.EnableWindow(bRight);
		bRight = m_lstPath.GetCount()-1 == m_lstPath.GetCurSel() ? FALSE : TRUE;
		m_btnDown.EnableWindow(bRight);
	}
	else {
		m_btnUp.EnableWindow(bRight);
		m_btnDown.EnableWindow(bRight);
	}
	
	// Set horizontal scroll bar
	int nLen(0);
	for ( int i(0); i < m_lstDir.GetCount(); i++ ) {
		CString strItem;
		m_lstDir.GetText(i, strItem);
		nLen = max(nLen, strItem.GetLength());
	}
	m_lstDir.SetHorizontalExtent(8*(nLen+1));
	
	nLen = 0;
	for ( i = 0; i < m_lstPath.GetCount(); i++ ) {
		CString strItem;
		m_lstPath.GetText(i, strItem);
		nLen = max(nLen, strItem.GetLength());
	}
	m_lstPath.SetHorizontalExtent(8*(nLen+1));
}

void CSourcePathPage::GetPathList()
{
	// Recall from path list
	m_lstPath.ResetContent();
	POSITION pos = ::pSourcePathList->GetHeadPosition();
	while ( pos ) {
		CString strPath = ::pSourcePathList->GetNext(pos);
		m_lstPath.AddString(strPath);
	}

	if ( m_lstPath.GetCurSel() == LB_ERR ) {
		m_lstPath.SetCurSel(0);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSourcePathPage message handlers

void CSourcePathPage::OnOK()
{
	// Set path info
	UpdateData();
	
	// Save to path list
	::pSourcePathList->RemoveAll();

	int nCount = m_lstPath.GetCount();
	if ( LB_ERR != nCount ) {
		for ( int i(0); i < nCount; i++ ) {
			CString strPath;
			m_lstPath.GetText(i, strPath);
			::pSourcePathList->AddTail(strPath);
		}
	}

	// Changed this page
	SetModified(FALSE);
	CancelToClose();
}

BOOL CSourcePathPage::OnSetActive()
{
	// TODO: Add your message handler code here

	return CPropertyPage::OnSetActive();
}

BOOL CSourcePathPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	// Set list font
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	m_lstDir.SetFont(font.FromHandle(hFont));
	m_lstPath.SetFont(font.FromHandle(hFont));

	// Get current driver
	GetDriver();

	// Get working directory
	GetDir();
	
	// Show current selected directory
	ShowDir();

	// Recall from list
	GetPathList();
	
	// Enable controls
	EnableControl();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourcePathPage::OnButtonSrcpathAdd() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();

	// Get current driver
	CString strDrv;
	m_comboDriver.GetLBText(m_comboDriver.GetCurSel(), strDrv);

	// Get working directory
	char szBuffer[_MAX_PATH+1];
	memset(szBuffer, 0, sizeof(szBuffer));
    _getdcwd(tolower(strDrv[2])-'a'+1, szBuffer, _MAX_PATH);

	// Get current selected directory
	CString strDir;
	m_lstDir.GetText(m_lstDir.GetCurSel(), strDir);
	
	// Get cwd
	CString strCwd(szBuffer);
	if ( strDir != ::szUpDir ) {
		// Change to sub-direct
		if ( '\\' != strCwd[strCwd.GetLength()-1] ) {
			strCwd += '\\';
		}
		strCwd += strDir.Mid(1, strDir.GetLength()-2);
	}
	else {
	    // Back to up-direct
	    if ( strCwd.Find('\\') == strCwd.ReverseFind('\\') ) {
	    	strCwd = strCwd.Mid(0, strCwd.ReverseFind('\\')+1);
	    }
	    else {
	    	strCwd = strCwd.Mid(0, strCwd.ReverseFind('\\'));
	    }
	}
	
	// Add cwd to path
	for ( int i(0); i < m_lstPath.GetCount(); i++ ) {
		CString strPath;
		m_lstPath.GetText(i, strPath);
		if ( strPath == strCwd ) {
			// Error
			::SrcDisplayErrorMessage(::errPathSame);
			return;
		}
	}
	m_lstPath.AddString(strCwd);
	if ( m_lstPath.GetCurSel() == LB_ERR ) {
		m_lstPath.SetCurSel(0);
	}
	
	// Enable controls
	EnableControl();
	SetModified();
}

void CSourcePathPage::OnButtonSrcpathRemove() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();
	
	// Remove the selected path
	int nSelect = m_lstPath.GetCurSel();
    m_lstPath.DeleteString(nSelect);
    if ( --nSelect >= 0 ) {
    	m_lstPath.SetCurSel(nSelect);
    }
    else {
    	if ( m_lstPath.GetCount() >= 1 ) {
			m_lstPath.SetCurSel(0);
		}
	}

	// Enable controls
	EnableControl();
	SetModified();
}

void CSourcePathPage::OnButtonSrcpathMoveup() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();

	// Move up selected item
	int nSelect = m_lstPath.GetCurSel();
	CString strPath;
	m_lstPath.GetText(nSelect, strPath);
    m_lstPath.DeleteString(nSelect);
    m_lstPath.InsertString(--nSelect, strPath);
	m_lstPath.SetCurSel(nSelect);

	EnableControl();
	SetModified();
}

void CSourcePathPage::OnButtonSrcpathMovedown() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();

	// Move down selected item
	int nSelect = m_lstPath.GetCurSel();
	CString strPath;
	m_lstPath.GetText(++nSelect, strPath);
    m_lstPath.DeleteString(nSelect);
    m_lstPath.InsertString(nSelect-1, strPath);
	m_lstPath.SetCurSel(nSelect);

	EnableControl();
	SetModified();
}

void CSourcePathPage::OnSelchangeComboSrcpathDriver() 
{
	// TODO: Add your control notification handler code here

	// Get data
	UpdateData();

	// Change current driver
	CString strDrv;
	m_comboDriver.GetLBText(m_comboDriver.GetCurSel(), strDrv);
    _chdrive(tolower(strDrv[2])-'a'+1);

	// Get working directory
	GetDir();

	// Show current selected directory
	ShowDir();

	// Enable controls
	EnableControl();
}

void CSourcePathPage::OnDblclkListSrcpathDir() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();

	// Get current driver
	CString strDrv;
	m_comboDriver.GetLBText(m_comboDriver.GetCurSel(), strDrv);

	// Get working directory
	char szBuffer[_MAX_PATH+1];
	memset(szBuffer, 0, sizeof(szBuffer));
    _getdcwd(tolower(strDrv[2])-'a'+1, szBuffer, _MAX_PATH);

	// Get current selected directory
	CString strDir;
	m_lstDir.GetText(m_lstDir.GetCurSel(), strDir);
	
	// Change cwd
	CString strCwd(szBuffer);
	if ( strDir != ::szUpDir ) {
		// Change to sub-direct
		if ( '\\' != strCwd[strCwd.GetLength()-1] ) {
			strCwd += '\\';
		}
		strCwd += strDir.Mid(1, strDir.GetLength()-2);
	}
	else {
	    // Back to up-direct
	    if ( strCwd.Find('\\') == strCwd.ReverseFind('\\') ) {
	    	strCwd = strCwd.Mid(0, strCwd.ReverseFind('\\')+1);
	    }
	    else {
	    	strCwd = strCwd.Mid(0, strCwd.ReverseFind('\\'));
	    }
	    	
	}
	_chdir(strCwd);
	
	// Get working directory
	GetDir();

	// Show current selected directory
	ShowDir();

	// Enable controls
	EnableControl();
}

void CSourcePathPage::OnSelchangeListSrcpathPath() 
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();

	// Enable controls
	EnableControl();
}
