/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCTIP.CPP   1.0   15 Aug 1997 14:03:40   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCTIP.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:40   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:16   ZJRD
** 1.0c
** 
****************************************************************************/

// srctip.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srctip.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceTipWnd

IMPLEMENT_DYNAMIC(CSourceTipWnd, CWnd)

BOOL CSourceTipWnd::Create()
{
	// Register a WndClass
	CBrush brush(RGB(255,255,128));	// LT_YELLOW
	LPCSTR lpszClassName = AfxRegisterWndClass(CS_HREDRAW, 0, (HBRUSH)brush.GetSafeHandle());
	
	// Create the tip window
	return CWnd::CreateEx(WS_EX_TOPMOST, lpszClassName, "", WS_POPUP|WS_BORDER, 0, 0, 0, 0, NULL, 0);
}

BEGIN_MESSAGE_MAP(CSourceTipWnd, CWnd)
	//{{AFX_MSG_MAP(CSourceTipWnd)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceTipWnd common routines

void CSourceTipWnd::UpdateTip(const CString& strTip /* = "" */, const CPoint pt /* = CPoint(-1,-1) */)
{
	// Update tip window
	if ( strTip.IsEmpty() && pt == CPoint(-1,-1) ) {
		// Hide tip window
		ShowWindow(SW_HIDE);
	}
	else {
		ASSERT(!strTip.IsEmpty());
		ASSERT(pt.x >= 0 && pt.y >= 0);	// Screen co-ordinates

		// Get tip string
		m_strTip = strTip;
	
		// Move tip window
		CRect rect = GetTipRect(pt);
		SetWindowPos(&wndTop, rect.left, rect.top, rect.Width(), rect.Height(), SWP_SHOWWINDOW|SWP_NOACTIVATE);
	
		// Show tip window
		Invalidate();
	}
}

CRect CSourceTipWnd::GetTipRect(const CPoint pt)
{
	// Get tip position rectangle
	int nYCursor = ::GetSystemMetrics(SM_CYCURSOR) - 6;

    CDC* pDC = GetDC();
	pDC->SelectStockObject(ANSI_VAR_FONT);
    CSize sizeText = pDC->GetTextExtent(m_strTip, m_strTip.GetLength());
    ReleaseDC(pDC);

	CRect rect(CPoint(pt.x, pt.y+nYCursor), sizeText+CSize(5,4));

	// Get device boundary
	int xMax = ::GetSystemMetrics(SM_CXFULLSCREEN);
	int yMax = ::GetSystemMetrics(SM_CYFULLSCREEN);

	CPoint ptOffset(0,0);
	if ( rect.right >= xMax ) {
		ptOffset.x = rect.right - xMax + 1;
	}
	
	if ( rect.bottom >= yMax ) {
		ptOffset.y = (nYCursor-4) * 2;
	}
		
	rect = rect - ptOffset;
	
	return rect;
}

/////////////////////////////////////////////////////////////////////////////
// CSourceTipWnd message handlers

void CSourceTipWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here

	// Draw tip string
  	dc.SetBkMode(TRANSPARENT);
	dc.SetTextColor(RGB(0,0,0));
	dc.SelectStockObject(ANSI_VAR_FONT);

	CRect rect;
	GetClientRect(rect);
	dc.DrawText(m_strTip, m_strTip.GetLength(), rect, DT_SINGLELINE|DT_VCENTER|DT_CENTER);
	
	// Do not call CWnd::OnPaint() for painting messages
}
