/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCDAT.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCDAT.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:30   ZJRD
** 1.0c
** 
****************************************************************************/

// srcdat.h : header file
//
#ifndef _SRCDAT_H_
#define _SRCDAT_H_

#include "symblsvr.h"
#include "srcaddr.h"

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CObject;
	class CModuleInfo;
		class CFuncInfo;
		class CLineInfo;

	class CModuleDesc;

/////////////////////////////////////////////////////////////////////////////
// CModuleDesc: module descriptor

class CModuleDesc : public CObject
{
	DECLARE_SERIAL(CModuleDesc)

// Contruction & Destruction
public:
	CModuleDesc() { }
	CModuleDesc(const SYM_DESCRIPTOR dwDesc) : m_dwDesc(dwDesc) { }
	
	virtual ~CModuleDesc() { }

// Attributes
protected:
	SYM_DESCRIPTOR m_dwDesc;
public:
	SYM_DESCRIPTOR GetDesc() const { return m_dwDesc; }
};

/////////////////////////////////////////////////////////////////////////////
// CLineInfo: line info from Symbol server

class CLineInfo : public CObject
{
	DECLARE_SERIAL(CLineInfo)

// Contruction & Destruction
public:
	CLineInfo() { }
	CLineInfo(const LINENUM_DESCRIPTOR dwDesc, const int nLine, const CSourceAddr& AddrStart, const CSourceAddr& AddrEnd)
		: m_dwDesc(dwDesc), m_nLine(nLine), m_AddrStart(AddrStart), m_AddrEnd(AddrEnd) { }

	virtual ~CLineInfo() { }

// Attributes
protected:
	LINENUM_DESCRIPTOR m_dwDesc;
public:
	LINENUM_DESCRIPTOR GetDesc() const { return m_dwDesc; }

protected:
	int m_nLine;
public:
	int GetLine() const { return m_nLine; }

protected:
	CSourceAddr m_AddrStart;
public:
	CSourceAddr GetStart() const { return m_AddrStart; }

protected:
	CSourceAddr m_AddrEnd;
public:
	CSourceAddr GetEnd() const { return m_AddrEnd; }
};

/////////////////////////////////////////////////////////////////////////////
// CFuncInfo: function info from Symbol server

class CFuncInfo : public CObject
{
	DECLARE_SERIAL(CFuncInfo)

// Contruction & Destruction
public:
	CFuncInfo()	{ }

	CFuncInfo(const SYM_DESCRIPTOR dwDesc, const CString& strName, const CSourceAddr& AddrStart, const CSourceAddr& AddrEnd)
		: m_dwDesc(dwDesc), m_strName(strName), m_AddrStart(AddrStart), m_AddrEnd(AddrEnd) { }

	virtual ~CFuncInfo() { }

// Attributes
protected:
	SYM_DESCRIPTOR m_dwDesc;
public:
	SYM_DESCRIPTOR GetDesc() const { return m_dwDesc; }

protected:
	CString m_strName;
public:
	const CString& GetName() const { return m_strName; }

protected:
	CSourceAddr m_AddrStart;
public:
	CSourceAddr GetStart() const { return m_AddrStart; }

protected:
	CSourceAddr m_AddrEnd;
public:
	CSourceAddr GetEnd() const { return m_AddrEnd; }
};

/////////////////////////////////////////////////////////////////////////////
// CModuleInfo: module info from Symbol server

class CModuleInfo : public CObject
{
	DECLARE_SERIAL(CModuleInfo)

// Contruction & Destruction
public:
	CModuleInfo()
	{
		m_pFuncList = new CObList;
		m_pLineList = new CObList;
	}

	CModuleInfo(const SYM_DESCRIPTOR dwDesc, const CString& strName, const CSourceAddr& AddrStart, const CSourceAddr& AddrEnd)
		: m_dwDesc(dwDesc), m_strName(strName), m_AddrStart(AddrStart), m_AddrEnd(AddrEnd)
	{
		m_pFuncList = new CObList;
		m_pLineList = new CObList;
	}

	virtual ~CModuleInfo()
	{
		POSITION pos = m_pFuncList->GetHeadPosition();
		while ( pos ) {
			CFuncInfo* pObj = (CFuncInfo*)m_pFuncList->GetNext(pos);
			delete pObj;
		}
		m_pFuncList->RemoveAll();
		delete m_pFuncList;

		pos = m_pLineList->GetHeadPosition();
		while ( pos ) {
			CLineInfo* pObj = (CLineInfo*)m_pLineList->GetNext(pos);
			delete pObj;
		}
		m_pLineList->RemoveAll();
		delete m_pLineList;
	}

// Attributes
protected:
	SYM_DESCRIPTOR m_dwDesc;
public:
	SYM_DESCRIPTOR GetDesc() const { return m_dwDesc; }

protected:
	CString m_strName;
public:
	const CString& GetName() const { return m_strName; }

protected:
	CSourceAddr m_AddrStart;
public:
	CSourceAddr GetStart() const { return m_AddrStart; }

protected:
	CSourceAddr m_AddrEnd;
public:
	CSourceAddr GetEnd() const { return m_AddrEnd; }
	
protected:
	CObList* m_pFuncList;	// save current functions' info
public:
	CObList* GetFuncList() const { return m_pFuncList; }

protected:
	CObList* m_pLineList;	// save current lines' info
public:
	CObList* GetLineList() const { return m_pLineList; }
};

#endif
