/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCEXP.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCEXP.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:30   ZJRD
** 1.0c
** 
****************************************************************************/

// srcexp.h : header file
//
#ifndef _SRCEXP_H_
#define _SRCEXP_H_

#include "symblsvr.h"

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CSourceAddr;

/////////////////////////////////////////////////////////////////////////////
// Exported function

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

void WINAPI InitDLL_SourceWindow();
void WINAPI SrcRegisterWindow();

BOOL WINAPI SrcInitSourceEnv();
void WINAPI SrcFreeSourceEnv();

void WINAPI SrcReadProfile();
void WINAPI SrcWriteProfile();

void WINAPI SrcFilterMessage(MSG* pMsg);

CMDIChildWnd* WINAPI SrcGetSourceWindow();
CMDIChildWnd* WINAPI SrcGetBrowseWindow();

BOOL WINAPI SrcIsSourceWindowOpened();
BOOL WINAPI SrcIsBrowseWindowOpened();

void WINAPI SrcOpenSourceWindow();
void WINAPI SrcCloseSourceWindow();
void WINAPI SrcUpdateSourceWindow(int nMode, const BOOL bOpenFirst = FALSE);

void WINAPI SrcOpenBrowseWindow();
void WINAPI SrcCloseBrowseWindow();
void WINAPI SrcUpdateBrowseWindow(int nMode, const BOOL bOpenFirst = FALSE);

BOOL WINAPI SrcIsLoadedSymbol();
BOOL WINAPI SrcIsLoadAbort();
void WINAPI SrcLoadTargetFile(const CString& strFile);
void WINAPI SrcLoadCmd(BOOL& bLoadOK, CString& strFile);
void WINAPI SrcBrowseModule();
BOOL WINAPI SrcIsInSourceLine(const CSourceAddr& Addr, int& nLine, int& nStmt, SYM_DESCRIPTOR& dwModuleDesc);

BOOL WINAPI SrcAddrToText(const CSourceAddr& Addr, CString& strAddr);
BOOL WINAPI SrcTextToAddr(const CString& strAddr, CSourceAddr& Addr);
BOOL WINAPI SrcAddrToSymbol(const CSourceAddr& Addr, CString& strSymbol);

BOOL WINAPI SrcGetPC(CSourceAddr& AddrPC);
BOOL WINAPI SrcSetPC(const CSourceAddr& AddrPC);

int WINAPI SrcGetMode();
void WINAPI SrcSetMode(const int nMode);

void WINAPI SrcDisplayErrorMessage(const int nErrorID, const BOOL bInShell = FALSE);

void WINAPI SrcOnFileLoad();
void WINAPI SrcOnGroup(const int nEntry);
void WINAPI SrcOnRunJump();
CStringList* WINAPI SrcGetSearchList();
void WINAPI SrcCursorLink(const DWORD dwAddr, const BYTE bType);
void WINAPI SrcCursorLinkOff();
void WINAPI SrcInspectSource(const DWORD dwAddr, const BYTE bType);

BOOL WINAPI SrcIsSymbolic();

#ifdef __cplusplus
}
#endif	// __cplusplus

#endif
/////////////////////////////////////////////////////////////////////////////
