/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCTEXT.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCTEXT.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:06   ZJRD
** 1.0c
** 
****************************************************************************/

// srctext.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srctext.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextView

IMPLEMENT_DYNAMIC(CTextView, CView)

CTextView::CTextView()
	: m_totalDev(CSize(0,0))
{
}

CTextView::~CTextView()
{
}


BEGIN_MESSAGE_MAP(CTextView, CView)
	//{{AFX_MSG_MAP(CTextView)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTextView drawing

void CTextView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo)
{
	ASSERT_VALID(pDC);

	// Set mappint mode
	pDC->SetMapMode(MM_TEXT);

	CView::OnPrepareDC(pDC, pInfo);     // For default Printing behavior
}


/////////////////////////////////////////////////////////////////////////////
// CTextView diagnostics

#ifdef _DEBUG
void CTextView::AssertValid() const
{
	CView::AssertValid();
}

void CTextView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// Set mode and scaling/scrolling sizes

void CTextView::SetScrollSizes(const CSize& sizeTotal, const CSize& sizePage, const CSize& sizeLine)
{
	ASSERT(sizeTotal.cx > 0 && sizeTotal.cy > 0);

	m_totalLog = sizeTotal;
	m_totalDev = m_totalLog;
	m_pageDev = sizePage;
	m_lineDev = sizeLine;

	// window has been created, invalidate now
	if ( m_hWnd && m_totalDev.cx > 1 && m_totalDev.cy > 1 ) {
		UpdateBars();
	}
}


/////////////////////////////////////////////////////////////////////////////
// Getting information

void CTextView::UpdateBars()
{
	// update the horizontal to reflect reality
	// NOTE: turning on/off the scrollbars will cause 'OnSize' callbacks
	ASSERT(m_totalDev.cx >= 0 && m_totalDev.cy >= 0);

	// Get client rect
	CRect rect;
	GetClientRect(rect);
	BOOL bHorz(FALSE), bVert(FALSE);

	if ( m_totalDev.cx > rect.Width()/m_sizeFont.cx ) {
		bHorz = TRUE;
	}
	if ( m_totalDev.cy > rect.Height()/m_sizeFont.cy ) {
		bVert = TRUE;
	}
	
	// Enable/disable scroll bar
	if ( bHorz ) {
		int nHorz = GetScrollPos(SB_HORZ);
		EnableScrollBarCtrl(SB_HORZ, TRUE);
		SetScrollPos(SB_HORZ, nHorz, FALSE);
		SetScrollRange(SB_HORZ, 0, m_totalDev.cx, TRUE);
	}
	else {
		SetScrollPos(SB_HORZ, 0, FALSE);
		EnableScrollBarCtrl(SB_HORZ, FALSE);
	}

	if ( bVert ) {
		int nVert = GetScrollPos(SB_VERT);
		EnableScrollBarCtrl(SB_VERT, TRUE);
		SetScrollPos(SB_VERT, nVert, FALSE);
		SetScrollRange(SB_VERT, 0, m_totalDev.cy, TRUE);
	}
	else {
		SetScrollPos(SB_VERT, 0, FALSE);
		EnableScrollBarCtrl(SB_VERT, FALSE);
	}

	// first scroll the window as needed
//	ScrollToDevicePosition(ptMove); // will set the scroll bar positions too
}

BOOL CTextView::OnHScrollBy(UINT nSBCode, UINT nPos)
{
	// Get the current bar position
	int xOrig = GetScrollPos(SB_HORZ);
	int xMin, xMax;
	GetScrollRange(SB_HORZ, &xMin, &xMax);
	ASSERT(0 == xMin);

	// Get the current offset
	int x(xOrig);
	switch ( nSBCode ) {
	case SB_LEFT:
		x = xMin;
		break;
	case SB_RIGHT:
		x = xMax;
		break;
	case SB_LINELEFT:
		x -= m_lineDev.cx;
		break;
	case SB_LINERIGHT:
		x += m_lineDev.cx;
		break;
	case SB_PAGELEFT:
		x -= m_pageDev.cx;
		break;
	case SB_PAGERIGHT:
		x += m_pageDev.cx;
		break;
	case SB_THUMBTRACK:
		x = nPos;
		break;
	default:
		return FALSE;
	}

	// adjust current x position
	if ( x < 0 ) {
		x = xMin;
	}
	else if ( x > xMax ) {
		x = xMax;
	}

	// did anything change?
	if ( x == xOrig ) {
		return FALSE;
	}

	// do scroll and update scroll positions
	SetScrollPos(SB_HORZ, x);

	return TRUE;
}

BOOL CTextView::OnVScrollBy(UINT nSBCode, UINT nPos)
{
	// Get the current bar position
	int yOrig = GetScrollPos(SB_VERT);
	int yMin, yMax;
	GetScrollRange(SB_VERT, &yMin, &yMax);
	ASSERT(0 == yMin);

	// Get the current offset
	int y(yOrig);
	switch ( nSBCode ) {
	case SB_TOP:
		y = yMin;
		break;
	case SB_BOTTOM:
		y = yMax;
		break;
	case SB_LINEUP:
		y -= m_lineDev.cy;
		break;
	case SB_LINEDOWN:
		y += m_lineDev.cy;
		break;
	case SB_PAGEUP:
		y -= m_pageDev.cy;
		break;
	case SB_PAGEDOWN:
		y += m_pageDev.cy;
		break;
	case SB_THUMBTRACK:
		y = nPos;
		break;
	default:
		return FALSE;
	}

	// adjust current x position
	if ( y < 0 ) {
		y = yMin;
	}
	else if ( y > yMax ) {
		y = yMax;
	}

	// did anything change?
	if ( y == yOrig ) {
		return FALSE;
	}

	// do scroll and update scroll positions
	SetScrollPos(SB_VERT, y);

	return TRUE;

//	CRect rect;
//	GetClientRect(rect);
//	if ( yMax - y < rect.Height() / m_sizeFont.cy ) {
//		SetScrollPos(SB_VERT, yMax);
//		return FALSE;
//	}
//	else {
//		SetScrollPos(SB_VERT, y);
//		return TRUE;
//	}
}


/////////////////////////////////////////////////////////////////////////////
// CTextView message handlers
 
void CTextView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
	// UpdateBars() handles locking out recursion
	UpdateBars();
}
