/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCTEXT.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCTEXT.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:22   ZJRD
** 1.0c
** 
****************************************************************************/

// srctext.h : header file
//
#ifndef _SRCTEXT_H_
#define _SRCTEXT_H_

/////////////////////////////////////////////////////////////////////////////
// CTextView view

class CTextView : public CView
{
protected:
	CTextView();			// protected constructor used by dynamic creation
	DECLARE_DYNAMIC(CTextView)

// Attributes
public:
	// Set current font size
	void SetFontSize(const CSize& sizeFont)	{ m_sizeFont = sizeFont; }

	// In logical units
	void SetScrollSizes(const CSize& sizeTotal, const CSize& sizePage, const CSize& sizeLine);

// Operations

// Implementation
protected:
	CSize m_totalLog;	// total size in logical units (no rounding)
	CSize m_totalDev;   // total size in device units
	CSize m_pageDev;    // per page scroll size in device units
	CSize m_lineDev;    // per line scroll size in device units
	CSize m_sizeFont;	// current view font size

	void UpdateBars();		// adjust scrollbars etc

// Overrides
protected:
	virtual BOOL OnHScrollBy(UINT nSBCode, UINT nPos);
	virtual BOOL OnVScrollBy(UINT nSBCode, UINT nPos);

protected:
	virtual void OnDraw(CDC* pDC) = 0;      // pass on pure virtual
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

// Implementation
protected:
	virtual ~CTextView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CTextView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
