/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCIMP.H__   1.0   15 Aug 1997 14:03:44   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCIMP.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:44   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:30   ZJRD
** 1.0c
** 
****************************************************************************/

// srcimp.h : header file
//
#ifndef _SRCIMP_H_
#define _SRCIMP_H_

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CSourceAddr;

/////////////////////////////////////////////////////////////////////////////
// Global variable

// Source property pages' name
enum {
	pageLoadOption,
	pageExtName,
	pagePath,
	pageModule,
	pageBp,
	pageInfo
};

// Browsing Source window mode
enum {
	srcOpen = 0,	// PC => Mode
	srcUpdate,		// !PC & !Mode
	srcReset,		// PC & !Mode
	srcBrowse,		// !PC & Mode = src
	srcBp,			// Mark BP
	brwOpen,		// PC => Mode
	brwBrowse,		// !PC & Mode = src
	brwUpdate,		// !PC & !Mode
	brwLink,			// Cursor link
	srcStep		// step or go
};

// Source window mode
enum { modAsm = 0, modMix, modSrc };

// Error ID
enum { 
	errNo = 0,		// No error

	errMemory,		// Insufficient memory.
	errFile, 		// File access error.
	errAddr,		// Invalid address.
	errInput,		// Invalid input.

	errExtTooLong,	// Extension name length is longer than 3 characters.
	errExtEmpty,	// Extension name is empty.
	errExtExist,	// Exist the same extension name.
	errExtChar,		// Illegal character in extension name.

	errPathSame,	// Exist the same path.

	errBpAddr,		// Breakpoint is at an invalid address.
	errBpSymbol,	// Breakpoint is at an invalid symbol.
	errBpInput,		// Breakpoint address is invalid.
	errBpEmpty,		// Address is empty.
	errBpExist,		// Already exist a breakpoint at this address.
	errBpFile,		// Cannot open Breakpoint file.
	errBpFormat,	// Breakpoint file format is invalid.
	errBpNoExist,	// There's no breakpoints at this address.
	errBpNo,		// There's not any breakpoints.
	errBpSet,		// Breakpoint can not be set to HW.
	errBpGet,		// Breakpoint can not be gotton from HW.
	errBpClr,		// Breakpoint can not be cleared to HW.

	errLoad,		// Load file error.
	
	errStep,		// HW can not Step.
	errStepOver,	// HW can not Step Over.
	errCpuStatus, 	// Can not get CPU status.
	errBrowseFrom,	// Browse from invalid address.
	errJumpTo,		// Jump to invalid address.
	errGetPC,		// Can not get PC from HW.
	errSetPC,		// Can not set PC to HW.
	errGo,			// HW can not go.
	errEPRun,		// EP is running.

	errMax			// Max error ID
};

/////////////////////////////////////////////////////////////////////////////
// Imported function

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

BOOL WINAPI SrcGetAsmCodeAddr(const CSourceAddr& AddrStart, const CSourceAddr& AddrEnd, CStringList* &pCodeList, CStringList* &pInstList, CStringList* &pSymList, CStringList* &pAddrList);
BOOL WINAPI SrcGetAsmCodeLine(const CSourceAddr& AddrStart, const int nLine, CStringList* &pCodeList, CStringList* &pInstList, CStringList* &pSymList, CStringList* &pAddrList);
BOOL WINAPI SrcGetStartAddr(const CSourceAddr& AddrBase, CSourceAddr& AddrStart, const int nUpLine /* = 1 */);

void WINAPI SrcPrintSetup();

LPCSTR WINAPI SrcGetBarToken();
void WINAPI SrcSetBarToken(const CString& strWhat);
void WINAPI SrcSetBarCombo();
HWND WINAPI SrcGetSearchComboHwnd();

void WINAPI SrcShowLine(const CString& strLine);

void WINAPI SrcAddVariable(const CString& strToken);

void WINAPI SrcAddToRecentFileList(const CString& strPath);

#ifdef __cplusplus
}
#endif	// __cplusplus

#endif
/////////////////////////////////////////////////////////////////////////////
