
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
            
/****************************************************************************
**
**  Name:  symadd.h
**
**  Description:
**     Prototypes for the functions to add to the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMADD.H__   1.7.1.0.1.0   11 Nov 1996 12:57:08   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMADD_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symmanag.h"
#include "symmgr.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
//------------------------------------------------------------------------
// Symbol Server INI setting definitions
#define SAPP_NAME "SymbolInfo"
#define SAPP_LABEL "ConvertLabelsToRanges"

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/***************************************************************************
** InitSymTable
**
** Description: Initializes the symbol table.
**
** Input Parameters:
**    none:
** Output Parameters:
**    none:
** Errors:
**    ER_OUT_OF_MEMORY:
** NOTE: no BaseSymbol is created on initialization.  This means that any
**    loader must first create a base (and its index) before using it.
***************************************************************************/
RETCODE InitSymTable(VOID);

//--------------------------------------------------------------------------
// SymAddGetModuleName
//--------------------------------------------------------------------------
RETCODE SymAddGetModuleName(SYM_DESCRIPTOR module, LPSTR modName);

/****************************************************************************
**
**  SymInitSymServer
**
**  Description:
**     Initializes the symbol server
**     
**  Parameters:
**     input:
**        cliHandle:  the handle of the cli server
**        dllHandle:  the handle of the symbol server
**     output:
**        none:
**        (returns): error code
**
*****************************************************************************/
RETCODE SymInitSymServer(HANDLE cliHandle,HANDLE dllHandle);


#define _SYMADD_
#endif
/******************************** E O F ***********************************/
