
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symcli.h
**
**  Description:
**     Prototype for the symbol server CLI parse routines
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMCLI.H__   1.7.1.0.1.0   11 Nov 1996 12:58:08   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symwind.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


//--------------------------------------------------------------------------
// SendMessageToCli
//--------------------------------------------------------------------------
RETCODE SendMessageToCli(U8 FAR *msgPtr);


/***************************************************************************
** RemoveSymbols
**
** Description: Removes all loaded symbols and reinitializes the symbol
**              table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT RemoveSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** DisplaySymbols
**
** Description: Prints all symbols in the symbol table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT DisplaySymbols(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// Count
//
// Displays the number of symbols in the various tables
//--------------------------------------------------------------------------
RETCODE EXPORT
Count(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// NameOf
//
// Converts an address into a symbol and displays it
//--------------------------------------------------------------------------
RETCODE EXPORT
NameOf(LPSTR cmdString);


//--------------------------------------------------------------------------
// AddressOf
//
// Converts a symbol path and name into an address; uses #mod#func#var
//   naming convention
//--------------------------------------------------------------------------
RETCODE EXPORT
AddressOf(LPSTR cmdString);

//--------------------------------------------------------------------------
// SymbolOpenFile
//
// Sets symbol output to go to <file>.
// Only one parameter is allowed - the path and filename
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolOpenFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolCloseFile
//
// Closes file opened by SymbolOpenFile
// No parameters are allowed.
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolCloseFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// DisplayTypes
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
DisplayTypes(LPSTR cmdString, U32 argc, U32 argv[]);

/****************************************************************************
**
**  TskCheckAbort
**
**  Description:
**    Acts as replacement for Windows API function GetAsyncKeyState(VK_ESCAPE)
**    As such it should match its behavior and return type.
**    This new version only calls when the app is active, as
**    defined by the "appIsActive" flag.  This is a crude
**    indication of focus.
**
**  Parameters:
**     aborted   flag: FALSE if esc not pressed, TRUE if pressed.
**
*****************************************************************************/

RETCODE EXPORT TskCheckAbort(BOOLEAN FAR *abort);

#ifdef __cplusplus
}
#endif

#define _SYMCLI_
#endif
/******************************** E O F ***********************************/
