
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symclipr.h
**
**  Description:
**     Prototypes for the routines that print the symbol table to the cli.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMCLIPR.H__   1.7.1.0.1.0   11 Nov 1996 12:58:56   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLIPR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "symwind.h"
#include "symmanag.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMCLIPR_ADDR_TEXT_WIDTH 40

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

RETCODE WINAPI
SymPrintSymbol(TABLE_OFFSET symbol, 
               SYM_DISPLAY_TYPE displayType,
               U16 indentLevel);

RETCODE WINAPI
SymPrintSymbols(SYM_DISPLAY_TYPE displayType);

RETCODE SymPrintLines(SYM_DESCRIPTOR modDesc);

//--------------------------------------------------------------------------
// SymConvSymAddrToText
//
// Output format:
//    Fixed addresses:
//       Displays fixed address as xxx-yyy where xxx is the start address and
//       yyy is the end address; then displays the range as [rrr].
//       Start and end addresses are is hex, the range is in decimal
//    Stack-based addresses:
//       Displays as a single signed decimal number followed by [sss] size.
//
// Input Parameter:
//    symbol: symbol being printed
//
// Output Parameter:
//    str: alloc'ed by caller using size SYMCLIPR_ADDR_TEXT_WIDTH
//--------------------------------------------------------------------------
RETCODE SymConvSymAddrToText(SYM_DESCRIPTOR symbol, LPSTR str);

#ifdef __cplusplus
}
#endif

RETCODE SymPrintBases(SYM_DISPLAY_TYPE displayType);

#define _SYMCLIPR_
#endif
/******************************** E O F ***********************************/
