
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMTOKEN.CPP
**
**  Description:
**      member function of class CSymToken
**
**  Status:  CODED
**
**    Rev 1.0   5 March 1996 15:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <memory.h>
#include <string.h>

#ifdef _LINK_WITH_ABI_
//#include "abibase.h"  
#include "abiextfn.h"
#else
typedef int STATUS;
typedef unsigned char FLAG;
typedef struct {
    FLAG addrType;
    unsigned long  addr;
} ADDR;

/* All ABI routines Return codes */
typedef enum {
        ICE_OK              = 0x0,
        ICE_FAIL_STEP,                  //target cannot step
        ICE_FAIL_MEM_WRITE,             //memory write failure
        ICE_FAIL_MAP_INCLUDE,           //map status not included
        ICE_FAIL_MAP_BOUNDARY,          //map address boundary error
        ICE_NOT_FOUND       = 0x5,
        ICE_FOUND,
        ICE_TIME_OUT        = 0x7,
        ICE_PARA_ERROR      = 0x8,
        ICE_EP_RUNNING      = 0x10,
        ICE_TRACE_RUNNING   = 0x11,
        ICE_TRACE_READ_OVER = 0x12,
        ICE_COMMAND_INVALID = 0x13,

        ICE_FLASH_SW_ERROR  = 0x40,
        ICE_FLASH_EC_ERROR  = 0x41,
        ICE_FLASH_PRG_ERROR = 0x42,
        ICE_FLASH_REC_ERROR = 0x43,
		ICE_NO_RESPONSE		= 0xff
} RET_CODE;

#endif

#include "symblsvr.h"
#include "symtoken.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern int CheckIsValidVar(char *str,SYM_DESCRIPTOR &desc,
	TYPE_INDEX &typeIndex,BOOLEAN &isGlobal,ADDRESS_TYPE& addr);
//extern STATUS AbiGetMemN(ADDR addr1, ADDR addr2,char* pchBuff);
extern int SrcIsStatement(void);
extern int SrcIsIEEE(void);
extern void ShowLine(char *);
//extern int GetUserVarValue(char *str,short& value);
//extern int SetUserVarValue(char *str,short value);

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
int GetBitValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);
int GetSValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);
int GetEnumValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);


                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          *
*  DeleteTokenList  --  delete token list link                             *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymToken::DeleteTokenList(void)
{
    SYM_TOKEN_NODE *pTemp;
    
    m_lastTokenType = SYMTOKEN_NULL;
    while( m_pTokenList ) {
        pTemp = m_pTokenList;
        m_pTokenList = m_pTokenList->next;
        delete pTemp;
    }       
    m_pTokenList = 0;
    m_pLastToken = 0;
    m_nCurrentToken = 0;
    m_pCurToken = 0;
    
    return;
}

/***************************************************************************
*                                                                          
*  ResizePosArray  --  resize m_pTokenPos array 
*  parameter :                                                             
*       nMax -- require array size                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::ResizePosArray(int nMax)
{
    if ( nMax <= 0 ) {
        m_nErrNo = 3;
        return FAILURE;
    }    
    if ( nMax <= m_nMaxTokenNum ) return GOOD;
    int *pTemp;
    
    pTemp = new int[ nMax+5 ];
    if ( pTemp == 0 ) {
        m_nErrNo = 1;
        return FAILURE;
    }
    memset( pTemp , 0 , sizeof(int)*(nMax+5) );
//    memset( pTemp , 0 , sizeof(int[nMax+5]) );
    if ( m_pTokenPos ) {
        memcpy( pTemp , m_pTokenPos , m_nCurTokenNum*sizeof(int));
        delete m_pTokenPos;
        m_pTokenPos = 0;
    }
    m_pTokenPos = pTemp;
    m_nMaxTokenNum = nMax+5;
    return GOOD;
}

/***************************************************************************
*                                                                          
*  AddOneTokenToList  --  Add one token node to node list 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::AddOneTokenToList(SYM_TOKEN_NODE *pNode)
{
    if ( pNode == 0 ) {
        m_nErrNo = 3;
        return FAILURE;
    }
    if ( m_pLastToken ) {
        m_pLastToken->next = pNode; 
        pNode->prev = m_pLastToken;
        m_pLastToken = pNode;
        m_nCurrentToken = m_nCurTokenNum+1;
        m_pCurToken = pNode;
    }
    else {
        m_pTokenList = pNode;
        m_pLastToken = pNode;
        m_nCurrentToken = m_nCurTokenNum+1;
        m_pCurToken = pNode;
    }                   
    m_nCurTokenNum++;
    return GOOD;
}

/***************************************************************************
*                                                                          
*  GetOneTokenFromList  --  Get one token node from node list 
*  parameter :                                                             
*       num -- require token number ( from 1 )                                         
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetOneTokenFromList(int num, SYM_TOKEN_NODE *& pNode)
{
//    if ( num <= 0 ) return FAILURE;
//    if ( num > m_nCurTokenNum ) return FAILURE;
    if ( num <= 0 || num > m_nCurTokenNum ) {
        m_nErrNo = 3;
        return FAILURE;
    }
    if ( m_nCurTokenNum == 0 ) {
        m_nErrNo = 4;
        return FAILURE;
    }
    if ( m_nCurrentToken == 0 ) {
        if ( num >= ( m_nCurTokenNum/2 ) ) {
            m_nCurrentToken = m_nCurTokenNum;
            m_pCurToken = m_pLastToken;
        }
        else {
            m_nCurrentToken = 1;
            m_pCurToken = m_pTokenList;
        }                             
    }    
    if ( num >= m_nCurrentToken ) {
        while( m_pCurToken ) {
            if ( num == m_nCurrentToken ) break;
            m_nCurrentToken++;
            m_pCurToken = m_pCurToken->next;
        }    
    }
    else {
        while( m_pCurToken ) {
            if ( num == m_nCurrentToken ) break;
            m_nCurrentToken--;
            m_pCurToken = m_pCurToken->prev;
        }    
    }            
    pNode = m_pCurToken; 
    if ( pNode == 0 ) {
        m_nErrNo = 5;
        return FAILURE;
    }    

    return GOOD;
}

/***************************************************************************
*                                                                          
*  GetNextToken  --  Get one token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetNextToken(SYM_TOKEN_NODE *pNode)
{   
    int nFlag;
    char c;  //  current char in expression.
    
    nFlag = 0 ; // 0 -- unknown;
                // 1 -- number
                // 2 -- float
                // 3 -- symbol
                // 4 -- operator
                
    if ( pNode == 0 ) {
        m_nErrNo = 3;
        return FAILURE;
    }    
    if ( m_nCurTokenNum ) {
        m_lastTokenType = m_pLastToken->symType;
    }
    if ( m_nCurTokenNum >= m_nMaxTokenNum ) {
        if ( GOOD != ResizePosArray(m_nCurTokenNum+10) ) {
            return FAILURE;
        }
    }

    m_pTokenPos[ m_nCurTokenNum ] = m_nCurPos;

    SkipLeftSpace(m_nCurPos, m_nCurPos);
    
    if ( m_nCurPos >= m_nLen ) {
        pNode->symType = SYMTOKEN_NULL;
        return GOOD;
    }

	if ( SYMTOKEN_NUM == m_lastTokenType ||
		SYMTOKEN_FLOAT == m_lastTokenType ||
    	SYMTOKEN_SYMBOL == m_lastTokenType || 
    	SYMTOKEN_OPERATOR == m_lastTokenType || 
   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ||
   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ) {
        return GetOperator( pNode );          
    }    

    c = m_strCmd[ m_nCurPos ];            
    if ( c >= '0' && c <= '9' ) {
        nFlag = 1;
    }
//    else if ( c == 'e' || c == 'E' ) {
//        nFlag = 2;
//    }
    else if ( c == '.' ) {
        nFlag = 2;
    }
    else if ( c == '#' ) {
        nFlag = 3;
    }
    else if ( c == '$' ) {
        nFlag = 3;
    }
//    else if ( c == '_' || c == '?' ) {
    else if ( c == '_' ) {
        nFlag = 3;
    }
    else if ( c >= 'a' && c <= 'z' ) {
        nFlag = 3;
    }
    else if ( c >= 'A' && c <= 'Z' ) {
        nFlag = 3;
    }
    else if ( c == '+' || c == '-' ) {
		if ( SYMTOKEN_OPERATOR1 == m_lastTokenType ) {
			m_nErrNo = 8;
			return FAILURE;
		}			  

        if ( m_nCurPos+1 < m_nLen ) {
            char c1;

            c1 = m_strCmd[ m_nCurPos+1 ];
            if ( c1 >= '0' && c1 <= '9' ) {
                nFlag = 1;
            }
            else if ( c1 == '.' ) {
                nFlag = 2;
            }
            else {
                nFlag = 4;
            }
        }
        else {
            nFlag = 4;
        }
    }
    else {
        nFlag = 4;
    }
    
    if ( nFlag == 1 ) {
        return GetNumber( pNode );
    }
    else if ( nFlag == 2 ) {
        return GetFloat( pNode );
    }                      
    else if ( nFlag == 3 ) {
        return GetSymbol( pNode );
    }                      
    else if ( nFlag == 4 ) {
        return GetOperator( pNode );
    }                      
    
    return GOOD;
}

/***************************************************************************
*                                                                          
*  GetNumber  --  Get one Number token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetNumber(SYM_TOKEN_NODE *pNode)
{
    char c;  //  current char in expression.
    char *p , *pContent;
    long l;
    int nFlag;     
    int lFlag; // long Flag
    int uFlag; // unsigned Flag
    int hFlag; // hexdecimal flag 
    int nPos;
    
    nFlag = 0;  // 0 -- unknown
                // 1 -- number
                // 2 -- float
    lFlag = 0;
    uFlag = 0;
    hFlag = 0;

    nPos = m_nCurPos;                
    p = &m_strCmd[m_nCurPos];

    if ( *p == '+' || *p == '-' ) {
        p++;
        nPos++;
    }
    if ( *p == '.' ) {
        return GetFloat( pNode );
    }
    if ( *p == '0' ) {
        c = p[1];
        if ( c == 'x' || c == 'X' ) {
            hFlag = 1;
            p++;
            p++;
            nPos += 2;
        }
    }
    while( 1 ) {
        c = *p ;
        if ( hFlag ) {
            if ( (c>='0'&&c<='9')||(c>='A'&&c<='F')
            	||(c>='a')&&(c<='f') ) {
                p++;
                nPos++;
            }
            else {
                break;
            }
        }
        else {
            if ( c>='0'&&c<='9' ) {
                p++;
                nPos++;
            }
            else {
                break;
            }
        }
    }               
    
    if ( *p == '.' || *p == 'e' || *p == 'E' ) {
        if ( hFlag ) {
            m_nErrNo = 6;
            return FAILURE;
        }
        else {
            return GetFloat( pNode );
        }
    }            

	if ( nPos == m_nCurPos ) {
        m_nErrNo = 4;
        return FAILURE;
    }
    pContent = new char [ nPos - m_nCurPos + 1 ];
    if ( pContent == 0 ) {
        m_nErrNo = 1;
        return FAILURE;
    }
    memcpy( pContent , &m_strCmd[m_nCurPos],nPos - m_nCurPos );
    pContent[nPos - m_nCurPos] = '\0';     
    if ( *p == 'u' || *p == 'U' ) {
        p++; 
        nPos++;
        uFlag = 1;
        if ( *p == 'l' || *p == 'L' ) {
            p++;
            nPos++;
            lFlag = 1;
        }
    }
    else if ( *p == 'l' || *p == 'L' ) {
        p++; 
        nPos++;
        lFlag = 1;
        if ( *p == 'u' || *p == 'U' ) {
            p++;
            nPos++;
            uFlag = 1;
        }
    }
    
    if ( *p == ' ' || *p == '\0' || IsOperate( *p ) ) {
    	char* pEnd;
        pNode->symType = SYMTOKEN_NUM;
//        l = atol(pContent);
		l = strtol(pContent, &pEnd ,0);
		
        if ( lFlag ) {
            if ( uFlag ) { 
                pNode->typeValue = BI_U32_ULONG;
                pNode->result.ul = (unsigned long)l;
            }
            else {
                pNode->typeValue = BI_S32_SLONG;
                pNode->result.l = l;
            }
        }
        else {
        	if ( *pEnd == '9' || *pEnd == '8' ) {
        	    m_nErrNo = 6;
        	    delete []pContent;
        	    return FAILURE;   
        	}
            if ( uFlag ) {
                pNode->typeValue = BI_S16_USHORT;
                pNode->result.ui = (unsigned short)l;
            }
            else {
                pNode->typeValue = BI_S16_SHORT;
                pNode->result.i = (short)l;
            }
        }
        delete []pContent;
    }
    else {           
        delete []pContent;
        m_nErrNo = 6;
        return FAILURE;
    }
        
	m_nCurPos = nPos;
    return GOOD;
}

/***************************************************************************
*                                                                          
*  IsOperator  --  Check the char is operator ? 
*  parameter :                                                             
*       c -- input char                                         
*  return value :                                                          
*       TRUE -- Yes                                                               
*       FALSE -- No                                                               
*                                                                          
***************************************************************************/
BOOL CSymToken::IsOperate(char c)
{
	switch ( c ) {
	case '+' :
	case '-' :
	case '~' :
	case '!' :
	case '*' :
	case '(' :
	case ')' :
	case '[' :
	case ']' :
	case '.' :
	case '/' :
	case '%' :
	case '>' :
	case '<' :
	case '=' :
	case '&' :
	case '^' :
	case '|' :
		return TRUE;
	default :
		return FALSE;
	}
	return FALSE;
}

/***************************************************************************
*                                                                          
*  GetOperate  --  Get one operator token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetOperator(SYM_TOKEN_NODE *pNode)
{
    char c;  //  current char in expression.
    char *p;
    int nPos; 
    int nFlag;
    
	if ( SYMTOKEN_NUM == m_lastTokenType ||
		SYMTOKEN_FLOAT == m_lastTokenType ||
    	SYMTOKEN_SYMBOL == m_lastTokenType || 
    	SYMTOKEN_OPERATOR == m_lastTokenType || 
   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
	    nFlag = 1;
	}
	else {
		nFlag = 0;
	}
    nPos = m_nCurPos;                
    p = &m_strCmd[m_nCurPos];
    nPos++;
    c = *p;
    switch ( c ) {
	case '+' :                 
		p++;
		if ( *p == '+' ) {
			nPos++;
			if ( nFlag ) {
				if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
			   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
			   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
			        pNode->symType = SYMTOKEN_OPERATOR;
			        pNode->typeOpt = 38;
			    }
			    else {
			    	return FAILURE;
			    }
			}
			else {
		        pNode->symType = SYMTOKEN_OPERATOR1;
		        pNode->typeOpt = 36;
			} 
			break;
		}
		else if ( '=' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 31;
		    }
		    else {
		    	return FAILURE;
		    }
		    break;
		}
		
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 15;
	    }
	    else if ( SYMTOKEN_OPERATOR1 != m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_OPERATOR1;
	        pNode->typeOpt = 1;
		}	    	                                      
		else {
			return FAILURE;
		}
	    break;
	case '-' :                 
		p++;
		if ( '>' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 10;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		else if ( '=' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 32;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}                          
		else if ( '-' == *p ) {
			nPos++;
			if ( nFlag ) {
				if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
			   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
			   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
			        pNode->symType = SYMTOKEN_OPERATOR;
			        pNode->typeOpt = 39;
			    }
			    else {
			    	return FAILURE;
			    }
			}
			else {
		        pNode->symType = SYMTOKEN_OPERATOR1;
		        pNode->typeOpt = 37;
			} 
	        break;
		}                          
			
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 16;
	    }
	    else if ( SYMTOKEN_OPERATOR1 != m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_OPERATOR1;
	        pNode->typeOpt = 2;
		}	    	                                      
		else {
			return FAILURE;
		}
	    break;
	case '~' :
		if ( nFlag ) {
			return FAILURE; // syntax error
	    }
	    else if ( SYMTOKEN_OPERATOR1 != m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_OPERATOR1;
	        pNode->typeOpt = 3;
		}	    	                                      
		else {
			return FAILURE;
		}
        break;
	case '!' :
		p++;
		if ( '=' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 24;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		if ( nFlag ) {
			return FAILURE; // syntax error
	    }
	    else if ( SYMTOKEN_OPERATOR1 != m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_OPERATOR1;
	        pNode->typeOpt = 4;
		}	    	                                      
		else {
			return FAILURE;
		}
        break;
	case '*' :
		p++;
		if ( '=' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 33;
		    }
		    else {
		    	return FAILURE;
		    }
		    break;
		}

		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 12;
	    }                      
	    else {
	        pNode->symType = SYMTOKEN_OPERATOR1;
	        pNode->typeOpt = 5;
//			return FAILURE; // not support	        
	    }
        break;
	case '(' :
		if ( nFlag ) {
			return FAILURE; // syntax error
	    }
        pNode->symType = SYMTOKEN_LEFTPARENTHESES;
        pNode->typeOpt = 6;
        break;
	case ')' :
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_RIGHTPARENTHESES;
	        pNode->typeOpt = 7;
	    }
	    else {
			return FAILURE; // syntax error
		}
        break;
	case '[' :
    	if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
    		SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
    		SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_LEFTBRANKETS;
	        pNode->typeOpt = 8;
//	        return FAILURE; // not support
		}                                 
		else {
			return FAILURE; // syntax error
		}
        break;
	case ']' :
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_RIGHTBRANKETS;
	        pNode->typeOpt = 9;
//	        return FAILURE; // not support
	    }
	    else {
			return FAILURE; // syntax error
		}
        break;
	case '.' :
		if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
	   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
	   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 11;
//	        return FAILURE; // not support;
	    }
	    else {
	    	return FAILURE;
	    }
		break;
	case '/' :
		p++;
		if ( '=' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 34;
		    }
		    else {
		    	return FAILURE;
		    }
		    break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 13;
	    }                      
	    else {
			return FAILURE; // syntax error
	    }
        break;
	case '%' :
		p++;
		if ( '=' == *p ) {
			nPos++;
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 35;
		    }
		    else {
		    	return FAILURE;
		    }
		    break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 14;
	    }                      
	    else {
			return FAILURE; // syntax error
	    }
        break;
	case '>' :
		p++;
		if ( '>' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 17;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		else if ( '=' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 22;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 20;
	    }
		else {
			return FAILURE;
		}
	    break;
	case '<' :
		p++;
		if ( '<' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 18;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		else if ( '=' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 21;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 19;
	    }
		else {
			return FAILURE;
		}
	    break;
	case '=' :
		p++;
		if ( '=' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 23;
		    }
		    else {
		    	return FAILURE;
		    }
		}
		else {
			if ( SYMTOKEN_SYMBOL == m_lastTokenType || 
		   	    SYMTOKEN_RIGHTPARENTHESES == m_lastTokenType ||
		   	    SYMTOKEN_RIGHTBRANKETS == m_lastTokenType ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 30;
		    }
		    else {
		    	return FAILURE;
		    }
//			return FAILURE;
		}
		break;
	case '&' :
		p++;
		if ( '&' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 28;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 25;
	    }
		else {
			return FAILURE;
		}
	    break;
	case '^' :
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 26;
	    }
		else {
			return FAILURE;
		}
	    break;
	case '|' :
		p++;
		if ( '|' == *p ) {
			nPos++;
			if ( nFlag ) {
		        pNode->symType = SYMTOKEN_OPERATOR2;
		        pNode->typeOpt = 29;
		    }
		    else {
		    	return FAILURE;
		    }
	        break;
		}
		if ( nFlag ) {
	        pNode->symType = SYMTOKEN_OPERATOR2;
	        pNode->typeOpt = 27;
	    }
		else {
			return FAILURE;
		}
	    break;
	default :
		return FAILURE;  // syntax error;
	}                                    
	
	m_nCurPos = nPos;
	return GOOD;
}

/***************************************************************************
*                                                                          
*  GetFloat  --  Get one float token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetFloat(SYM_TOKEN_NODE *pNode)
{
    char c;  //  current char in expression.
    char *p , *pContent;
    double d;
    int nFlag;     
    int nPos;
    
    nFlag = 0;

    nPos = m_nCurPos;                
    p = &m_strCmd[m_nCurPos];

    if ( *p == '+' || *p == '-' ) {
        p++;
        nPos++;
    }
    while( 1 ) {
        c = *p ;
        if ( c>='0'&&c<='9' ) {
            p++;
            nPos++;
        }
        else {
            break;
        }
    }               
    
    if ( *p == '.' ) {
    	p++;
    	nPos++;
        while( 1 ) {
            c = *p ;
            if ( c>='0'&&c<='9' ) {
                p++;
                nPos++;
            }
            else {
                break;
            }
        }               
    }
    
    if ( *p == 'e' || *p == 'E' ) {
        p++;
        nPos++;
        if ( *p == '+' || *p == '-' ) {
            p++;
            nPos++;
        }
        while( 1 ) {
            c = *p ;
            if ( c>='0'&&c<='9' ) {
                nFlag = 1;
                p++;
                nPos++;
            }
            else {
                break;
            }
        } 
                      
    }            

	if ( nPos == m_nCurPos ) {
        m_nErrNo = 4;
        return FAILURE;
    }
    pContent = new char [ nPos - m_nCurPos + 1 ];
    if ( pContent == 0 ) {
        m_nErrNo = 1;
        return FAILURE;
    }
    memcpy( pContent , &m_strCmd[m_nCurPos],nPos - m_nCurPos );
    pContent[nPos - m_nCurPos] = '\0';     
    
    if ( *p == ' ' || *p == '\0' || IsOperate( *p ) ) {
        pNode->symType = SYMTOKEN_FLOAT;
        d = atof(pContent);
        pNode->typeValue = BI_F64;
        pNode->result.d = d;
        delete []pContent;
    }
    else {
        delete []pContent;
        m_nErrNo = 6;
        return FAILURE;
    }
        
	m_nCurPos = nPos;
    return GOOD;
}

/***************************************************************************
*                                                                          
*  GetSymbol  --  Get one symbol token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetSymbol(SYM_TOKEN_NODE *pNode)
{
    char c;  //  current char in expression.
    char *p , *pContent;
    int nFlag;     
    int nPos;
    int nPrefixFlag;
    
    nFlag = 0;
    nPrefixFlag = 0;

    nPos = m_nCurPos;                
    p = &m_strCmd[m_nCurPos];

//    if ( *p != '#' ) {
//        m_nErrNo = 7;
//        return FAILURE;
//    }
	if ( *p == '#' ) {
	    nPrefixFlag = 1;
	    p++;
	    nPos++;
	}
	else if ( *p == '$' ) {
	    nPrefixFlag = 2;
	    p++;
	    nPos++;
	}
		
	
	c = *p;
	if ( (c!='_')&&(c!='?')&&((c>'z')||(c<'a'))&&((c>'Z')||(c<'A')) ) {
        m_nErrNo = 7;
        return FAILURE;
    }
		 
    while( 1 ) {
        c = *p ;
	    if ( *p == ' ' || *p == '\0' || IsOperate( *p ) ) {
	        pNode->symType = SYMTOKEN_SYMBOL;
	        break;
	    }
	    p++;
	    nPos++;
    }                                                 
    
	if ( nPos == m_nCurPos ) {
        m_nErrNo = 4;
        return FAILURE;
    }
    pContent = new char [ nPos - m_nCurPos + 1 ];
    if ( pContent == 0 ) {
        m_nErrNo = 1;
        return FAILURE;
    }
    memcpy( pContent , &m_strCmd[m_nCurPos],nPos - m_nCurPos );
    pContent[nPos - m_nCurPos] = '\0';     
    
	if ( SYMTOKEN_OPERATOR2==m_lastTokenType && 
		( (10==m_pLastToken->typeOpt) || (11==m_pLastToken->typeOpt) ) ) 
	{
		pNode->nTkNum = m_nCurTokenNum;
        pNode->typeValue = (BUILT_IN_TYPE)99;  // means complex type 
        pNode->nComplexType = 2;               
		delete []pContent;
		m_nCurPos = nPos;
        return GOOD;
    }
    else if ( 2 == nPrefixFlag ) {
    	if ( m_nCmdFlag ) {  // means variable window not support
			m_nErrNo = 7;
			delete []pContent;
	        return FAILURE;
		}			
    		
   		if ( GOOD == GetUserVarValue( pContent , pNode->result.i ) ) {
	        pNode->nComplexType = 0;
	        pNode->typeValue = BI_S16_SHORT;
	   		pNode->nTkNum = m_nCurTokenNum;
   			delete []pContent;
			m_nCurPos = nPos;
		    return GOOD;                                              
		}
		else {
			m_nErrNo = 7;
			delete []pContent;
	        return FAILURE;
		}			
    }
    else if ( CheckIsValidVar( pContent, pNode->symDesc , pNode->typeIndex ,
		pNode->isGlobal , pNode->addr ) != GOOD ) {
        m_nErrNo = 7;
		delete []pContent;
        return FAILURE;
	}
			
	delete []pContent; 
	pContent = 0;
	if ( GOOD != GetSymbolValue( pNode ) ) return FAILURE;
	m_nCurPos = nPos;
    return GOOD;
}

/***************************************************************************
*                                                                          
*  GetSymbolValue  --  Get value of one symbol token node 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::GetSymbolValue(SYM_TOKEN_NODE *pNode)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX typeIndex;
    char temp[256];

    typeIndex = pNode->typeIndex;
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(pNode->typeIndex, &typeHeader) ) {
        m_nErrNo = 7;
        return FAILURE;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        if ( FAILURE == GetSValue( typeIndex , pNode ) ) {
	        m_nErrNo = 7;
            return FAILURE;
        }
    }
    else {
        if ( typeHeader.t.complexType == TY_TYPE ) {
            while( 1 ) {
                TYPE_INDEX  typeNext;
                   
                if ( GOOD != SymGetTypeTypeIndex(typeIndex,&typeNext) ) {
			        m_nErrNo = 7;
                    return FAILURE;
                }
                typeIndex = typeNext;
                if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ){
			        m_nErrNo = 7;
                    return FAILURE;
                }
                if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
                    break;
                else if ( typeHeader.t.complexType != TY_TYPE )
                    break;
            }            
            if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
                if ( FAILURE == GetSValue( typeIndex , pNode ) ) {
			        m_nErrNo = 7;
                    return FAILURE;
                }
            }
        }

        if ( (typeHeader.typeChoice==COMPLEX_TYPE_CLASS)&&
            (typeHeader.t.complexType == TY_BITFIELD) ) {

//            if ( SrcIsIEEE() == GOOD ) {
////                if ( FAILURE == GetIEEEBValue( node , 1 , buff) ) {
//  because of IEEE's bitfield is struct's member 
//                if ( FAILURE == GetIEEEBValue( pNode ) ) {
//	                  m_nErrNo = 7;
//                    return FAILURE;
//                }
//            }
//            else {
            if ( FAILURE == GetBitValue( typeIndex , pNode ) ) {
		        m_nErrNo = 7;
                return FAILURE;
            }
//            }
        }    
        else if (typeHeader.typeChoice==COMPLEX_TYPE_CLASS &&
            (typeHeader.t.complexType == TY_ENUM_C) ) {
            if ( FAILURE == GetEnumValue( typeIndex , pNode ) ) {
		        m_nErrNo = 7;
                return FAILURE;
            }
        }    
        else if (typeHeader.typeChoice==COMPLEX_TYPE_CLASS) {
// This symbol is complex type such as Array , struct , pointer 
	        pNode->typeValue = (BUILT_IN_TYPE)99;  // means complex type 
	        pNode->nComplexType = 1;
//	        m_nErrNo = 7;
//            return FAILURE;
        }
    }
    return GOOD;
}

/*------------------------------------------------------------------------
** GetSValue
**
** Purpose:
**    Get build-in types value to expression node for variable server
*/
/*------------------------------------------------------------------------*/
int GetSValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode)
{                                                              
    ADDR start , end;
    char data[16] ;
    char data1[8];
    U8 uc;
    U16 ui;
    U32 ul;
    float *f_p;
    double *d_p;
    int i;
    RET_ADDR retAddr;
    
	if ( pNode == 0 ) return FAILURE;
    if ( typeIndex >= 256 ) return FAILURE;
    int nBank; 
    start.addr = pNode->addr.addr;
    nBank = start.addr>>16;
    switch( pNode->addr.segType ) {
    case SEG_CODE :                     
        start.addrType = end.addrType = nBank+MEM_P0;
        break;
    case SEG_XDATA :
        start.addrType = end.addrType = nBank+MEM_X0;
        break;
    case SEG_DATA :
        start.addrType = end.addrType = MEM_I;
        break;
    case SEG_REGISTER :
        start.addrType = end.addrType = 5;
        break;
    case SEG_BIT :
        start.addrType = end.addrType = 6;
        break;
    case SEG_SFR :
        start.addrType = end.addrType = 7;
        break;
    case SEG_CONST :
        start.addrType = end.addrType = 8;
        break;
    default :
        start.addrType = end.addrType = 0;
        break;
    }   
    //start.addr = pNode->addr.addr ;
    switch ( typeIndex ) {
    case BI_BIT :
        end.addr = start.addr ;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,1,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
#endif  
        uc = data[0]; 
        pNode->typeValue = BI_U8_UCHAR;
        pNode->result.uc = uc;
        return GOOD;
    case BI_S8_SCHAR:
    case BI_U8_UCHAR:
    case BI_S8_CHAR:
        end.addr = start.addr ;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,1,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
#endif  
        if( typeIndex == BI_U8_UCHAR ) {            
            uc = data[0]; 
	        pNode->typeValue = BI_U8_UCHAR;
	        pNode->result.uc = uc;
        }
        else {
	        pNode->typeValue = BI_S8_SCHAR;
	        pNode->result.c = data[0];
        }
        return GOOD;
    case BI_S16_SINT:
    case BI_U16_UINT:
    case BI_S16_SHORT:
    case BI_S16_USHORT:
    case BI_S16_SHORTINT:
    case BI_S16_SSHORT:

    case BI_STACK_INT:
    case BI_STACK_U:
    case BI_STACK_UINT:
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,2,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
        data[1] = 0;
#endif  
        //ui = (U16) data[0];
        //ui = (ui<<8) + (U8)data[1];
        ui=*((U16*)data);
        if ( typeIndex==BI_U16_UINT || typeIndex==BI_S16_USHORT ||
            typeIndex==BI_STACK_U || typeIndex==BI_STACK_UINT ) {
	        pNode->typeValue = BI_S16_USHORT;
	        pNode->result.ui = ui;
        }
        else {
	        pNode->typeValue = BI_S16_SHORT;
	        pNode->result.i = (short)ui;
        }
        return GOOD;
    case BI_S32_SLONG:
    case BI_U32_ULONG:
    case BI_S32_LONG:
        end.addr = start.addr+3;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,4,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
        data[1] = 0;
        data[2] = 0;
        data[3] = 0;
#endif  
        //ul = (U8) data[0];
        //ul = (ul<<8) + (U8)data[1];
        //ul = (ul<<8) + (U8)data[2];
        //ul = (ul<<8) + (U8)data[3];
        ul=*((U32*)data);// jerry
        if ( typeIndex==BI_U32_ULONG ) {
	        pNode->typeValue = BI_U32_ULONG;
	        pNode->result.ul = ul;
        }
        else {
	        pNode->typeValue = BI_S32_SLONG;
	        pNode->result.l = (long)ul;
        }
        return GOOD;
    case BI_F32 :
        end.addr = start.addr+3;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,4,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
        data[1] = 0;
        data[2] = 0;
        data[3] = 0;
#endif  
        if ( GOOD == SrcIsStatement() || GOOD == SrcIsIEEE() )
            for ( i=0;i<4;i++ ) {
                data1[3-i] = data[i];
            }
        else
            for ( i=0;i<4;i++ ) {
                data1[i] = data[i];
            }
        f_p = (float *)data1;
        pNode->typeValue = BI_F64;
        pNode->result.d = (double)*f_p;
        return GOOD;
    case BI_F64 :    
        if ( GOOD == SrcIsStatement() || GOOD == SrcIsIEEE() ) {
            end.addr = start.addr+3;
#ifdef _LINK_WITH_ABI_        
            if ( ICE_OK != emuGetMemN(start,4,(U8*)data,&retAddr) ) {
                return FAILURE;
            }
#else 
            data[0] = 0;    
            data[1] = 0;
            data[2] = 0;
            data[3] = 0;
#endif  
            for ( i=0;i<4;i++ ) {
                data1[3-i] = data[i];
            }
            f_p = (float *)data1;
	        pNode->typeValue = BI_F64;
	        pNode->result.d = (double)*f_p;
        }
        else {
            end.addr = start.addr+7;
#ifdef _LINK_WITH_ABI_        
            if ( ICE_OK != emuGetMemN(start,8,(U8*)data,&retAddr) ) {
                return FAILURE;
            }
#endif  
            for ( i=0;i<8;i++ ) {
                data1[i] = data[i];
            }
            d_p = (double *)data1;
	        pNode->typeValue = BI_F64;
	        pNode->result.d = (double)*d_p;
        }
        return GOOD;
    case 99 :
    	return FAILURE;    
    default :
        end.addr = start.addr ;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,1,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
#endif  
        uc = data[0]; 
        pNode->typeValue = BI_U8_UCHAR;
        pNode->result.uc = uc;
        return GOOD;
    }
    return GOOD;        
}

/*------------------------------------------------------------------------
** BuildBValue
**
** Purpose:
**    Get bitfield type value to expression node for variable server
*/
/*------------------------------------------------------------------------*/
int GetBitValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode)
{                                                              
    TYPE_HEADER_TYPE typeHeader;
    TYPE_BITFIELD_STRUCT bit;
    ADDR             start , end;
    char data[16] ;
    char temp[256];
    U16 ui , uj;
    int i;                                  
    RET_ADDR retAddr;
    
	if ( pNode == 0 ) return FAILURE;
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader)) 
        return FAILURE;
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
        return FAILURE;
    if ( typeHeader.t.complexType != TY_BITFIELD ) 
        return FAILURE;
    switch( pNode->addr.segType ) {
    case SEG_CODE :
        start.addrType = end.addrType = 2;
        break;
    case SEG_XDATA :
        start.addrType = end.addrType = 3;
        break;
    case SEG_DATA :
        start.addrType = end.addrType = 4;
        break;
    case SEG_REGISTER :
        start.addrType = end.addrType = 5;
        break;
    case SEG_BIT :
        start.addrType = end.addrType = 6;
        break;
    case SEG_SFR :
        start.addrType = end.addrType = 7;
        break;
    case SEG_CONST :
        start.addrType = end.addrType = 8;
        break;
    default :
        start.addrType = end.addrType = 0;
        break;
    }   
    start.addr = pNode->addr.addr ;
    if ( GOOD != SymGetTypeBitfield(typeIndex,&bit) )
        return FAILURE;
        
    switch ( bit.baseTypeIndex ) {
    case BI_S8_SCHAR:
    case BI_U8_UCHAR:
    case BI_S8_CHAR:  
        if ( (bit.offset+bit.size)>8 ) return FAILURE;
        end.addr = start.addr ;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,1,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
#endif  
        ui = data[0];
        ui = ui >> bit.offset ;
        uj = 1;
        for(i=0;(unsigned int)i<bit.size;i++)
            uj = uj << 1;
        uj--;
        ui = ui & uj;
        if( bit.baseTypeIndex == BI_U8_UCHAR ) {            
	        pNode->typeValue = BI_U8_UCHAR;
	        pNode->result.uc = (unsigned char)ui;
        }
        else {
            uj++;
            if ( ui >= uj/2 )
                i = (int)(ui-uj);
            else 
                i = (int)ui;
	        pNode->typeValue = BI_U8_UCHAR;
	        pNode->result.c = (char)i;
        }
        return GOOD;
    case BI_S16_SINT:
    case BI_U16_UINT:
    case BI_S16_SHORT:
    case BI_S16_USHORT:
    case BI_S16_SHORTINT:
    case BI_S16_SSHORT:

    case BI_STACK_INT:
    case BI_STACK_U:
    case BI_STACK_UINT:

        if ( (bit.offset+bit.size)>16 ) return FAILURE;
        end.addr = start.addr+1;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,2,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
        data[1] = 0;
#endif  
        //ui = (U16) data[0];
        //ui = (ui<<8) + (U8)data[1];
        ui=*( (U16*)data); //  jeryy

        ui = ui >> bit.offset ;
        uj = 1;
        for(i=0;(unsigned int)i<bit.size;i++)
            uj = uj << 1;
        uj--;
        ui = ui & uj;

        if ( bit.baseTypeIndex==BI_U16_UINT || 
            bit.baseTypeIndex==BI_S16_USHORT ||
            bit.baseTypeIndex== BI_STACK_U ||
            bit.baseTypeIndex== BI_STACK_UINT ) {
	        pNode->typeValue = BI_S16_USHORT;
	        pNode->result.ui = ui;
        }
        else {                 
            uj++;
            if ( ui >= uj/2 )
                i = (int)(ui-uj);
            else
                i = (int)ui;
	        pNode->typeValue = BI_S16_SSHORT;
	        pNode->result.i = (short)i;
        }
        return GOOD;
    default : // unsigned int ;
        if ( (bit.offset+bit.size)>16 ) return FAILURE;
        end.addr = start.addr+1;
#ifdef _LINK_WITH_ABI_        
        if ( ICE_OK != emuGetMemN(start,2,(U8*)data,&retAddr) ) {
            return FAILURE;
        }
#else 
        data[0] = 0;    
        data[1] = 0;
#endif  
        //ui = (U16) data[0];
        //ui = (ui<<8) + (U8)data[1];
        ui = *((U16*)data);
        
        ui = ui >> bit.offset ;
        uj = 1;
        for(i=0;(unsigned int)i<bit.size;i++)
            uj = uj << 1;
        uj--;
        ui = ui & uj;

        pNode->typeValue = BI_S16_USHORT;
        pNode->result.ui = ui;
        return GOOD;
    }
    return GOOD;        
}

/*------------------------------------------------------------------------
** GetEnumValue
**
** Purpose:
**    Get enum type value to expression node for variable server
*/
/*------------------------------------------------------------------------*/
int GetEnumValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode)
{                                                              
    ADDR start , end;
    TYPE_HEADER_TYPE typeHeader;
    char data[16] ;
    char temp[256];
    U16 ui;          
    RET_ADDR retAddr;
    U16 nBank;                
	if ( pNode == 0 ) return FAILURE;
    if ( typeIndex < 256 ) return FAILURE;
    //if ( SrcIsIEEE() != GOOD ) return FAILURE;  jerry
    typeHeader.typeName = temp;  
    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader)) 
        return FAILURE;
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
        return FAILURE;
    if ( typeHeader.t.complexType != TY_ENUM_C ) 
        return FAILURE;        
    start.addr = pNode->addr.addr;
    nBank = start.addr>>16;      
    switch( pNode->addr.segType ) {
    case SEG_CODE :
        start.addrType = end.addrType = nBank+MEM_P0;
        break;
    case SEG_XDATA :
        start.addrType = end.addrType = nBank +MEM_X0;
        break;
    case SEG_DATA :
        start.addrType = end.addrType = MEM_I;
        break;
    case SEG_REGISTER :
        start.addrType = end.addrType = 5;
        break;
    case SEG_BIT :
        start.addrType = end.addrType = 6;
        break;
    case SEG_SFR :
        start.addrType = end.addrType = 7;
        break;
    case SEG_CONST :
        start.addrType = end.addrType = 8;
        break;
    default :
        start.addrType = end.addrType = 0;
        break;
    }   
    start.addr = pNode->addr.addr ;
    end.addr = start.addr+1;
#ifdef _LINK_WITH_ABI_        
    if ( ICE_OK != emuGetMemN(start,2,(U8*)data,&retAddr) ) {
        return FAILURE;
    }
#else 
    data[0] = 0;    
    data[1] = 0;
#endif  
    //ui = (U16) data[0];
    //ui = (ui<<8) + (U8)data[1];
    ui=*((U16*)data); // JERRY
    pNode->typeValue = BI_S16_USHORT;
    pNode->result.ui = ui;

    return GOOD;        
}

/***************************************************************************
*                                                                          
*  DisplayOneToken  --  Display one symbol token node context 
*  parameter :                                                             
*       pNode -- one token node                                         
*  return value :                                                          
*       None -- failure                                                               
*                                                                          
***************************************************************************/
void CSymToken::DisplayOneToken(SYM_TOKEN_NODE *pNode)
{
	if ( pNode == 0 ) return;
/*	
	char temp[100];
	int nLen;

	switch( pNode->symType ) {
    case SYMTOKEN_NULL :
    	sprintf(temp,"SYMTOKEN_NULL ");
    	break;
    case SYMTOKEN_NUM :
    case SYMTOKEN_FLOAT : 
    case SYMTOKEN_SYMBOL :
		if ( SYMTOKEN_SYMBOL == pNode->symType ) {
	    	sprintf(temp,"SYMTOKEN_SYMBOL ");
	    	nLen = strlen(temp);
	    	sprintf(&temp[nLen],
	    		"%d IsGlobal %d Desc %ld Type %ld ADDRESS (%d:%8lx) ",
	    		pNode->typeValue,pNode->isGlobal,
	    		pNode->symDesc,pNode->typeIndex,pNode->addr.segType,
	    		pNode->addr.addr);
	    	nLen = strlen(temp);                  
	    }
	    else {
	    	sprintf(temp,"SYMTOKEN_NUMBER ");
	    	nLen = strlen(temp);
	    	sprintf(&temp[nLen],"%d ",pNode->typeValue);
	    	nLen = strlen(temp);
		}
	    switch ( pNode->typeValue ) {
	    case BI_BIT :
	        sprintf(&temp[nLen],"Value = %d",pNode->result.uc);
	        break;
	    case BI_S8_SCHAR:
	    case BI_U8_UCHAR:
	    case BI_S8_CHAR:
	        if( pNode->typeValue == BI_U8_UCHAR ) {            
		        sprintf(&temp[nLen],"Value = %u",pNode->result.uc);
	        }
	        else {
		        sprintf(&temp[nLen],"Value = %d",pNode->result.c);
	        }
			break;
	    case BI_S16_SINT:
	    case BI_U16_UINT:
	    case BI_S16_SHORT:
	    case BI_S16_USHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	
	    case BI_STACK_INT:
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	        if ( pNode->typeValue==BI_U16_UINT || 
	        	pNode->typeValue==BI_S16_USHORT ||
	            pNode->typeValue==BI_STACK_U || 
	            pNode->typeValue==BI_STACK_UINT ) {
		        sprintf(&temp[nLen],"Value = %u",pNode->result.ui);
	        }
	        else {
		        sprintf(&temp[nLen],"Value = %d",pNode->result.i);
	        }
			break;
	    case BI_S32_SLONG:
	    case BI_U32_ULONG:
	    case BI_S32_LONG:
	        if ( pNode->typeValue==BI_U32_ULONG ) {
		        sprintf(&temp[nLen],"Value = %lu",pNode->result.ul);
	        }
	        else {
		        sprintf(&temp[nLen],"Value = %ld",pNode->result.l);
	        }
			break;
	    case BI_F32 :
	    case BI_F64 :    
	        sprintf(&temp[nLen],"Value = %le",pNode->result.d);
			break;
	    case 99 :
	        sprintf(&temp[nLen],"Value = Not support");
			break;
	    default :
	        sprintf(&temp[nLen],"Value = %d",pNode->result.uc);
	        break;
	    }
		break;    	
	case SYMTOKEN_OPERATOR1 :
    	sprintf(temp,"SYMTOKEN_OPERATOR1 ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d ",pNode->typeOpt);
		break;
	case SYMTOKEN_OPERATOR2 :
    	sprintf(temp,"SYMTOKEN_OPERATOR2 ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d ",pNode->typeOpt);
		break;
    case SYMTOKEN_LEFTPARENTHESES :
    	sprintf(temp,"SYMTOKEN_LEFTPARENTHESES ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d --  ( ",pNode->typeOpt);
		break;
    case SYMTOKEN_RIGHTPARENTHESES :
    	sprintf(temp,"SYMTOKEN_RIGHTPARENTHESES ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d --  ) ",pNode->typeOpt);
		break;
    case SYMTOKEN_LEFTBRANKETS :
    	sprintf(temp,"SYMTOKEN_LEFTBRANKETS ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d --  [ ",pNode->typeOpt);
		break;
    case SYMTOKEN_RIGHTBRANKETS :
    	sprintf(temp,"SYMTOKEN_RIGHTBRANKETS ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d --  ] ",pNode->typeOpt);
		break;
	case SYMTOKEN_OPERATOR :
    	sprintf(temp,"SYMTOKEN_OPERATOR ");
    	nLen = strlen(temp);
    	sprintf(&temp[nLen],"%d ",pNode->typeOpt);
		break;
    default :
    	sprintf(temp,"SYMTOKEN_UNKNOWN ");
    	break;
	}	   
	ShowLine( temp );
*/	
    return ;
}

int CSymToken::GetOneTokenName(int nNum , char*& pName)
{   
	int nLen;
	char *ss , *sss;
	
	if ( nNum < 0 || nNum >= m_nCurTokenNum ) return 10;
    nLen = m_pTokenPos[ nNum+1 ] - m_pTokenPos[ nNum ];
    if ( 0 == nLen ) return 10;
    ss = new char [ nLen+1 ];
	if ( 0 == ss  ) return 1;
	memcpy(ss , &m_strCmd[ m_pTokenPos[nNum] ] , nLen );
	ss[ nLen ] = '\0';
	SkipLeftSpace( ss , sss );
	if ( 0 == sss ) {
		delete []ss;
		return 10;
	}
	if ( '#' == *sss ) sss++;
	nLen = strlen( sss );
    pName = new char [ nLen+1 ];
	if ( 0 == pName  ) {
		delete []ss;
		return 1; 
	}
	strcpy(pName , sss);
	delete []ss;
	return 0;
}

int CSymToken::GetAllTokenNameToStr(CString& strName)
{
	int nErr;
	char *ss;
	CString str="";
	
	for(int i = 0;i < m_nCurTokenNum;i++) {
		nErr = GetOneTokenName(i,ss);
		str += ss;
//		str += " ";
		delete ss;
		if ( 0 != nErr ) return nErr;
	}
	strName = str;
	return 0;
}    

/***************************************************************************
*                                                                          
*  UpdateSymbol  --  Get one symbol token node from expression 
*  parameter :                                                             
*       pNode -- one token node                                         
*       pContent  --  token name
*  return value :                                                          
*       GOOD -- success                                                               
*       FAILURE -- failure                                                               
*                                                                          
***************************************************************************/
int CSymToken::UpdateSymbol(SYM_TOKEN_NODE *pNode,char *pContent)
{
    int nPos;
    
	if ( 0 == pNode || 0 == pContent ) {
		m_nErrNo = 3;
		return FAILURE;
	}
	if ( SYMTOKEN_SYMBOL != pNode->symType ) return GOOD;
	if ( 2 == pNode->nComplexType ) return GOOD;

    if ( pContent[0] == '$' ) {
    	if ( m_nCmdFlag ) {  // means variable window not support
			m_nErrNo = 7;
	        return FAILURE;
		}			
    		
   		if ( GOOD == GetUserVarValue( pContent , pNode->result.i ) ) {
	        pNode->nComplexType = 0;
	        pNode->typeValue = BI_S16_SHORT;
		    return GOOD;                                              
		}
		else {
			m_nErrNo = 7;
	        return FAILURE;
		}			
    }
    else if ( CheckIsValidVar( pContent, pNode->symDesc , pNode->typeIndex ,
		pNode->isGlobal , pNode->addr ) != GOOD ) {
        m_nErrNo = 7;
        return FAILURE;
	}
			
	if ( GOOD != GetSymbolValue( pNode ) ) return FAILURE;
    return GOOD;
}
/******************************** E O F ***********************************/
