
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMUSER.H
**
**  Description:
**      All user defined symbol API's have the prefix: SymUser
**      Major header file used by user defined symbol.
**
**  Status:  CODED
**
**    Rev 1.0   25 May 1995 12:00:00   Gates
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMUSER_H_
#define _SYMUSER_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////
// User defined symbol node frame
/////////////////////////////////////////////////////////////////
struct SymUserNode {        
    char *name; // symbol name
    U32 addr;   // symbol address
    U8 type;    // symbol type
    struct SymUserNode *next;   // pointer to next address ; sort by address
    struct SymUserNode *ptr;    // pointer to next name ; sort by name
public :
    SymUserNode() {
        name = 0;
        addr = 0;
        type = 0;
        next = 0;
        ptr = 0;
    };  
};
    
struct SymUserNodeIndex {
    int num;                         
    struct SymUserNode *node;       
    struct SymUserNodeIndex *next;  
public :
    SymUserNodeIndex() {
        num = 0;
        node = 0;
        next = 0;
    };  
};
  
/////////////////////////////////////////////////////////////////
// User defined symbol Server main frame
/////////////////////////////////////////////////////////////////
class SymUserTable {
private :
    U32 symno;
    struct SymUserNode *namePtr;
    struct SymUserNode *addrPtr;
    struct SymUserNodeIndex *nameIndexPtr;
    struct SymUserNodeIndex *addrIndexPtr;

    struct SymUserNode *matchPtr;
    struct SymUserNode *preMatchPtr;
public :
    SymUserTable() {
        symno = 0;
        namePtr = 0;
        addrPtr = 0;
        nameIndexPtr = 0;
        addrIndexPtr = 0;           
        
        matchPtr = 0;
        preMatchPtr = 0;
    };
    ~SymUserTable(); 
             
public :
    int SymUserCreate(char *str , U8 type , U32 addr);
    int SymUserDelete(char *str);
    void SymUserDeleteAll(void);
    int SymUserList( void );
    int SymUserQuery( char *str );
    int SymUserSSave( char *str );
    int SymUserSRecall( char *str );
    int Sym2Addr( char *str , U8* type , U32* addr );
    int Addr2Sym( U8 type , U32 addr , char *str );

private :   
    int SymUserAddNode( struct SymUserNode *node );
    
    void SymUserSearchNodeByName( char *str );
    void SymUserSearchNodeByAddr( U32 addr , U8 type );
             
    void SymUserRejustNameIndex(void);
    void SymUserRejustAddrIndex(void);
    void SymUserClearUpNode();
    void SymUserClearUpIndex();
};              

 //extern void ShowLine(char *);modify by jerry
 //extern void ShlReShowLine(char * , int);modify by jerry

#endif
/******************************** E O F ***********************************/
