#include "stdafx.h"               
#include "symblsvr.h" 
#include "stkinit.h"
#include "varinit.h"

extern class VarServer stkObject;    


#ifdef __cplusplus
extern "C"
{
#endif

struct STKNode * WINAPI Stk_GetHeader(void) ;
int WINAPI Stk_buildStack();
int WINAPI Stk_add(struct STKNode *node);
void WINAPI Stk_deleteAll();
void WINAPI Stk_DisplayToShell();
int WINAPI Stk_IsValidVar(char *command,BOOLEAN& isGlobal,SYM_DESCRIPTOR& symDesc);
void WINAPI Stk_GetNumber(int& num) ;
int WINAPI Stk_InitStkLocalVar(int nLevel);
int WINAPI Stk_GetStkLocalVar(SYM_DESCRIPTOR& desc,CString& name);
void WINAPI Stk_VarDeleteAll();  
int WINAPI Stk_VarLineToNode(int nRow,struct VarNode *& node);
int WINAPI Stk_IsOverFlow();

///////
//int WINAPI Stk_AddVar( char *str );
int WINAPI Stk_AddLocalVar(SYM_DESCRIPTOR desc,CString name);
//int WINAPI Stk_Add( struct VarNode* node );
int WINAPI Stk_Delete( struct VarNode* node );
int WINAPI Stk_DeleteLocal(SYM_DESCRIPTOR desc);
void WINAPI Stk_DeleteAllLocal(void);
void WINAPI Stk_MaxLine(int& nLine);
int WINAPI Stk_IsLegalValue(int nLine , CString str);
//int WINAPI Stk_CheckValue(struct VarNode* node, char *str);
int WINAPI Stk_ModifyValue(int nLine , CString str);
//int WINAPI Stk_SetValue(struct VarNode* node, char *str);
//void WINAPI Stk_DeleteAll();
int WINAPI Stk_ExtendedNode( struct VarNode* node );
int WINAPI Stk_CompressNode( struct VarNode* node );
//int WINAPI Stk_UpdataExtendedNode( struct VarNode* node );
//int WINAPI Stk_EditNode(struct VarNode *node , char *str);
int WINAPI Stk_UpdataAllLocal();
//int WINAPI Stk_UpdataAllNode( );
//int WINAPI Stk_UpdataOneNode( struct VarNode* node );
//int WINAPI Stk_UpdataOneNodeValue( struct VarNode* node );
//void WINAPI Stk_ShowOneNode( struct VarNode* node );
//void WINAPI Stk_ShowVarToShell();
//void WINAPI Stk_ClearNode( struct VarNode* node );
//int WINAPI Stk_LineToNode(int nRow,struct VarNode *& node);
//void WINAPI  Stk_UpdataLine( int nLine , struct VarNode * node );
int WINAPI Stk_NodeToPos(struct VarNode* node,int& nPos);
void WINAPI Stk_AddrToStr(ADDRESS_TYPE addr,CString& str);
int WINAPI Stk_Search( char *str , int & nLine );
int WINAPI Stk_SearchNext( char *str , int nStartLine , int & nLine );   
VarNode* WINAPI  Stk_GetListHeader();
#ifdef __cplusplus
}
#endif      

void WINAPI Stk_VarDeleteAll()
{
	 stkObject.VarDeleteAll();
}


int WINAPI Stk_VarLineToNode(int nRow,struct VarNode *& node)
{  
	return stkObject.VarLineToNode(nRow,node) ;
}

int WINAPI Stk_IsOverFlow()
{
     return 0;
}


struct STKNode * WINAPI Stk_GetHeader(void)
{
	return stkObject.GetHeader();
}                                

int WINAPI Stk_buildStack()
{
	return stkObject.buildStack();
}

int WINAPI Stk_add(STKNode *node)
{
	return stkObject.add(node);
}                     


void WINAPI Stk_DisplayToShell()
{
	stkObject.DisplayToShell();
}



int WINAPI Stk_IsValidVar(char *command,BOOLEAN& isGlobal,SYM_DESCRIPTOR& symDesc)
{
	return stkObject.IsValidVar(command,isGlobal,symDesc);
}

void WINAPI Stk_GetNumber(int& num) 
{
	stkObject.GetNumber(num);
}

int WINAPI Stk_InitStkLocalVar(int nLevel)
{
	return stkObject.InitStkLocalVar(nLevel);
}


int WINAPI Stk_GetStkLocalVar(SYM_DESCRIPTOR& desc,CString& name)
{
	return stkObject.GetStkLocalVar(desc,name);
}

//////////////

   
int WINAPI Stk_AddLocalVar(SYM_DESCRIPTOR desc,CString name)
{
	return stkObject.AddLocalVar(desc, name) ;
}



int WINAPI Stk_Delete( struct VarNode* node )
{
	return stkObject.Delete(node) ;
}


void WINAPI Stk_DeleteAllLocal(void)
{
	 stkObject.DeleteAllLocal() ;
}


void WINAPI Stk_MaxLine(int& nLine)
{
	stkObject.VarMaxLine(nLine) ;
}
    
int WINAPI Stk_IsLegalValue(int nLine , CString str)
{
	return stkObject.IsLegalValue(nLine,str) ;
}

    
int WINAPI Stk_ModifyValue(int nLine , CString str)
{
	return stkObject.ModifyValue(nLine,str) ;
}


void WINAPI Stk_deleteAll()
{
	stkObject.VarDeleteAll() ;
}

int WINAPI Stk_ExtendedNode( struct VarNode* node )
{
	return stkObject.VarExtendedNode(node) ;
}

int WINAPI Stk_CompressNode( struct VarNode* node )
{
	return stkObject.VarCompressNode(node) ;
}




int WINAPI Stk_UpdataAllLocal()
{
	return stkObject.UpdataAllLocal() ;
}


int WINAPI Stk_NodeToPos(struct VarNode* node,int& nPos)
{
	return stkObject.VarNodeToPos(node,nPos) ;
}


void WINAPI Stk_AddrToStr(ADDRESS_TYPE addr,CString& str)
{
	stkObject.VarAddrToStr(addr,str) ;
}


int WINAPI Stk_Search( char *str , int & nLine )
{
	return stkObject.Search(str,nLine) ;
}


int WINAPI Stk_SearchNext( char *str , int nStartLine , int & nLine )
{
	return stkObject.SearchNext(str,nStartLine,nLine) ;
}
 

extern "C" VarNode* WINAPI  Stk_GetListHeader()
{
	return stkObject.varListHeader ;
}  

 
int WINAPI Stk_DeleteLocal(SYM_DESCRIPTOR desc)
{
	return stkObject.DeleteLocal(desc);
}


