
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/STKINIT.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/STKINIT.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:24   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef _STKINIT_H_

#define _STKINIT_H_

struct STKNode {
    int num;    //  the level of stack
    int flag;   //   the valible of desc1
    U32 desc;   //module desc
    U32 desc1;  //block  desc
    U32 sp;
    U32 addr;   //return addr
    U32 addr1;  // call addr 
    U16 framePtr;
    BOOL bFrame;
    struct STKNode *next ;
    struct STKNode *prev;

public :
    STKNode() {
        num = 0;
        flag = 0;
        desc = 0L;
        desc1 = 0L;
        sp = addr = addr1 = 0L;
        next = prev = 0;
    }
};

class stkServer {
private :
    struct STKNode *stkListHeader ;
    struct STKNode *curNode ;
    char *m_buff;
    SYM_DESCRIPTOR m_blockDesc ;
    SYM_DESCRIPTOR m_varDesc ;

public :
    BOOL m_isStkDirty;
    stkServer() {
        stkListHeader = 0;
        curNode = 0;
        m_buff = 0;
        m_blockDesc = NULL_SYMBOL;
        m_varDesc = NULL_SYMBOL;  
        m_isStkDirty = TRUE;
    }

public :
	void SetStkDirty();
    struct STKNode * GetHeader(void) { return stkListHeader; }
    int buildStack();
    int IARbuildStack();
    int BSObuildStack();
    int add(struct STKNode *node);
    void deleteAll();
    void DisplayToShell();
//    int IsValidVar(char *command,BOOLEAN& isGlobal,SYM_DESCRIPTOR& symDesc);
	int IsValidVar(char *command,BOOLEAN& isGlobal,SYM_DESCRIPTOR& symDesc,
		SYM_DESCRIPTOR symSpecModule=NULL,int nLine=1);
    void GetNumber(int& num) {
        if ( curNode ) num = curNode->num + 1;
        else num = 0;
    };                          
    int InitStkLocalVar(int nLevel);
    int GetStkLocalVar(SYM_DESCRIPTOR& desc,CString& name);
	RETCODE VarIsActive(SYM_DESCRIPTOR inputSymbol,LPSTR varName,U16& framePtr);
	RETCODE searchFunc(SYM_DESCRIPTOR inputSymbol,U16& framePtr);
	RETCODE GetCurentFramePtr(SYM_DESCRIPTOR inputSymbol,LPSTR varName,U16& framePtr);
};   


#endif
