
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMDEF.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMDEF.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: symdef.h
**
** Title: Symbol Server Type Define
**
** Purpose:
**  External declarations of routines and data structures for loading
**  and accessing symbols included by all servers that access symbols
**  and by the loader for loading symbols.
**
** Status: PRELIMINARY
**
** $Log$
**
** $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMDEF.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _SYMDEFINE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include <stdio.h>

                       /****************************
                        *                          *
                        *      # DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

#define MAX_USE_DEFINE_SYMBOL_LENGTH 40

#define NULL_SYMBOL 0L     /* used to define the null pointer for symbol */
                           /* offsets */

#define MAX_SYMNAME_LENGTH 256  /* use for defining (LPSTR) string allocation
                                   size */
#define MAX_PATH_LENGTH    256
#define MAX_MODULE_NAME_LEN   64 

#define SYM_MAX_COLUMN 65535
#define DEFAULT_START_ADDR 0xFFFFFFFF
#define DEFAULT_END_ADDR   0
                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
typedef enum {
   DEBUG_DISPLAY,
   USER_DISPLAY,
   MODULE_DISPLAY,
   FUNCTION_DISPLAY,
   PUBLIC_DISPLAY,
   LINES_DISPLAY,
   VARLIFE_DISPLAY
} SYM_DISPLAY_TYPE;

/*  basic type  definitions */
typedef char FAR *LPSTR;
typedef U16 LINENUM_TYPE;
typedef U16 COLUMN_TYPE;
typedef U32 OFFSET_ADDR_TYPE;
typedef U32 VAR_SIZE;       /* represents the size in MAUs of the variable */
typedef U32 STATIC_VAR_ADDR;     /* ATN 3: logical address of static var */
typedef U32 GLOBAL_VAR_ADDR;     /* ATN 8: logical address of global var */
typedef S32 AUTO_VAR_OFFSET;     /* ATN 1: automatic var offset */

typedef struct {          /* NOTE: this is different than the ADDR_PAIR */
    OFFSET_ADDR_TYPE offsetStartAddr;
    OFFSET_ADDR_TYPE offsetEndAddr;
} OFFSET_ADDR_RANGE_TYPE;

/* a SYM_DESCRIPTOR is an abstract index, or pointer, to a symbol; also called
   an opaque structure.  It can refer to a first-level symbol such as a
   module, to the next level such as a function, or to a lower level such as a
   local variable within a function. */

typedef U32 SYM_DESCRIPTOR;
                      /* magic cookie for accessing any created symbol */

typedef U32 LINENUM_DESCRIPTOR;  /* access to a line number */

typedef U32 BASE_ADDRESS;  /* ADDRESS OF BASE */

typedef U16 BASE_INDEX;

typedef enum {      /* types of base addresses that will relocate */
                    /* modules based on the codeBase value */
    BASE_UNKNOWN,
    BASE_CODE,
    BASE_DATA,
    BASE_CODE_DATA
} BASE_TYPE;

typedef enum {
   SYM_CODE_ADDR,
   SYM_DATA_ADDR,
   SYM_UNKNOWN_ADDR
} BASIC_SYM_ADDR_TYPE;

/*
typedef enum {
    SEG_UNTYPED,
    SEG_CODE,
    SEG_DATA,
    SEG_XDATA,
    SEG_BIT,
    SEG_REGISTER,
    SEG_CONST
} SEGMENTTYPE;
*/
typedef enum {
    SEG_UNTYPED,
    SEG_NORMAL,
    SEG_CODE,
    SEG_XDATA,
    SEG_DATA,
    SEG_REGISTER,
    SEG_BIT,
    SEG_SFR,
    SEG_CONST
} SEGMENTTYPE;

typedef enum {
    CT_MODULE,
    CT_FUNCTION,
    CT_LINENUM,
    CT_UNKNOWN
} CODE_CLASS;

typedef enum {
    ST_UNDEFINED,
    ST_BREAK,
    ST_CONTINUE,
    ST_DO_WHILE,
    ST_FOR_INIT,
    ST_FOR_COND,
    ST_FOR_UPDATE,
    ST_GOTO,
    ST_IF,
    ST_RETURN,
    ST_SWITCH,
    ST_WHILE,
    ST_EXPRESSION,
    ST_IMP_RETURN,
    ST_FUNC_BEGIN,
    ST_UNKNOWN
} STATEMENT_TYPE;

typedef enum {    /* For 8051 only */
    NONE_51,
    IDATA_51,
    XDATA_51,
    PDATA_51,
    DATA_51,
    CODE_51,
    UNKNOWN_51
} MEMORY_TYPE;

typedef struct {
    SEGMENTTYPE      segType;
    OFFSET_ADDR_TYPE addr;
} ADDRESS_TYPE;

typedef struct {
   COLUMN_TYPE columnStart;
   COLUMN_TYPE columnEnd;
} COLUMN_RANGE_TYPE;

typedef struct {
   LINENUM_TYPE lineNumStart;
   COLUMN_TYPE  columnStart;
   LINENUM_TYPE lineNumEnd;
   COLUMN_TYPE columnEnd;
} SOURCE_RANGE_TYPE;

// list of built-in types supported and their value assignments; defined
// in IEEE695 document, pp A-6..A-7
typedef enum {
   BI_UNKNOWN        =  0,     // ?
   BI_VOID           =  1,     // V
   BI_S8_SCHAR       =  2,     // B
   BI_U8_UCHAR       =  3,     // C
   BI_S16_SINT       =  4,     // H
   BI_U16_UINT       =  5,     // I
   BI_S32_SLONG      =  6,     // L
   BI_U32_ULONG      =  7,     // M
   BI_S64_SLONG      =  8,     // W
   BI_U64_ULONG      =  9,     // Y
   BI_F32            = 10,     // F
   BI_F64            = 11,     // D
   BI_F_EXTEND       = 12,     // K F80 or F96 (uP dependent)
   BI_F128           = 13,     // Q
   BI_STRING         = 14,     // QUOTED STRING
   BI_JUMP           = 15,     // J JUMP TO (LABEL)
   BI_STACK_INT      = 16,     // INT
   BI_STACK_U        = 17,     // UNSIGNED
   BI_STACK_UINT     = 18,     // UNSIGNED INT
   BI_S8_CHAR        = 19,     // CHAR
   BI_S32_LONG       = 20,     // LONG
   BI_S16_SHORT      = 21,     // SHORT
   BI_S16_USHORT     = 22,     // UNSIGNED SHORT
   BI_S16_SHORTINT   = 23,     // SHORTINT
   BI_S16_SSHORT     = 24,     // SIGNED SHORT
   BI_F64_BCD        = 25,     // BCD FLOAT
   BI_BIT            = 26,     // 51 SBIT   

   BI_P_UNKNOWN      = 32,     // POINTER to UNKNOWN
   BI_P_VOID         = 33,     // P to PROC RETURNING VOID
   BI_P_S8_SCHAR     = 34,     // P to ...
   BI_P_U8_UCHAR     = 35,     //
   BI_P_S16_SINT     = 36,     //
   BI_P_U16_UINT     = 37,     //
   BI_P_S32_SLONG    = 38,     //
   BI_P_U32_ULONG    = 39,     //
   BI_P_S64_SLONG    = 40,     //
   BI_P_U64_ULONG    = 41,     //
   BI_P_F32          = 42,     //
   BI_P_F64          = 43,     //
   BI_P_F_EXTEND     = 44,     // P to F80 or F96 (uP dependent)
   BI_P_F128         = 45,     //
   BI_P_STRING       = 46,     // P to QUOTED STRING
   BI_P_JUMP         = 47,     // P to INSTRUCTION ADDRESS
   BI_P_STACK_INT    = 48,     // P to INT
   BI_P_STACK_U      = 49,     // P to UNSIGNED
   BI_P_STACK_UINT   = 50,     // P to UNSIGNED INT
   BI_P_S8_CHAR      = 51,     // P to CHAR
   BI_P_S32_LONG     = 52,     // P to LONG
   BI_P_S16_SHORT    = 53,     // P to SHORT
   BI_P_S16_USHORT   = 54,     // P to UNSIGNED SHORT
   BI_P_S16_SHORTINT = 55,     // P to SHORTINT
   BI_P_S16_SSHORT   = 56,     // P to SIGNED SHORT
   BI_P_F64_BCD      = 57,     // P to BCD FLOAT

} BUILT_IN_TYPE;

// list of complex types supported and their value assignments; defined
// in IEEE695 document, pp A-1..A-4
typedef enum {
   TY_16_16_PTR   = 0x00,  // new value for Intel ptr type with
                           // 16 bit segment/selector, 16 bit offset
   TY_16_32_PTR   = 0x01,  // new value for Intel ptr type with
                           // 16 bit selector, 32 bit offset
   TY_REGISTER    = 0x02,  // register type for OMF86/386

   TY_ATTRIBUTE   = 0x03,  // special types for UBROF format
   TY_DPTR0       = 0x04,
   TY_DPTR1       = 0x05,
   TY_DPTR2       = 0x06,
   TY_DPTR3       = 0x07,
   TY_DPTR4       = 0x08,
   TY_DPTR5       = 0x09,
   TY_DPTR6       = 0x0A,
   TY_DPTR7       = 0x0B,
   TY_CPTR0       = 0x0C,
   TY_CPTR1       = 0x0D,
   TY_CPTR2       = 0x0E,
   TY_CPTR3       = 0x0F,
   TY_OMF51_ARRAY = 0x10,
   TY_OMF51_PTR   = 0x11,

   TY_UNKNOWN     = 0x21,  // ! IEEE-695
   TY_ENUM_PASCAL = 0x45,  // E
   TY_GENERAL     = 0x47,  // G
   TY_ENUM_C      = 0x4E,  // N
   TY_SMALL_PTR   = 0x4F,  // O
   TY_LARGE_PTR   = 0x50,  // P
   TY_RANGE       = 0x52,  // R
   TY_STRUCT      = 0x53,  // S
   TY_TYPE        = 0x54,  // T
   TY_UNION       = 0x55,  // U
   TY_VOID        = 0x56,  // V
   TY_FUNC_NODEP  = 0x58,  // X
   TY_C_ARRAY     = 0x5A,  // Z
   TY_BITFIELD    = 0x67,  // g
   TY_FUNC_DEP    = 0x78,  // x,  TY_FUNCTION
} COMPLEX_TYPE;

typedef U8 SCALAR_TYPE;
/* Holds instance of the scalar type; IEEE695 defines 57 (with gaps), with
   reserved types up to 255.  Could become an enum with a large number of
   components. */

// based on UBROF
//typedef enum {
//   TY_UNDEFINED   =  0,
//   TY_U8_UCHAR    =  1,
//   TY_S8_SCHAR    =  2,
//   TY_U16_USHORT  =  3,
//   TY_S16_SHORT   =  4,
//   TY_U16_UINT    =  5,
//   TY_S16_SINT    =  6,
//   TY_U32_ULONG   =  7,
//   TY_S32_SLONG   =  8,
//   TY_F32_FLOAT   =  9,
//   TY_F64_DOUBLE  = 10,
//   TY_F_EXTEND    = 11,   // long double
//   TY_VOID        = 12,
//   TY_ADDRESS     = 14,
//   TY_POINTER     = 15,
//   TY_ARRAY       = 16,
//   TY_STRUCT      = 17,
//   TY_UNION       = 18,
//   TY_BITFIELD    = 19,
//   TY_FUNCTION    = 20,
//   TY_ATTRIBUTE   = 21,
//   TY_DPTR0       = 23,
//   TY_DPTR1       = 24,
//   TY_DPTR2       = 25,
//   TY_DPTR3       = 26,
//   TY_DPTR4       = 27,
//   TY_DPTR5       = 28,
//   TY_DPTR6       = 29,
//   TY_DPTR7       = 30,
//   TY_CPTR0       = 31,
//   TY_CPTR1       = 32,
//   TY_CPTR2       = 33,
//   TY_CPTR3       = 34,
//   TY_ENUM        = 40, // not defined by UBROF
//   TY_TYPE        = 41, // not defined by UBROF
//   TY_LONGJUMP    = 42, // not defined by UBROF
//   TY_SHORTJUMP   = 43, // not defined by UBROF
//   TY_F128        = 44, // not defined by UBROF
//} DATA_TYPE;

typedef enum{       /* two types of constants */
    CONST_NUMERIC,
    CONST_STRING
} CONSTANT_TYPE;

typedef enum {
    FUNC_GLOBAL,
    FUNC_LOCAL
} FUNC_CLASS;

typedef struct {
    SEGMENTTYPE       segType;
    OFFSET_ADDR_TYPE  startAddr;
    OFFSET_ADDR_TYPE  endAddr;
} ADDR_RANGE_TYPE;

typedef enum {
    CODE_ADDR, DATA_ADDR, STACK_ADDR, HEAP_ADDR, ILLEGAL_ADDR, UNDEFINED_ADDR
} MEM_ADDR_CLASS;

typedef struct {
    OFFSET_ADDR_TYPE startAddr;      /* symbol address */
    OFFSET_ADDR_TYPE endAddr;        /*     "        */
    BOOLEAN          startValid;     /* whether startAddr is to be stored or not */
    BOOLEAN          endValid;       /* whether endAddr is to be stored or not */
} QUAL_ADDR_RANGE_TYPE;

typedef struct {        /* open-ended list */
    U16 itemCount;
    ADDR_RANGE_TYPE addrRange;    /* may be more than one */
} RANGE_LIST_TYPE;

typedef U8 SIMPLE_TYPE;   /* holds the simple "built-in" type number */

typedef enum {    /* this list may change */
    SYM_ROOT = 0,
    SYM_MODULE,
    SYM_FUNCTION,
    SYM_BLOCK,
    SYM_GLOBAL_VAR,
    SYM_LOCAL_VAR,
    SYM_LABEL,
    SYM_CONSTANT,
    SYM_TYPE,
    SYM_USER_DEFINED_VAR,
    SYM_USER_DEFINED_LABEL,
    SYM_PUBLIC_VAR,
    SYM_PUBLIC_LABEL,
    SYM_PUBLIC_UNKNOWN,
    SYM_MACRO,
    SYM_MISCELLANEOUS,
    SYM_UNDEFINED,
    MAX_SYM_TYPE   /* This must always be the last enum element */
} SYM_TYPE_TYPE;

typedef enum {
    SIMPLE_TYPE_CLASS, /* 695 calls these build-in types; e.g. int, char... */
    COMPLEX_TYPE_CLASS /* called high-level types; e.g. struct, enum */
} TYPE_CLASS;

typedef struct {
    U16 year;
    U8  month;
    U8  day;
    U8  hour;
    U8  minute;
    U8  second;
} TIMESTAMP_TYPE;

typedef U32 TYPE_INDEX;      /* index value into type table */

typedef struct {
    TYPE_INDEX typeIndex;
    SEGMENTTYPE segType;
} TYPE_TYPE;

/* common information at head of each TYPE */
typedef struct {
    TYPE_CLASS typeChoice;   /* determines access to union */
    union {
        SIMPLE_TYPE simpleType;
        COMPLEX_TYPE complexType;
    } t;
    U32 sizeInMAUs;          /* number of MAUs that make up the type */
    LPSTR typeName;          /* empty string if type doesn't have name */
    BOOLEAN sizeCalculated;  /* flag to indicate that MAU is known for type */
} TYPE_HEADER_TYPE;       /* use MAX_SYMNAME_LENGTH */

/* (G) data structure containing bit fields type */
typedef struct {
    LPSTR name;              /* name of field; use MAX_SYMNAME_LENGTH */
    TYPE_INDEX typeIndex;    /* index to type */
    U16 bitOffset;           /* bit offset */
    U16 bitSize;             /* number of bits */
} TYPE_G_STRUCT;

/* (g) bitfield type */
typedef struct {
    U8  bitfieldSigned;         /* 0=signed, 1=unsigned */
    U8  offset;                 /* offset int type */
    U16 size;                   /* size in bits, 1 thru n */
    TYPE_INDEX baseTypeIndex;   /* base index type */
} TYPE_BITFIELD_STRUCT;

/* (R) Range of another type structure */
typedef struct {
    S32 lowBound;
    S32 highBound;
    U8  rangeSigned;        /* 0=unsigned, 1=signed */
} TYPE_R_STRUCT;

/* (S,U) data structure and union types */
typedef struct {
    LPSTR name;             /* name of field; use MAX_SYMNAME_LENGTH */
    TYPE_INDEX typeIndex;   /* index to type */
    U16 offset;             /* offset; for (S), if typeIndex is (g), offset*/
                            /* is in bits, otherwise in MAUs */
} TYPE_S_U_STRUCT;

/* (Z) C array with lower bound = 0 structure */
typedef struct {
    TYPE_INDEX typeIndex;
    S32 highBound;          /* When upper limit unknown (e.g. externals) */
                            /* highBound should be set to -1 */
} TYPE_C_ARRAY_STRUCT;

typedef struct {
    TYPE_INDEX typeIndex;
    U8  dim;                /* number of dimensions */
} TYPE_OMF51_ARRAY_STRUCT;

typedef U16 DIMENSION;

typedef TYPE_C_ARRAY_STRUCT TYPE_Z_STRUCT ;

/* OMF51 Pointer structure */
typedef struct {
    TYPE_INDEX  typeIndex;
    U8          attribute; // 1: 3-byte ptr, 2: spaced ptr, 3: 3-byte reverse ptr
    U8          ptrSpec;   // 1: data ptr, 2: function ptr, 4: huge ptr;
    MEMORY_TYPE memSpace;
} TYPE_OMF51_PTR_STRUCT;

/* variable address types (address is an abstract term here). These map to the
   address field of the variable record */

/* Variable lifetime typedefs */
typedef enum {
   LIVE,   /* indicates that register variable is valid */
   DEAD    /*            "                        invalid */
} VAR_LIFETIME_STATE;

typedef struct {
   AUTO_VAR_OFFSET autoVarOffset;
   VAR_SIZE        autoVarSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_AUTO_VAR;

typedef U16 REG_INDEX;

typedef REG_INDEX VAR_LIVING_REG;  /* ATN 2: index of living register */
                                   /* the value is processor dependent */
typedef struct {
   VAR_LIVING_REG     varLivingReg;
   VAR_SIZE           varSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_LIVING_REG;

typedef struct {                 /* ATN 10: locked register var */
   REG_INDEX       regIndex;
   AUTO_VAR_OFFSET autoVarOffset;
} VAR_LOCKED_REG;

typedef struct {                 /* ATN 10: locked register var */
   VAR_LOCKED_REG  getRegIndex;
   VAR_SIZE        varSize;
   AUTO_VAR_OFFSET autoVarOffset;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_LOCKED_REG;

typedef struct {             /* ATN 12: based variable */
    U32 offsetVal;
    U32 baseSize;            /* interpreted by controlNum */
    U8  controlNum;          /* values 0-4 defined */
    U8  publicLocal;         /* 0=local, 1=public */
    U8  memorySpace;         /* memory space indicator value */
} VAR_BASED_VAR;

typedef struct {
   VAR_BASED_VAR basedVar;
   VAR_SIZE      varSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_BASED_VAR;

typedef union {
   GET_AUTO_VAR       getAutoVar;
   GET_VAR_LIVING_REG getRegisterIndex;
   GET_VAR_LOCKED_REG getLockedReg;
   GET_VAR_BASED_VAR  getBasedVar;
} GET_VAR_ADDR_UNION;

typedef struct {
   ADDR_RANGE_TYPE    fixedAddr;
   GET_VAR_ADDR_UNION addrData;
} GET_VAR_ADDR_STRUCT;    /* used to pass address information to caller */

typedef union {
   U32             fixedAddr;   /* covers both global and static vars */
   AUTO_VAR_OFFSET autoVar;
   VAR_LIVING_REG  registerIndex;
   VAR_LOCKED_REG  lockedReg;
   VAR_BASED_VAR   basedVar;
   ADDRESS_TYPE    addr;
} ADD_VAR_ADDR_UNION;    /* used to pass address information to caller */

typedef enum{
    AUTO_VAR_CLASS,
    STATIC_VAR_CLASS,
    GLOBAL_VAR_CLASS,
    BASED_VAR_CLASS,
    UNKNOWN_VAR_CLASS
} VAR_STORAGE_CLASS;

typedef enum{
    NOT_REG,
    LIVING_REG,
    SHADOW_REG,
    LOCKED_REG
} VAR_REGISTER_CLASS;

typedef struct {
    ADDRESS_TYPE          lifetimeAddr;
    VAR_LIFETIME_STATE lifetimeClass;
} VAR_LIFETIME_INFO;

typedef enum{
    SEG_SPACE_USER,
    SEG_SPACE_SMM
} SEG_ADDR_SPACE;  // defines the two types of segment spaces

typedef enum {  // defines 2 Intel modes and Moto
    SYM_REAL,
    SYM_PROTECTED,
    SYM_NONE    // Moto mode
} SYM_MODE;

typedef enum {
   NEAR_16,
   FAR_16,
   INTERRUPT_286,
   NEAR_32,
   FAR_32,
   INTERRUPT_386
}  INTEL_FUNC_RETURN_ATTRIB;

#ifdef __cplusplus
}
#endif

#define _SYMDEFINE_
#endif
/******************************** E O F ***********************************/
