
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMHEAP.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMHEAP.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  heap.h
**
**  Description:
**     prototypes for Malloc() and Free() routines.
**
**  Status:  CODED
**
**  $Log$
** 
**  $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMHEAP.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HEAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symwind.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  TFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via Malloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**        randomPointer: A pointer returned by Malloc().
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**     ER_NOT_FOUND       -- could not find pointer info.  Is it ours?
**     ER_HEAP_CORRUPT    -- someone wrote outside of their allocation,
**                           and all over our internal data structures.
**                           This is FATAL for us!!
**
*****************************************************************************/
RETCODE WINAPI TFree( LPSTR randomPointer ) ;



/****************************************************************************
**
**  TMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the heap!!
**
**  Parameters:
**     input:
**        numBytes: the number of bytes to allocate (< 64KB)
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/
LPSTR WINAPI TMalloc( U32 numBytes ) ;   /* numBytes < 64 KB */


#ifdef __cplusplus
}
#endif

#define _HEAP_
#endif
/******************************** E O F ***********************************/
