
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMOBJ.CPP   1.0   15 Aug 1997 14:04:16   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMOBJ.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:04:16   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMOBJ.CPP
**
**  Description:
**      member function of class CSymObj
**
**  Status:  CODED
**
**    Rev 1.0   27 Feb. 1996 15:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <memory.h>
#include <string.h>
#include "symobj.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          *
*  InitStrCmd  --  save expression string to m_strCmd                      *
*  parameter :                                                             *
*       pStrSrc  --  expression string                                     *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::InitStrCmd(const char* pStrSrc, int flag)
{
    if ( m_strCmd ) delete []m_strCmd;
    m_strCmd = 0;
    if ( pStrSrc == 0 ) return;
    int nLen = strlen( pStrSrc );
    m_strCmd = new char [ nLen+1 ];
    if ( m_strCmd == 0 ) {
        m_nErrNo = 1;
        return;      
    }
    memcpy(m_strCmd , pStrSrc, nLen);
    m_strCmd[nLen] = '\0';
    m_nLen = nLen;   
    m_nCmdFlag = flag;
    return;
}

/***************************************************************************
*                                                                          *
*  SkipLeftSpace  --  skip over space                                      *
*  parameter :                                                             *
*       pStrSrc  --  input string                                          *
*       pStrRst  --  output string                                         *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipLeftSpace(char* pStrSrc, char*& pStrRst)
{
    pStrRst = 0;
    if ( pStrSrc == 0 ) {
        m_nErrNo = 3;
        return;      
    }
    char *pStr;
    
    pStr = pStrSrc;
    while( *pStr == ' ' ) {
        pStr++;
    }
    pStrRst = pStr; 
    return;
}

/***************************************************************************
*                                                                          *
*  SkipLeftSpace  --  skip over space                                      *
*  parameter :                                                             *
*       nPos  --   start pos in string m_strCmd                            *
*       nResultPos  --  no whitespace first pos in string m_strCmd         *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipLeftSpace(int nPos, int &nResultPos)
{
    nResultPos = nPos;
    if ( m_strCmd == 0 ) {
        m_nErrNo = 2;
        return;
    }    
//    if ( m_nLen <= nPos ) {
    if ( m_nLen == nPos ) {
    	return;
    }
    if ( m_nLen < nPos ) {
        m_nErrNo = 3;
        return;      
    }
    char *pStr;
    
    pStr = &m_strCmd[nPos];
    while( *pStr == ' ' ) {
        nResultPos++;
        pStr++;
    }
    return;
}

/***************************************************************************
*                                                                          *
*  SkipRightSpace  --  skip over space                                      *
*  parameter :                                                             *
*       pStrSrc  --  input string                                          *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipRightSpace(char* pStrSrc)
{
	int nLen;
	if ( 0 == pStrSrc ) return;
	nLen = strlen( pStrSrc );
	if ( 0 == nLen ) return;
	while( nLen ) {
		if ( pStrSrc[ nLen-1 ] != ' ' ) break;
		nLen--;
	}
	pStrSrc[nLen] = '\0'; 
    return;
}
/******************************** E O F ***********************************/
