
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMSTACK.H__   1.0   15 Aug 1997 14:04:22   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMSTACK.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:22   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMSTACK.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymStack
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMSTACK_H_
#define _SYMSTACK_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        
struct StackNode {
	void * pNode;
	struct StackNode *next;
	struct StackNode *prev;
public :
	StackNode() {
		pNode = 0;
		next = 0;
		prev = 0;
	}
};

class CSymStack {                 
public :
    CSymStack() {
    	m_pTop = 0;
    	m_pBottom = 0;
    }
    ~CSymStack() {      
		DeleteStack();
    }
     
private :       
	struct StackNode *m_pTop;
	struct StackNode *m_pBottom;
    
public :
	int IsEmpty(void);
	int DeleteStack(void);
	int Push(void* pNode);	
	int Pop(void*& pNode);
};
                
#endif
/******************************** E O F ***********************************/
