
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMTOKEN.H__   1.0   15 Aug 1997 14:04:22   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMTOKEN.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:22   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMTOKEN.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymToken
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   4 March 1996 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMTOKEN_H_
#define _SYMTOKEN_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symobj.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef enum {
    SYMTOKEN_NULL = 0,
    SYMTOKEN_NUM ,
    SYMTOKEN_FLOAT ,
    SYMTOKEN_SYMBOL ,
    SYMTOKEN_OPERATOR1 ,                        
    SYMTOKEN_OPERATOR2 ,
    SYMTOKEN_LEFTPARENTHESES,
    SYMTOKEN_RIGHTPARENTHESES,
    SYMTOKEN_LEFTBRANKETS,
    SYMTOKEN_RIGHTBRANKETS,
    SYMTOKEN_OPERATOR,
    SYMTOKEN_UNKNOWN
} SYMTOKENTYPE;

#define MAX_OPT_NUM     40
/////////////////////////////////
//   0  --  unknown
//   1  --  +  ( one )
//   2  --  -  ( one )
//   3  --  ~  ( one )
//   4  --  !  ( one )
//   5  --  *  ( pointer )
//   6  --  (    
//   7  --  )    
//   8  --  [  ( array )
//   9  --  ]  ( array )
//  10  --  -> ( struct pointer )
//  11  --  .  ( struct )
//  12  --  *  ( mul )
//  13  --  /  ( div )
//  14  --  %  ( mod )
//  15  --  +  ( add )
//  16  --  -  ( del )
//  17  --  >> 
//  18  --  <<
//  19  --  <  
//  20  --  >
//  21  --  <=
//  22  --  >=
//  23  --  ==
//  24  --  !=
//  25  --  &
//  26  --  ^
//  27  --  |
//  28  --  &&
//  29  --  ||
//  30  --  =
//  31  --  +=
//  32  --  -=
//  33  --  *=
//  34  --  /=
//  35  --  %=
//  36  --  ++ ( prev )
//  37  --  -- ( prev )
//  38  --  ++ 
//  39  --  --
//
/////////////////////////////////
    
typedef union {
    char c;
    unsigned char uc;
    short i;
    unsigned short ui;
    long l;
    unsigned long ul;
    double d;        
} ExpressionValue;

typedef struct SYM_TOKEN_NODE {
	int nTkNum;
    SYMTOKENTYPE symType ;
    int typeOpt;
    BUILT_IN_TYPE typeValue;
    ExpressionValue result;
    SYM_DESCRIPTOR symDesc;
    ADDRESS_TYPE addr;
	TYPE_INDEX typeIndex;
	BOOLEAN isGlobal;
	int nComplexType;
	struct SYM_TOKEN_NODE *next;
    struct SYM_TOKEN_NODE *prev;

public :
    SYM_TOKEN_NODE() {
    	nTkNum = -1;
        symType = SYMTOKEN_UNKNOWN;
        typeOpt = 0;       
        typeValue = BI_UNKNOWN;
        result.l = 0L;
        symDesc = 0L;
        nComplexType = 0;
        next = 0;
        prev = 0;
    }
} SYM_TOKEN_NODE;   
                
    
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        
class CSymToken : public CSymObj {
protected :
    CSymToken() : CSymObj() {
        m_pTokenPos = 0;
        m_nMaxTokenNum = 0;
        m_nCurTokenNum = 0;
        m_nCurPos = 0;
        m_lastTokenType = SYMTOKEN_NULL;
        m_pTokenList = 0;
        m_pLastToken = 0;
        m_nCurrentToken = 0;
        m_pCurToken = 0;
    }
    ~CSymToken() {          
        DeleteTokenList();
        if ( m_pTokenPos ) delete []m_pTokenPos;
        m_pTokenPos = 0;
        m_nMaxTokenNum = 0;
        m_nCurTokenNum = 0;
        m_nCurPos = 0;
    }
     
protected :
    int *m_pTokenPos;
    int m_nMaxTokenNum;
    int m_nCurTokenNum;
    int m_nCurPos;
    SYMTOKENTYPE m_lastTokenType;            
    SYM_TOKEN_NODE *m_pTokenList;
    SYM_TOKEN_NODE *m_pLastToken;
    int m_nCurrentToken;
    SYM_TOKEN_NODE *m_pCurToken;
    
public :
	int GetTokenNum(void) {
		return  m_nCurTokenNum;
	}
	int GetOneTokenName(int nNum , char*& pName);
		
protected :
    void DeleteTokenList(void);
    void DisplayOneToken(SYM_TOKEN_NODE *pNode);
    int ResizePosArray(int nMax); 
    int AddOneTokenToList(SYM_TOKEN_NODE *pNode);
    int GetOneTokenFromList(int num, SYM_TOKEN_NODE *& pNode); 
        // num from 1 ;
    int GetNextToken(SYM_TOKEN_NODE *pNode);
    int GetNumber(SYM_TOKEN_NODE *pNode);
    int GetFloat(SYM_TOKEN_NODE *pNode);
    int GetSymbol(SYM_TOKEN_NODE *pNode);
    int GetOperator(SYM_TOKEN_NODE *pNode);
    BOOL IsOperate(char c);
	int GetSymbolValue(SYM_TOKEN_NODE *pNode);
	
public :	
    int GetAllTokenNameToStr(CString& strName);    
	int UpdateSymbol(SYM_TOKEN_NODE *pNode,char *pContent);
};
                
#endif
/******************************** E O F ***********************************/
